## Sid Meier's Civilization 4
## Copyright Firaxis Games 2006
## 
## CvEventManager
## This class is passed an argsList from CvAppInterface.onEvent
## The argsList can contain anything from mouse location to key info
## The EVENTLIST that are being notified can be found 


from CvPythonExtensions import *
import CvUtil
import CvScreensInterface
import CvDebugTools
import CvWBPopups
import PyHelpers
import Popup as PyPopup
import CvCameraControls
import CvTopCivs
import sys
import CvWorldBuilderScreen
import CvAdvisorUtils
import CvTechChooser

gc = CyGlobalContext()
localText = CyTranslator()
PyPlayer = PyHelpers.PyPlayer
PyInfo = PyHelpers.PyInfo

def any(iterable):
    for item in iterable:
        if item: return True
    return False

# globals
###################################################
class CvEventManager:
	def __init__(self):

		# NetMessage ID #s
		self.m_iNetMessage_Inquisitor = 0

		#################### ON EVENT MAP ######################
		#print "EVENTMANAGER INIT"
				
		self.bCtrl = False
		self.bShift = False
		self.bAlt = False
		self.bAllowCheats = False

		# OnEvent Enums
		self.EventLButtonDown=1
		self.EventLcButtonDblClick=2
		self.EventRButtonDown=3
		self.EventBack=4
		self.EventForward=5
		self.EventKeyDown=6
		self.EventKeyUp=7
	
		self.__LOG_MOVEMENT = 0
		self.__LOG_BUILDING = 0
		self.__LOG_COMBAT = 0
		self.__LOG_CONTACT = 0
		self.__LOG_IMPROVEMENT =0
		self.__LOG_CITYLOST = 0
		self.__LOG_CITYBUILDING = 0
		self.__LOG_TECH = 0
		self.__LOG_UNITBUILD = 0
		self.__LOG_UNITKILLED = 1
		self.__LOG_UNITLOST = 0
		self.__LOG_UNITPROMOTED = 0
		self.__LOG_UNITSELECTED = 0
		self.__LOG_UNITPILLAGE = 0
		self.__LOG_GOODYRECEIVED = 0
		self.__LOG_GREATPERSON = 0
		self.__LOG_RELIGION = 0
		self.__LOG_RELIGIONSPREAD = 0
		self.__LOG_GOLDENAGE = 0
		self.__LOG_ENDGOLDENAGE = 0
		self.__LOG_WARPEACE = 0
		self.__LOG_PUSH_MISSION = 0
		
		## EVENTLIST
		self.EventHandlerMap = {
			'mouseEvent'			: self.onMouseEvent,
			'kbdEvent' 				: self.onKbdEvent,
			'ModNetMessage'					: self.onModNetMessage,
			'Init'					: self.onInit,
			'Update'				: self.onUpdate,
			'UnInit'				: self.onUnInit,
			'OnSave'				: self.onSaveGame,
			'OnPreSave'				: self.onPreSave,
			'OnLoad'				: self.onLoadGame,
			'GameStart'				: self.onGameStart,
			'GameEnd'				: self.onGameEnd,
			'plotRevealed' 			: self.onPlotRevealed,
			'plotFeatureRemoved' 	: self.onPlotFeatureRemoved,
			'plotPicked'			: self.onPlotPicked,
			'nukeExplosion'			: self.onNukeExplosion,
			'gotoPlotSet'			: self.onGotoPlotSet,
			'BeginGameTurn'			: self.onBeginGameTurn,
			'EndGameTurn'			: self.onEndGameTurn,
			'BeginPlayerTurn'		: self.onBeginPlayerTurn,
			'EndPlayerTurn'			: self.onEndPlayerTurn,
			'endTurnReady'			: self.onEndTurnReady,
			'combatResult' 			: self.onCombatResult,
		  'combatLogCalc'	 		: self.onCombatLogCalc,
		  'combatLogHit'				: self.onCombatLogHit,
			'improvementBuilt' 		: self.onImprovementBuilt,
			'improvementDestroyed' 		: self.onImprovementDestroyed,
			'routeBuilt' 		: self.onRouteBuilt,
			'firstContact' 			: self.onFirstContact,
			'cityBuilt' 			: self.onCityBuilt,
			'cityRazed'				: self.onCityRazed,
			'cityAcquired' 			: self.onCityAcquired,
			'cityAcquiredAndKept' 	: self.onCityAcquiredAndKept,
			'cityLost'				: self.onCityLost,
			'cultureExpansion' 		: self.onCultureExpansion,
			'cityGrowth' 			: self.onCityGrowth,
			'cityDoTurn' 			: self.onCityDoTurn,
			'cityBuildingUnit'	: self.onCityBuildingUnit,
			'cityBuildingBuilding'	: self.onCityBuildingBuilding,
			'cityRename'				: self.onCityRename,
			'cityHurry'				: self.onCityHurry,
			'selectionGroupPushMission'		: self.onSelectionGroupPushMission,
			'unitMove' 				: self.onUnitMove,
			'unitSetXY' 			: self.onUnitSetXY,
			'unitCreated' 			: self.onUnitCreated,
			'unitBuilt' 			: self.onUnitBuilt,
			'unitKilled'			: self.onUnitKilled,
			'unitLost'				: self.onUnitLost,
			'unitPromoted'			: self.onUnitPromoted,
###Begin on Unit Upgrade 1
			'unitUpgraded'			: self.onUnitUpgraded,
###End on Unit Upgrade 1
			'unitSelected'			: self.onUnitSelected, 
			'UnitRename'				: self.onUnitRename,
			'unitPillage'				: self.onUnitPillage,
			'unitSpreadReligionAttempt'	: self.onUnitSpreadReligionAttempt,
			'unitGifted'				: self.onUnitGifted,
			'unitBuildImprovement'				: self.onUnitBuildImprovement,
			'goodyReceived'        	: self.onGoodyReceived,
			'greatPersonBorn'      	: self.onGreatPersonBorn,
###Begin on CityStateMission 1
			'CityStateMission'			: self.onCityStateMission,
###End on CityStateMission 1
			'buildingBuilt' 		: self.onBuildingBuilt,
			'projectBuilt' 			: self.onProjectBuilt,
			'techAcquired'			: self.onTechAcquired,
			'techSelected'			: self.onTechSelected,
			'religionFounded'		: self.onReligionFounded,
			'religionSpread'		: self.onReligionSpread, 
			'religionRemove'		: self.onReligionRemove, 
			'corporationFounded'	: self.onCorporationFounded,
			'corporationSpread'		: self.onCorporationSpread, 
			'corporationRemove'		: self.onCorporationRemove, 
			'goldenAge'				: self.onGoldenAge,
			'endGoldenAge'			: self.onEndGoldenAge,
			'chat' 					: self.onChat,
			'victory'				: self.onVictory,
			'vassalState'			: self.onVassalState,
			'changeWar'				: self.onChangeWar,
			'setPlayerAlive'		: self.onSetPlayerAlive,
			'playerChangeStateReligion'		: self.onPlayerChangeStateReligion,
			'playerGoldTrade'		: self.onPlayerGoldTrade,
			'windowActivation'		: self.onWindowActivation,
			'gameUpdate'			: self.onGameUpdate,		# sample generic event
		}

		################## Events List ###############################
		#
		# Dictionary of Events, indexed by EventID (also used at popup context id)
		#   entries have name, beginFunction, applyFunction [, randomization weight...]
		#
		# Normal events first, random events after
		#	
		################## Events List ###############################
		self.Events={
			CvUtil.EventEditCityName : ('EditCityName', self.__eventEditCityNameApply, self.__eventEditCityNameBegin),
			CvUtil.EventEditCity : ('EditCity', self.__eventEditCityApply, self.__eventEditCityBegin),
			CvUtil.EventPlaceObject : ('PlaceObject', self.__eventPlaceObjectApply, self.__eventPlaceObjectBegin),
			CvUtil.EventAwardTechsAndGold: ('AwardTechsAndGold', self.__eventAwardTechsAndGoldApply, self.__eventAwardTechsAndGoldBegin),
			CvUtil.EventEditUnitName : ('EditUnitName', self.__eventEditUnitNameApply, self.__eventEditUnitNameBegin),
			CvUtil.EventWBAllPlotsPopup : ('WBAllPlotsPopup', self.__eventWBAllPlotsPopupApply, self.__eventWBAllPlotsPopupBegin),
			CvUtil.EventWBLandmarkPopup : ('WBLandmarkPopup', self.__eventWBLandmarkPopupApply, self.__eventWBLandmarkPopupBegin),
			CvUtil.EventWBScriptPopup : ('WBScriptPopup', self.__eventWBScriptPopupApply, self.__eventWBScriptPopupBegin),
			CvUtil.EventWBStartYearPopup : ('WBStartYearPopup', self.__eventWBStartYearPopupApply, self.__eventWBStartYearPopupBegin),
			CvUtil.EventShowWonder: ('ShowWonder', self.__eventShowWonderApply, self.__eventShowWonderBegin),
		}	
#################### EVENT STARTERS ######################
	def handleEvent(self, argsList):
		'EventMgr entry point'
		# extract the last 6 args in the list, the first arg has already been consumed
		self.origArgsList = argsList	# point to original
		tag = argsList[0]				# event type string
		idx = len(argsList)-6
		bDummy = false
		self.bDbg, bDummy, self.bAlt, self.bCtrl, self.bShift, self.bAllowCheats = argsList[idx:]
		ret = 0
		if self.EventHandlerMap.has_key(tag):
			fxn = self.EventHandlerMap[tag]
			ret = fxn(argsList[1:idx])
		return ret
		
#################### EVENT APPLY ######################	
	def beginEvent( self, context, argsList=-1 ):
		'Begin Event'
		entry = self.Events[context]
		return entry[2]( argsList )
	
	def applyEvent( self, argsList ):
		'Apply the effects of an event '
		context, playerID, netUserData, popupReturn = argsList
		
		if context == CvUtil.PopupTypeEffectViewer:
			return CvDebugTools.g_CvDebugTools.applyEffectViewer( playerID, netUserData, popupReturn )
		
		entry = self.Events[context]
				
		if ( context not in CvUtil.SilentEvents ):
			self.reportEvent(entry, context, (playerID, netUserData, popupReturn) )
		return entry[1]( playerID, netUserData, popupReturn )   # the apply function

	def reportEvent(self, entry, context, argsList):
		'Report an Event to Events.log '
		if (gc.getGame().getActivePlayer() != -1):
			message = "DEBUG Event: %s (%s)" %(entry[0], gc.getActivePlayer().getName())
			CyInterface().addImmediateMessage(message,"")
			CvUtil.pyPrint(message)
		return 0
		
#################### ON EVENTS ######################
	def onKbdEvent(self, argsList):
		'keypress handler - return 1 if the event was consumed'

		eventType,key,mx,my,px,py = argsList
		game = gc.getGame()
		
		if (self.bAllowCheats):
			# notify debug tools of input to allow it to override the control
			argsList = (eventType,key,self.bCtrl,self.bShift,self.bAlt,mx,my,px,py,gc.getGame().isNetworkMultiPlayer())
			if ( CvDebugTools.g_CvDebugTools.notifyInput(argsList) ):
				return 0
		
		if ( eventType == self.EventKeyDown ):
			theKey=int(key)
			
			CvCameraControls.g_CameraControls.handleInput( theKey )
						
			if (self.bAllowCheats):
				# Shift - T (Debug - No MP)
				if (theKey == int(InputTypes.KB_T)):
					if ( self.bShift ):
						self.beginEvent(CvUtil.EventAwardTechsAndGold)
						#self.beginEvent(CvUtil.EventCameraControlPopup)
						return 1
							
				elif (theKey == int(InputTypes.KB_W)):
					if ( self.bShift and self.bCtrl):
						self.beginEvent(CvUtil.EventShowWonder)
						return 1
							
				# Shift - ] (Debug - currently mouse-overd unit, health += 10
				elif (theKey == int(InputTypes.KB_LBRACKET) and self.bShift ):
					unit = CyMap().plot(px, py).getUnit(0)
					if ( not unit.isNone() ):
						d = min( unit.maxHitPoints()-1, unit.getDamage() + 10 )
						unit.setDamage( d, PlayerTypes.NO_PLAYER )
					
				# Shift - [ (Debug - currently mouse-overd unit, health -= 10
				elif (theKey == int(InputTypes.KB_RBRACKET) and self.bShift ):
					unit = CyMap().plot(px, py).getUnit(0)
					if ( not unit.isNone() ):
						d = max( 0, unit.getDamage() - 10 )
						unit.setDamage( d, PlayerTypes.NO_PLAYER )
					
				elif (theKey == int(InputTypes.KB_F1)):
					if ( self.bShift ):
						CvScreensInterface.replayScreen.showScreen(False)
						return 1
					# don't return 1 unless you want the input consumed
				
				elif (theKey == int(InputTypes.KB_F2)):
					if ( self.bShift ):
						import CvDebugInfoScreen
						CvScreensInterface.showDebugInfoScreen()
						return 1
				
				elif (theKey == int(InputTypes.KB_F3)):
					if ( self.bShift ):
						CvScreensInterface.showDanQuayleScreen(())
						return 1
						
				elif (theKey == int(InputTypes.KB_F4)):
					if ( self.bShift ):
						CvScreensInterface.showUnVictoryScreen(())
						return 1
											
		return 0

	def onModNetMessage(self, argsList):
		'Called whenever CyMessageControl().sendModNetMessage() is called - this is all for you modders!'
		
		iData1, iData2, iData3, iData4, iData5 = argsList

		iMessageID = iData1
		
		# Inquisitor's effect on a city
		if (iMessageID == self.m_iNetMessage_Inquisitor):
			
			iPlotX = iData2
			iPlotY = iData3
			iOwner = iData4
			iUnitID = iData5
			
			pPlot = CyMap().plot(iPlotX, iPlotY)
			pCity = pPlot.getPlotCity()
			
			pPlayer = gc.getPlayer(iOwner)
			pUnit = pPlayer.getUnit(iUnitID)
			
			iStateReligion = -1
			if (pPlayer.getStateReligion() != -1):
				iStateReligion = pPlayer.getStateReligion()
			
			# Loop through all religions, remove them from the city
			for iReligionLoop in range(gc.getNumReligionInfos()):
				if (iReligionLoop != iStateReligion):
					pCity.setHasReligion(iReligionLoop, 0, 0, 0)
		###Kathy Beginn: Inquisitoren vernichten Kultur
			for iPlayer in range (gc.getMAX_CIV_PLAYERS ()):
				if (iPlayer != iOwner):
					iOldCulture = pCity.getCulture(iPlayer)
					iNewCulture = iOldCulture*95/100
					pCity.setCulture(iPlayer,iNewCulture,false)
		###Kathy End Inquisitoren vernichten Kultur
			# Unit expended
			pUnit.kill(0, -1)
		# Inquisitor's effect on a city END

		print("Modder's net message!")
		
		CvUtil.pyPrint( 'onModNetMessage' )

	def onInit(self, argsList):
		'Called when Civ starts up'
		CvUtil.pyPrint( 'OnInit' )
		
	def onUpdate(self, argsList):
		'Called every frame'
		fDeltaTime = argsList[0]
		
		# allow camera to be updated
		CvCameraControls.g_CameraControls.onUpdate( fDeltaTime )
		
	def onWindowActivation(self, argsList):
		'Called when the game window activates or deactivates'
		bActive = argsList[0]
		
	def onUnInit(self, argsList):
		'Called when Civ shuts down'
		CvUtil.pyPrint('OnUnInit')
	
	def onPreSave(self, argsList):
		"called before a game is actually saved"
		CvUtil.pyPrint('OnPreSave')
	
	def onSaveGame(self, argsList):
		"return the string to be saved - Must be a string"
		return ""

	def onLoadGame(self, argsList):
		CvAdvisorUtils.resetNoLiberateCities()
		return 0

	def onGameStart(self, argsList):
		'Called at the start of the game'
		if (gc.getGame().getGameTurnYear() == gc.getDefineINT("START_YEAR") and not gc.getGame().isOption(GameOptionTypes.GAMEOPTION_ADVANCED_START)):
			for iPlayer in range(gc.getMAX_PLAYERS()):
				player = gc.getPlayer(iPlayer)
				if (player.isAlive() and player.isHuman()):
					popupInfo = CyPopupInfo()
					popupInfo.setButtonPopupType(ButtonPopupTypes.BUTTONPOPUP_PYTHON_SCREEN)
					popupInfo.setText(u"showDawnOfMan")
					popupInfo.addPopup(iPlayer)
		else:
			CyInterface().setSoundSelectionReady(true)

		if gc.getGame().isPbem():
			for iPlayer in range(gc.getMAX_PLAYERS()):
				player = gc.getPlayer(iPlayer)
				if (player.isAlive() and player.isHuman()):
					popupInfo = CyPopupInfo()
					popupInfo.setButtonPopupType(ButtonPopupTypes.BUTTONPOPUP_DETAILS)
					popupInfo.setOption1(true)
					popupInfo.addPopup(iPlayer)

###Tiefsee - berarbeitet von PIE
    		iNumMapPlots = gc.getMap().numPlots()
    		iDirectionTypes = DirectionTypes.NUM_DIRECTION_TYPES
    		iCoast = gc.getInfoTypeForString("TERRAIN_COAST")
    		iOcean = gc.getInfoTypeForString("TERRAIN_OCEAN")
    		iDeepOcean = gc.getInfoTypeForString("TERRAIN_TIEFSEE")
    		iFeat1 = gc.getInfoTypeForString("FEATURE_ISLANDS")
    		iFeat2 = gc.getInfoTypeForString("FEATURE_CORAL")
    		iFeat3 = gc.getInfoTypeForString("FEATURE_SANDBANK")
    		iFeat4 = gc.getInfoTypeForString("FEATURE_ATOLL")
    		iRange = 1

    		for i in range(iNumMapPlots):
      			pPlot = gc.getMap().plotByIndex(i)
      			if not pPlot.isNone() and pPlot.getTerrainType() == iOcean:
       				iX = pPlot.getX()
        			iY = pPlot.getY()
        			bSet = True
        			for x in range(-iRange, iRange+1):
          				for y in range(-iRange, iRange+1):
            					pLoopPlot = plotXY(iX, iY, x, y)
            					if pLoopPlot is None or pLoopPlot.isNone(): continue
            					if pLoopPlot.getTerrainType() == iCoast:
              						bSet = False
              						break
          				if not bSet: break
        
        			if bSet:
          # VOID setTerrainType (TerrainType eNewValue, BOOL bRecalculate, BOOL bRebuildGraphics)
          ### keine Inseln & Korallen auf Tiefsee!
          				iFeature = pPlot.getFeatureType()
          				if (iFeature == iFeat1 or iFeature == iFeat2 or iFeature == iFeat3 or iFeature == iFeat4): pPlot.setFeatureType(-1,0)
          ### keine Inseln auf Tiefsee!
					if (iX == 3 or iX % 6 == 0) and (iY == 3 or iY % 6 == 0): bRebuildGraphics = True 
         				else: bRebuildGraphics = False
          				pPlot.setTerrainType(iDeepOcean, False, bRebuildGraphics) 

			elif pPlot.getTerrainType() == gc.getInfoTypeForString("TERRAIN_WETLANDS"):
				if pPlot.isHills():
					pPlot.setTerrainType(gc.getInfoTypeForString("TERRAIN_GRASS"),False,False)
				if (pPlot.getBonusType(-1) == gc.getInfoTypeForString("BONUS_CAMEL")):
					pPlot.setTerrainType(gc.getInfoTypeForString("TERRAIN_ROCKY"),False,False)
###Tiefsee start###
#		for i in range(CyMap().numPlots()):
#			iPlot = CyMap().plotByIndex(i)
#			if iPlot.getTerrainType() == gc.getInfoTypeForString("TERRAIN_OCEAN"):
#				StartX=iPlot.getX()-1
#				EndX=iPlot.getX()+2
#				StartY=iPlot.getY()-1
#				EndY=iPlot.getY()+2
#				bTrue = True
#				for j in range(StartX, EndX):
#					for k in range(StartY,EndY):
#						lPlot = CyMap().plot(j,k)
#						if lPlot.isNone():continue
#						if lPlot.getTerrainType() == gc.getInfoTypeForString("TERRAIN_COAST"):
#							bTrue = False
#							break
#				if (bTrue == True):
#					iPlot.setTerrainType(gc.getInfoTypeForString("TERRAIN_TIEFSEE"),False,False)
##					###keine Inseln & Korallen auf Tiefsee!
#					if ( iPlot.getFeatureType() == gc.getInfoTypeForString("FEATURE_ISLANDS") ):
#						iPlot.setFeatureType(-1,-1)
#					if ( iPlot.getFeatureType() == gc.getInfoTypeForString("FEATURE_CORAL") ):
#						iPlot.setFeatureType(-1,-1)
#					if ( iPlot.getFeatureType() == gc.getInfoTypeForString("FEATURE_SANDBANK") ):
#						iPlot.setFeatureType(-1,-1)
#					###keine Inseln auf Tiefsee!
#			elif iPlot.getTerrainType() == gc.getInfoTypeForString("TERRAIN_WETLANDS"):
#				if iPlot.isHills():
#					iPlot.setTerrainType(gc.getInfoTypeForString("TERRAIN_GRASS"),False,False)
###Tiefsee end###
###Schatz Island start###
		for i in range(CyMap().numPlots()):
			iPlot = CyMap().plotByIndex(i)
			if iPlot.isWater():
				MeineZufallszahl = CyGame().getSorenRandNum(29, 'IrgendeinTextAusDemDieZahlBerechnetWird')
				if MeineZufallszahl ==0:
					if (iPlot.getFeatureType() == -1):
						iPlot.setImprovementType(gc.getInfoTypeForString("IMPROVEMENT_SCHATZ_ISLAND"))
					elif ( iPlot.getFeatureType() == gc.getInfoTypeForString("FEATURE_ISLANDS") ):
						iPlot.setImprovementType(gc.getInfoTypeForString("IMPROVEMENT_SCHATZ_ISLAND"))
###Schatz Island end###
###Goody Island start###
		for i in range(CyMap().numPlots()):
			iPlot = CyMap().plotByIndex(i)
			if iPlot.getTerrainType() == gc.getInfoTypeForString("TERRAIN_COAST"):
				MeineZufallszahl = CyGame().getSorenRandNum(19, 'IrgendeinTextAusDemDieZahlBerechnetWird')
				if MeineZufallszahl ==0:
					if (iPlot.getFeatureType() == -1):
						iPlot.setImprovementType(gc.getInfoTypeForString("IMPROVEMENT_GOODY_ISLAND"))
###Goody Island end###
###Schatz Grab start###
		for i in range(CyMap().numPlots()):
			iPlot = CyMap().plotByIndex(i)
			if (iPlot.isPeak() == false):
				if iPlot.getTerrainType() == gc.getInfoTypeForString("TERRAIN_TUNDRA") or iPlot.getTerrainType() == gc.getInfoTypeForString("TERRAIN_DESERT") or iPlot.getTerrainType() == gc.getInfoTypeForString("TERRAIN_ROCKY") or iPlot.getTerrainType() == gc.getInfoTypeForString("TERRAIN_MARSH"):
					MeineZufallszahl = CyGame().getSorenRandNum(24, 'IrgendeinTextAusDemDieZahlBerechnetWird')
					if MeineZufallszahl ==0:
						iPlot.setImprovementType(gc.getInfoTypeForString("IMPROVEMENT_SCHATZ_GRAB"))
###Schatz Grab end###
### Ressourcencheck beginn###
		iResourcenzahl = gc.getNumBonusInfos()
		self.Bonuszaehler = {}
		self.Bonuszaehler[-1] = 0
		for i in range(iResourcenzahl):
			self.Bonuszaehler[i] = 0
		for i in range(CyMap().numPlots()):
			iPlot = CyMap().plotByIndex(i)
			if iPlot.getBonusType(-1) != -1:
				iIndex = iPlot.getBonusType (-1)
				self.Bonuszaehler[iIndex] = self.Bonuszaehler[iIndex]+1
		for i in range(iResourcenzahl):
			if self.Bonuszaehler[i] < 2:
				eBonusType = i
       				BonusPlotArray = []
				iMapW = gc.getMap().getGridWidth()
				iMapH = gc.getMap().getGridHeight()
	
        			for x in range(iMapW):
         				for y in range(iMapH):
            					loopPlot = gc.getMap().plot(x,y)
						if (loopPlot.canHaveBonus(eBonusType, True)):
       							if loopPlot != None and not loopPlot.isNone() and loopPlot.getBonusType(-1) == -1:
       								BonusPlotArray.append(loopPlot)
       				if len(BonusPlotArray) > 0:
					iMeineZufallszahl = CyGame().getSorenRandNum(len(BonusPlotArray), 'IrgendeinTextAusDemDieZahlBerechnetWird')
          				BonusPlotArray[iMeineZufallszahl].setBonusType(eBonusType)
	###kill nicht natrlich vorhandene Ressourcen Beginn
		for i in range(CyMap().numPlots()):
			iPlot = CyMap().plotByIndex(i)
			if (iPlot.getBonusType(-1) == gc.getInfoTypeForString("BONUS_PAPIER")):
				iPlot.setBonusType(-1)
			elif (iPlot.getBonusType(-1) == gc.getInfoTypeForString("BONUS_BEER")):
				iPlot.setBonusType(-1)
##			elif (iPlot.getBonusType(-1) == gc.getInfoTypeForString("BONUS_REISEN")):
##				iPlot.setBonusType(-1)
			elif (iPlot.getBonusType(-1) == gc.getInfoTypeForString("BONUS_FOOTBALL")):
				iPlot.setBonusType(-1)
			elif (iPlot.getBonusType(-1) == gc.getInfoTypeForString("BONUS_CHEESE")):
				iPlot.setBonusType(-1)
			elif (iPlot.getBonusType(-1) == gc.getInfoTypeForString("BONUS_RUM")):
				iPlot.setBonusType(-1)
	###kill nicht natrlich vorhandene Ressourcen End
## Ressourcencheck end###
### Beginn Natural Wonders###
		iNumFeatures = gc.getNumFeatureInfos()

		for i in range(iNumFeatures ):
			eFeatureType = i
			bCoastal = false
			iMaxIslandSize = -1
			bSouthCoast = false
		################## Sonderwnsche
			if (eFeatureType == gc.getInfoTypeForString("FEATURE_ROCK_OF_GIBRALTAR")):
				bCoastal = true
			if (eFeatureType == gc.getInfoTypeForString("FEATURE_GALAPAGOS_ISLANDS")):
				iMaxIslandSize =6 ##Effektive Max. Gre ist 1 geringer!!!
			if (eFeatureType == gc.getInfoTypeForString("FEATURE_CLIFFS_OF_DOVER")):
				bSouthCoast = true
		#################
			if ( gc.getFeatureInfo(i).isNaturalWonder() ):
				FeaturePlotArray = []
				iMapW = gc.getMap().getGridWidth()
				iMapH = gc.getMap().getGridHeight()
	
      				for x in range(iMapW):
      					for y in range(iMapH):
      						loopPlot = gc.getMap().plot(x,y)
					######## Clear all Existing Natural Wonders - sonst Doppelungen mglich
						if (loopPlot.getFeatureType() == eFeatureType ):
							loopPlot.setFeatureType(-1,0)
					######## Clear all Existing Natural Wonders - sonst Doppelungen mglich
						if (loopPlot.canHaveFeature(eFeatureType)):
       							if loopPlot != None and not loopPlot.isNone() and loopPlot.getFeatureType() == -1:
							######### Sonderwnsche
								if (iMaxIslandSize > 0):
									if ( loopPlot.area().getNumTiles() < iMaxIslandSize):
										if loopPlot.getBonusType(-1) == -1:		##Avoid Bonus ressource on impassable or no-improvement-plots
	       										FeaturePlotArray.append(loopPlot)
								elif (bCoastal):
									if (loopPlot.isCoastalLand()):
										if loopPlot.getBonusType(-1) == -1:		##Avoid Bonus ressource on impassable or no-improvement-plots
	       										FeaturePlotArray.append(loopPlot)
								elif (bSouthCoast ):
									NortherPlot = gc.getMap().plot(x,y+1)
									if NortherPlot != None and not NortherPlot.isNone():
										if (NortherPlot.isWater() == false):
											if loopPlot.getBonusType(-1) == -1:		##Avoid Bonus ressource on impassable or no-improvement-plots
		       										FeaturePlotArray.append(loopPlot)

							#########
								elif loopPlot.getBonusType(-1) == -1:		##Avoid Bonus ressource on impassable or no-improvement-plots
	       								FeaturePlotArray.append(loopPlot)
	       			if len(FeaturePlotArray) > 0:
					iMeineZufallszahl = CyGame().getSorenRandNum(len(FeaturePlotArray), 'IrgendeinTextAusDemDieZahlBerechnetWird')
        				FeaturePlotArray[iMeineZufallszahl].setFeatureType(eFeatureType,0)
### End Natural Wonders###

		CvAdvisorUtils.resetNoLiberateCities()
																	
	def onGameEnd(self, argsList):
		'Called at the End of the game'
		print("Game is ending")
		return

	def onBeginGameTurn(self, argsList):
		'Called at the beginning of the end of each turn'
		iGameTurn = argsList[0]
###Vlkerwanderung beginn###
		if CyGame().getGameTurnYear() == 380:
			if (gc.getGame().isOption(gc.getInfoTypeForString("GAMEOPTION_SPAWN_NEW_CIVS"))):
				iDPlayerBiggestEmpire = -1
				iNumBiggestEmpireCities = 0
				for iPlayer in range(gc.getMAX_PLAYERS()):
					player = gc.getPlayer(iPlayer)
					if (player.isAlive()):
						iPlayerCities = player.getNumCities()
						if iPlayerCities > iNumBiggestEmpireCities:
							iNumBiggestEmpireCities = iPlayerCities
							iDPlayerBiggestEmpire = iPlayer
				pTargetEmpire = gc.getPlayer(iDPlayerBiggestEmpire)
				iTargetEmpireTeam = pTargetEmpire.getTeam ()
				pTargetEmpireTeam = gc.getTeam(iTargetEmpireTeam)
				iNumContacts = 0
				ContactCivArray = []
				for iPlayer in range(gc.getMAX_PLAYERS()):
					pPlayer2 = gc.getPlayer(iPlayer)
					if(pPlayer2.getTeam() != iTargetEmpireTeam):
						iTeam2 = pPlayer2.getTeam ()
						if pTargetEmpireTeam.canContact(iTeam2):
							iNumContacts = iNumContacts+1
				if iNumContacts < iNumBiggestEmpireCities/2 :
					for iPlayer in range(gc.getMAX_PLAYERS()):
						pPlayer2 = gc.getPlayer(iPlayer)
						if(pPlayer2.getTeam() != iTargetEmpireTeam):
							iTeam2 = pPlayer2.getTeam ()
							if pTargetEmpireTeam.canContact(iTeam2):
								OcupiedCity = pTargetEmpire.getCity(pTargetEmpire.getNumCities()-1)
								iCityX = OcupiedCity.getX()
								iCityY = OcupiedCity.getY()
								pPlayer2.acquireCity(OcupiedCity,False,True)
								for i in range(2):
									Defender = OcupiedCity.getConscriptUnit ()
									pPlayer2.initUnit( Defender, iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )                
					for iPlayer in range(gc.getMAX_PLAYERS()):
						if gc.getPlayer(iPlayer).isHuman():
				                	popup = PyPopup.PyPopup(-1)
	        			        	popup.setHeaderString(CyTranslator().getText("TXT_KEY_HEADER_WANDERUNG",(-1,-1)))
        						popup.setBodyString(CyTranslator().getText("TXT_KEY_MESSAGE_WANDERUNG",(pTargetEmpire.getCivilizationDescription(0),pTargetEmpire.getCivilizationDescription(0))))
                					popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)

###Vlkerwanderung beginn###

		CvTopCivs.CvTopCivs().turnChecker(iGameTurn)

	def onEndGameTurn(self, argsList):
		'Called at the end of the end of each turn'
		iGameTurn = argsList[0]
		
	def onBeginPlayerTurn(self, argsList):
		'Called at the beginning of a players turn'
		iGameTurn, iPlayer = argsList

	def onEndPlayerTurn(self, argsList):
		'Called at the end of a players turn'
		iGameTurn, iPlayer = argsList
		
		if (gc.getGame().getElapsedGameTurns() == 1):
			if (gc.getPlayer(iPlayer).isHuman()):
				if (gc.getPlayer(iPlayer).canRevolution(0)):
					popupInfo = CyPopupInfo()
					popupInfo.setButtonPopupType(ButtonPopupTypes.BUTTONPOPUP_CHANGECIVIC)
					popupInfo.addPopup(iPlayer)
		CvAdvisorUtils.resetAdvisorNags()
		CvAdvisorUtils.endTurnFeats(iPlayer)

	def onEndTurnReady(self, argsList):
		iGameTurn = argsList[0]

	def onFirstContact(self, argsList):
		'Contact'
		iTeamX,iHasMetTeamY = argsList

### exotic illnesses beginn###
		pTeamX = gc.getTeam(iTeamX)
		pTeamY = gc.getTeam(iHasMetTeamY)
		iLeaderX = pTeamX.getLeaderID()
		iLeaderY = pTeamY.getLeaderID()
		pPlayerX = gc.getPlayer(iLeaderX )
		pPlayerY = gc.getPlayer(iLeaderY )
		pCapitalX = pPlayerX.getCapitalCity ()
		pCapitalY = pPlayerY.getCapitalCity ()

	##fr exotische Kontinente
		if pCapitalX and not pCapitalX.isNone() and pCapitalY and not pCapitalY.isNone():
			area1 = pCapitalX.area() 
			area2 = pCapitalY.area() 
			if area1 and not area1.isNone() and area2 and not area2.isNone():
				if area1.getID() != area2.getID():
					if (pCapitalX.area().getID() != pCapitalY.area().getID()):
						iRandom = gc.getGame().getSorenRandNum(3, "Partisan event placement")
						pInfectedTeam = -1
						if (iRandom == 1):
							pInfectedTeam = pTeamX
							pSourceTeam = pTeamY
						elif (iRandom == 2):
							pInfectedTeam = pTeamY
							pSourceTeam = pTeamX
						if (pInfectedTeam != -1):
							if ( pInfectedTeam.isHasTech(gc.getInfoTypeForString("TECH_MEDIZIN")) == false ):
								for iAllPlayer in range (gc.getMAX_CIV_PLAYERS ()):
									pAllPlayer = gc.getPlayer(iAllPlayer)
									if (pAllPlayer.getTeam() == pInfectedTeam.getID() ):
										iX = pAllPlayer.getCapitalCity ().getX()
										iY = pAllPlayer.getCapitalCity ().getY()
										pAllPlayer.changeExoticBadHealth(1)
										SourceName = pSourceTeam.getName()
										CyInterface().addMessage(iAllPlayer ,false,15,CyTranslator().getText("TXT_KEY_MESSAGE_INFEKTION_BEI_ERSTKONTAKT",(SourceName,SourceName)),'',0,'Art/Interface/Buttons/General/happy_person.dds',ColorTypes(44), iX, iY, True,True)
### exotic illnesses end###
		if (not self.__LOG_CONTACT):
			return
		CvUtil.pyPrint('Team %d has met Team %d' %(iTeamX, iHasMetTeamY))
	
	def onCombatResult(self, argsList):
		'Combat Result'
		pWinner,pLoser = argsList
		playerX = PyPlayer(pWinner.getOwner())
		unitX = PyInfo.UnitInfo(pWinner.getUnitType())
		playerY = PyPlayer(pLoser.getOwner())
		unitY = PyInfo.UnitInfo(pLoser.getUnitType())
### Sklavenjagd anfang###
### alt		if pWinner.isHasPromotion(gc.getInfoTypeForString("PROMOTION_SLAVE_HUNTER")):
		if pWinner.isSlaveHunter():
	###SlaveHunter-Promotion aus SDK
			pLoserPlot = CyMap().plot(pLoser.getX(),pLoser.getY())
			if pLoserPlot.isCity():
				pLoserCity = pLoserPlot.getPlotCity ()
				if pLoserCity.getPopulation () > 1:
					iChaceModifier = pLoserCity.getDefenseModifier(false)
					if iChaceModifier == 0:
						iChaceModifier =1
					iChance = 50/iChaceModifier
					iRandom = gc.getGame().getSorenRandNum(100, "Partisan event placement")
					if iChance > iRandom:
						pLoserCity.changePopulation(-1)
						pPlot = CyMap().plot(pWinner.getX(),pWinner.getY())
						iX = pPlot.getX()
						iY = pPlot.getY()
						pWinnerPlayer = gc.getPlayer(pWinner.getOwner())
						pNewUnit = pWinnerPlayer.initUnit(gc.getInfoTypeForString("UNIT_SLAVE"), iX,iY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH)
### Sklavenjagd ENDE###
###Biowaffeneinsatzstrafe Beginn###
		if unitX.getUnitClassType() == gc.getInfoTypeForString("UNITCLASS_NERVENGAS"):
			pWinnerTeam = playerX.getTeam()
			pWinnerTeam.changeWarWeariness (playerY.getTeamID(), 100)
                        iRandMajor = CyGame().getSorenRandNum(gc.getMAX_TEAMS(), "Player Type")
                        pPlayerWar = gc.getPlayer(iRandMajor)
        		if(pPlayerWar.isAlive() and not pPlayerWar.isHuman() and not pPlayerWar.isBarbarian()):
				if(pPlayerWar.getTeam() != pWinner.getTeam()):
					pPlayerWar.AI_changeAttitudeExtra(pWinner.getTeam(), -1)
					iX = pWinner.getX()
					iY = pWinner.getY()
					iPlayer = playerX.getID()
					CyInterface().addMessage(iPlayer,false,15,CyTranslator().getText("TXT_KEY_MESSAGE_BEZIEHUNGSKRISE",()),'',0,'Art/Interface/Buttons/General/happy_person.dds',ColorTypes(44), iX, iY, True,True)
###Biowaffeneinsatzstrafe ENDE###
###respawn part 1 start###
		pPlayer = gc.getPlayer(pLoser.getOwner())
		pPID = pPlayer.getID()
		promotion = []
		promotion.append(gc.getInfoTypeForString('PROMOTION_LIVE2'))
		promotion.append(gc.getInfoTypeForString('PROMOTION_LIVE1'))
		
		if ((pLoser.isHasPromotion(gc.getInfoTypeForString('PROMOTION_LIVE1')))or(pLoser.isHasPromotion(gc.getInfoTypeForString('PROMOTION_LIVE2')))):
                        iUnit = pLoser.getUnitType()                  
                        pCity= pPlayer.getCapitalCity()
        		iX =pCity.getX()
        		iY = pCity.getY()
        		if pLoser.getDomainType ()==gc.getInfoTypeForString('DOMAIN_SEA'):
                                for iCity in range(pPlayer.getNumCities () ):
                                        ppCity = pPlayer.getCity(iCity)
                                        if ppCity.isNone():continue
                                        if ppCity.getOwner()<>pPID:continue
                                        pPlot = CyMap().plot(ppCity.getX(),ppCity.getY())
                                        if pPlot.isCoastalLand ():
                                                iX = ppCity.getX()
                                                iY = ppCity.getY()
                                                break                                

			newUnit = pPlayer.initUnit(iUnit, iX,iY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH)
			pLoser.setDamage(0, False)
			newUnit.convert(pLoser)
        			
                        newUnit.finishMoves()
			counter=0
			CyInterface().addMessage(pPID,false,15,CyTranslator().getText("TXT_KEY_REBORN",()),'',0,'Art/Interface/Buttons/Phoenix.dds',ColorTypes(44), iX, iY, True,True)
			for i in range(2):                                
                                counter=counter+1
                                newUnit.setHasPromotion(promotion[i], False)                                                
                        for i in range(2):
                                if pLoser.isHasPromotion(promotion[i]):
                                        if i==1:
                                                break
                                        newUnit.setHasPromotion(promotion[i+1], True)
                        pLoser.setDamage(100, False)
###respawn part 1 end###
## Survival Start ##

		pPlayer = gc.getPlayer(pLoser.getOwner())

		if pLoser.isHasPromotion(gc.getInfoTypeForString('PROMOTION_SURVIVAL')):

			self.iResistance = self.getRandomNumber( 4 )

			if self.iResistance == 0:

				iUnit = pLoser.getUnitType()
				pClearPlot = self.findClearPlot(pLoser)
				pPlot = pLoser.plot()

				newUnit = pPlayer.initUnit(iUnit, pPlot.getX(), pPlot.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH)
				pLoser.setDamage(90, False)
				newUnit.convert(pLoser)
				pLoser.setDamage(100, False)
				newUnit.finishMoves()
## Survival End ##
###Barbarenhaeuptling geboren start###
		if pWinner.isBarbarian():
			pPlot = CyMap().plot(pWinner.getX(),pWinner.getY())
			pNewUnit = gc.getPlayer(gc.getBARBARIAN_PLAYER ()).initUnit(gc.getInfoTypeForString("UNIT_BARBARIAN_CHIEFTAIN"), pPlot.getX(),pPlot.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH)
			if pPlot.isWater():
				pNewUnit.jumpToNearestValidPlot()
###Barbarenhaeuptling geboren ende###

		if (not self.__LOG_COMBAT):
			return
		if playerX and playerX and unitX and playerY:
			CvUtil.pyPrint('Player %d Civilization %s Unit %s has defeated Player %d Civilization %s Unit %s' 
				%(playerX.getID(), playerX.getCivilizationName(), unitX.getDescription(), 
				playerY.getID(), playerY.getCivilizationName(), unitY.getDescription()))

	def onCombatLogCalc(self, argsList):
		'Combat Result'	
		genericArgs = argsList[0][0]
		cdAttacker = genericArgs[0]
		cdDefender = genericArgs[1]
		iCombatOdds = genericArgs[2]
		CvUtil.combatMessageBuilder(cdAttacker, cdDefender, iCombatOdds)
		
	def onCombatLogHit(self, argsList):
		'Combat Message'
		global gCombatMessages, gCombatLog
		genericArgs = argsList[0][0]
		cdAttacker = genericArgs[0]
		cdDefender = genericArgs[1]
		iIsAttacker = genericArgs[2]
		iDamage = genericArgs[3]
		
		if cdDefender.eOwner == cdDefender.eVisualOwner:
			szDefenderName = gc.getPlayer(cdDefender.eOwner).getNameKey()
		else:
			szDefenderName = localText.getText("TXT_KEY_TRAIT_PLAYER_UNKNOWN", ())
		if cdAttacker.eOwner == cdAttacker.eVisualOwner:
			szAttackerName = gc.getPlayer(cdAttacker.eOwner).getNameKey()
		else:
			szAttackerName = localText.getText("TXT_KEY_TRAIT_PLAYER_UNKNOWN", ())

		if (iIsAttacker == 0):				
			combatMessage = localText.getText("TXT_KEY_COMBAT_MESSAGE_HIT", (szDefenderName, cdDefender.sUnitName, iDamage, cdDefender.iCurrHitPoints, cdDefender.iMaxHitPoints))
			CyInterface().addCombatMessage(cdAttacker.eOwner,combatMessage)
			CyInterface().addCombatMessage(cdDefender.eOwner,combatMessage)
			if (cdDefender.iCurrHitPoints <= 0):
				combatMessage = localText.getText("TXT_KEY_COMBAT_MESSAGE_DEFEATED", (szAttackerName, cdAttacker.sUnitName, szDefenderName, cdDefender.sUnitName))
				CyInterface().addCombatMessage(cdAttacker.eOwner,combatMessage)
				CyInterface().addCombatMessage(cdDefender.eOwner,combatMessage)
		elif (iIsAttacker == 1):
			combatMessage = localText.getText("TXT_KEY_COMBAT_MESSAGE_HIT", (szAttackerName, cdAttacker.sUnitName, iDamage, cdAttacker.iCurrHitPoints, cdAttacker.iMaxHitPoints))
			CyInterface().addCombatMessage(cdAttacker.eOwner,combatMessage)
			CyInterface().addCombatMessage(cdDefender.eOwner,combatMessage)
			if (cdAttacker.iCurrHitPoints <= 0):
				combatMessage = localText.getText("TXT_KEY_COMBAT_MESSAGE_DEFEATED", (szDefenderName, cdDefender.sUnitName, szAttackerName, cdAttacker.sUnitName))
				CyInterface().addCombatMessage(cdAttacker.eOwner,combatMessage)
				CyInterface().addCombatMessage(cdDefender.eOwner,combatMessage)

	def onImprovementBuilt(self, argsList):
		'Improvement Built'
		iImprovement, iX, iY = argsList

##Beginn Edit allgemein
#		pPlot = CyMap().plot(iX,iY)
##End Edit allgemein
		if (not self.__LOG_IMPROVEMENT):
			return
		CvUtil.pyPrint('Improvement %s was built at %d, %d'
			%(PyInfo.ImprovementInfo(iImprovement).getDescription(), iX, iY))

	def onImprovementDestroyed(self, argsList):
		'Improvement Destroyed'
		iImprovement, iOwner, iX, iY = argsList
		if (not self.__LOG_IMPROVEMENT):
			return
		CvUtil.pyPrint('Improvement %s was Destroyed at %d, %d'
			%(PyInfo.ImprovementInfo(iImprovement).getDescription(), iX, iY))

	def onRouteBuilt(self, argsList):
		'Route Built'
		iRoute, iX, iY = argsList
		if (not self.__LOG_IMPROVEMENT):
			return
		CvUtil.pyPrint('Route %s was built at %d, %d'
			%(gc.getRouteInfo(iRoute).getDescription(), iX, iY))

	def onPlotRevealed(self, argsList):
		'Plot Revealed'
		pPlot = argsList[0]
		iTeam = argsList[1]

	def onPlotFeatureRemoved(self, argsList):
		'Plot Revealed'
		pPlot = argsList[0]
		pCity = argsList[1]
		iFeatureType = argsList[2] # This can be null????

	def onPlotPicked(self, argsList):
		'Plot Picked'
		pPlot = argsList[0]
		CvUtil.pyPrint('Plot was picked at %d, %d'
			%(pPlot.getX(), pPlot.getY()))

	def onNukeExplosion(self, argsList):
		'Nuke Explosion'
		pPlot, pNukeUnit = argsList
		CvUtil.pyPrint('Nuke detonated at %d, %d'
			%(pPlot.getX(), pPlot.getY()))

	def onGotoPlotSet(self, argsList):
		'Nuke Explosion'
		pPlot, iPlayer = argsList

	def onBuildingBuilt(self, argsList):
		'Building Completed'
		pCity, iBuildingType = argsList
		game = gc.getGame()
		if ((not gc.getGame().isNetworkMultiPlayer()) and (pCity.getOwner() == gc.getGame().getActivePlayer()) and isWorldWonderClass(gc.getBuildingInfo(iBuildingType).getBuildingClassType())):
			# If this is a wonder...
			popupInfo = CyPopupInfo()
			popupInfo.setButtonPopupType(ButtonPopupTypes.BUTTONPOPUP_PYTHON_SCREEN)
			popupInfo.setData1(iBuildingType)
			popupInfo.setData2(pCity.getID())
			popupInfo.setData3(0)
			popupInfo.setText(u"showWonderMovie")
			popupInfo.addPopup(pCity.getOwner())
###Reichsdeputationshauptausschuss###
		if iBuildingType == gc.getInfoTypeForString("BUILDING_REICHSDEPUTATIONSHAUPTAUSSCHUSS"):
			iOwnerPlayer = pCity.getOwner()
			pOwnerPlayer = gc.getPlayer(iOwnerPlayer )
			iOwnerTeam = pOwnerPlayer.getTeam()
			pOwnerTeam = gc.getTeam(iOwnerTeam )
                        ConquerName = pOwnerPlayer.getName ()
	                for iPlayer in range (gc.getMAX_CIV_PLAYERS()):
				pCurPlayer = gc.getPlayer(iPlayer )
				iCutTeam = pCurPlayer.getTeam()
                	        pCurTeam = gc.getTeam(iCutTeam)
				if pOwnerTeam.isVassal(iCutTeam ):continue	### Keine Stdte vom Hegemon stehlen
				(loopCity, iter) = (pCurPlayer.firstCity(True))				
				while(loopCity):
					if (loopCity.isCapital() == false):
						if ( loopCity.cultureStrength(iOwnerPlayer) > loopCity.cultureStrength(iPlayer )):
        	                                        CityName = loopCity.getName()
	                                                iX = loopCity.getX()
        	                                        iY = loopCity.getY()
							pOwnerPlayer.acquireCity(loopCity,False,True)

                                           		for iAllPlayer in range (gc.getMAX_CIV_PLAYERS ()):
                                                        	ThisPlayer = gc.getPlayer(iAllPlayer)
                                                        	iThisTeam = ThisPlayer.getTeam()
                                                        	ThisTeam = gc.getTeam(iThisTeam)
                                                        	if ThisTeam.isHasMet(iOwnerTeam ):
                                                        	        if iAllPlayer == iOwnerPlayer:
                                                                	        CyInterface().addMessage(iAllPlayer,False,15,CyTranslator().getText("TXT_KEY_YOU_GOT_CITY_HAUPTAUSSCHUSS",(ConquerName,CityName )),'',0,'Art/Interface/Buttons/General/warning_popup.dds',ColorTypes(gc.getInfoTypeForString("COLOR_RED")), iX, iY, True,True)
                                                        	        else:
                                                                	        CyInterface().addMessage(iAllPlayer,False,15,CyTranslator().getText("TXT_KEY_XY_GOT_CITY_HAUPTAUSSCHUSS",(ConquerName,CityName )),'',0,'Art/Interface/Buttons/General/warning_popup.dds',ColorTypes(gc.getInfoTypeForString("COLOR_RED")), iX, iY, True,True)
					(loopCity, iter) = (pCurPlayer .nextCity(iter, true))
##Reichsdeputationshauptausschuss###
		CvAdvisorUtils.buildingBuiltFeats(pCity, iBuildingType)

		if (not self.__LOG_BUILDING):
			return
		CvUtil.pyPrint('%s was finished by Player %d Civilization %s' 
			%(PyInfo.BuildingInfo(iBuildingType).getDescription(), pCity.getOwner(), gc.getPlayer(pCity.getOwner()).getCivilizationDescription(0)))
	
	def onProjectBuilt(self, argsList):
		'Project Completed'
		pCity, iProjectType = argsList
		game = gc.getGame()
		if ((not gc.getGame().isNetworkMultiPlayer()) and (pCity.getOwner() == gc.getGame().getActivePlayer())):
			popupInfo = CyPopupInfo()
			popupInfo.setButtonPopupType(ButtonPopupTypes.BUTTONPOPUP_PYTHON_SCREEN)
			popupInfo.setData1(iProjectType)
			popupInfo.setData2(pCity.getID())
			popupInfo.setData3(2)
			popupInfo.setText(u"showWonderMovie")
			popupInfo.addPopup(pCity.getOwner())

	def onSelectionGroupPushMission(self, argsList):
		'selection group mission'
		eOwner = argsList[0]
		eMission = argsList[1]
		iNumUnits = argsList[2]
		listUnitIds = argsList[3]
		
		if (not self.__LOG_PUSH_MISSION):
			return
		if pHeadUnit:
			CvUtil.pyPrint("Selection Group pushed mission %d" %(eMission))
	
	def onUnitMove(self, argsList):
		'unit move'
		pPlot,pUnit,pOldPlot = argsList
		player = PyPlayer(pUnit.getOwner())
		unitInfo = PyInfo.UnitInfo(pUnit.getUnitType())
		if (not self.__LOG_MOVEMENT):
			return
		if player and unitInfo:
			CvUtil.pyPrint('Player %d Civilization %s unit %s is moving to %d, %d' 
				%(player.getID(), player.getCivilizationName(), unitInfo.getDescription(), 
				pUnit.getX(), pUnit.getY()))

	def onUnitSetXY(self, argsList):
		'units xy coords set manually'
		pPlot,pUnit = argsList
		player = PyPlayer(pUnit.getOwner())
		unitInfo = PyInfo.UnitInfo(pUnit.getUnitType())
		if (not self.__LOG_MOVEMENT):
			return
		
	def onUnitCreated(self, argsList):
		'Unit Completed'
		unit = argsList[0]
		player = PyPlayer(unit.getOwner())
		if (not self.__LOG_UNITBUILD):
			return

	def onUnitBuilt(self, argsList):
		'Unit Completed'
		city = argsList[0]
		unit = argsList[1]
		player = PyPlayer(city.getOwner())
### Kennel
		iUnitType = unit.getUnitType()
		bKennelUnit = false
		if (iUnitType == gc.getInfoTypeForString("UNIT_HUND")):
			bKennelUnit = true
		elif (iUnitType == gc.getInfoTypeForString("UNIT_JAGDLEOPARD")):
			bKennelUnit = true
		elif (iUnitType == gc.getInfoTypeForString("UNIT_KAMPFHUND")):
			bKennelUnit = true
		if (bKennelUnit == true):
			if ( city.getNumActiveBuilding(gc.getInfoTypeForString("BUILDING_KENNEL")) ):
				unit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_SHOCK1"),1)
				unit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_BLINDING1"),1)
### Kennel end
		CvAdvisorUtils.unitBuiltFeats(city, unit)
		
		if (not self.__LOG_UNITBUILD):
			return
		CvUtil.pyPrint('%s was finished by Player %d Civilization %s' 
			%(PyInfo.UnitInfo(unit.getUnitType()).getDescription(), player.getID(), player.getCivilizationName()))
	
	def onUnitKilled(self, argsList):
		'Unit Killed'
		unit, iAttacker = argsList
		player = PyPlayer(unit.getOwner())
		attacker = PyPlayer(iAttacker)
		if (not self.__LOG_UNITKILLED):
			return
		CvUtil.pyPrint('Player %d Civilization %s Unit %s was killed by Player %d' 
			%(player.getID(), player.getCivilizationName(), PyInfo.UnitInfo(unit.getUnitType()).getDescription(), attacker.getID()))
###Kathy: Allgemein
		pPlot = CyMap().plot(unit.getX(),unit.getY())
		iUnitType = PyInfo.UnitInfo(unit.getUnitType())
###Food from animals beginn###
		if unit.isAnimal():
			pNearestCity = gc.getMap().findCity(unit.getX(), unit.getY(), attacker.getID(), attacker.getTeam().getID(), True, False, -1, -1, CyCity())
			if pNearestCity:
				iAnimalFood = (2 * unit.baseCombatStr())
				pNearestCity.changeFood(iAnimalFood)
				strMessageFFA = localText.getText( "TXT_KEY_FOOD_FROM_ANIMAL", (iAnimalFood,unit.getName(),pNearestCity.getName() ) )
				CyInterface().addMessage(iAttacker, True, 20, strMessageFFA, "", 0, unit.getButton(), ColorTypes(8),unit.getX(), unit.getY(), True, True) 
	###Opferkult Spezial
		elif gc.getPlayer(iAttacker).isCivic(gc.getInfoTypeForString("CIVIC_MENSCHENOPFER")):
			if unit.getDomainType () == gc.getInfoTypeForString("DOMAIN_LAND"):
				if (gc.getUnitInfo(unit.getUnitType()).isMechUnit() == false):
					pNearestCity = gc.getMap().findCity(unit.getX(), unit.getY(), attacker.getID(), attacker.getTeam().getID(), True, False, -1, -1, CyCity())
					if pNearestCity:
						iAnimalFood = (iUnitType.getProductionCost ()/20)
						if (iAnimalFood == 0):
							iAnimalFood =1
						pNearestCity.changeFood(iAnimalFood)
						strMessageFFA = localText.getText( "TXT_KEY_FOOD_FROM_ANIMAL", (iAnimalFood,unit.getName(),pNearestCity.getName() ) )
						CyInterface().addMessage(iAttacker, True, 20, strMessageFFA, "", 0, unit.getButton(), ColorTypes(8),unit.getX(), unit.getY(), True, True) 
	###Opferkult Spezial end
###Food from animals end###
###Treibgut Beginn###
		if unit.getDomainType () == gc.getInfoTypeForString("DOMAIN_SEA"):
			iWert = iUnitType.getProductionCost()
			iTreibgutRand = gc.getGame().getSorenRandNum( 2000, "mein Schatz")
			if (iWert > iTreibgutRand):
				if pPlot.isWater():
					if (pPlot.getFeatureType() == -1):
						pPlot.setFeatureType(gc.getInfoTypeForString("FEATURE_TREIBGUT"),0)
###Treibgut Ende###
#### Kultur von Sieg beginn
		if (pPlot.getCulture(unit.getOwner()) > 0):
			if (unit.baseCombatStr() > 0):
				iCultureLost = iUnitType.getProductionCost() + unit.baseCombatStr()
				pPlot.changeCulture( unit.getOwner(),-iCultureLost,true)
				pPlot.changeCulture( iAttacker,iCultureLost/4,true)
#### Kultur von Sieg End

	def onUnitLost(self, argsList):
		'Unit Lost'
		unit = argsList[0]
		player = PyPlayer(unit.getOwner())
		if (not self.__LOG_UNITLOST):
			return
		CvUtil.pyPrint('%s was lost by Player %d Civilization %s' 
			%(PyInfo.UnitInfo(unit.getUnitType()).getDescription(), player.getID(), player.getCivilizationName()))
	
	def onUnitPromoted(self, argsList):
		'Unit Promoted'
		pUnit, iPromotion = argsList
		player = PyPlayer(pUnit.getOwner())
###Respawn Part 2 AI start###
		pWinner = pUnit
		pPlayer = gc.getPlayer(pWinner.getOwner())
		if not pPlayer.isHuman():
                        iRespawnPromo1 = gc.getInfoTypeForString('PROMOTION_LIVE1')
                        if (iPromotion<>iRespawnPromo1):                                
                                if not pWinner.isHasPromotion(iRespawnPromo1):
                                        if pWinner.canAcquirePromotion(iRespawnPromo1):
                                                pWinner.setHasPromotion(iPromotion,False)
                                                if pWinner.canAcquirePromotion(iRespawnPromo1):
                                                        pWinner.setHasPromotion(iRespawnPromo1,True)
                                                else:
                                                        pWinner.setHasPromotion(iPromotion,True)
                                                return

		pWinner = pUnit
		pPlayer = gc.getPlayer(pWinner.getOwner())
		if not pPlayer.isHuman():
                        iRespawnPromo2 = gc.getInfoTypeForString('PROMOTION_LIVE2')
                        if (iPromotion<>iRespawnPromo2):                                
                                if not pWinner.isHasPromotion(iRespawnPromo2):
                                        if pWinner.canAcquirePromotion(iRespawnPromo2):
                                                pWinner.setHasPromotion(iPromotion,False)
                                                if pWinner.canAcquirePromotion(iRespawnPromo2):
                                                        pWinner.setHasPromotion(iRespawnPromo2,True)
                                                else:
                                                        pWinner.setHasPromotion(iPromotion,True)
                                                return                                                        
###Respawn Part 2 AI End###			
###Heroic Strength Promotion Part 1 AI start###
		pWinner = pUnit
		pPlayer = gc.getPlayer(pWinner.getOwner())
		if not pPlayer.isHuman():
                        iHeroPromo = gc.getInfoTypeForString('PROMOTION_HEROIC_STRENGTH')
                        if (iPromotion<>iHeroPromo):                                
                                if not pWinner.isHasPromotion(iHeroPromo):
                                        if pWinner.canAcquirePromotion(iHeroPromo):                                                
                                                descission = CyGame().getSorenRandNum(4, "strength")                                                
                                                if ((descission==1) or (descission ==2)):
                                                        pWinner.setHasPromotion(iPromotion,False)
                                                        if pWinner.canAcquirePromotion(iHeroPromo):
                                                                pWinner.setHasPromotion(iHeroPromo,True)
                                                                strength = pWinner.baseCombatStr ()
                                                                pWinner.setBaseCombatStr(strength+2) 
                                                        else:
                                                                pWinner.setHasPromotion(iPromotion,True)                                                        
                                                        return
                                                        
###Heroic Strength Promotion Part 1 AI End###
###Heroic Strength Promotion Part 2 Start ###
                if (iPromotion==gc.getInfoTypeForString('PROMOTION_HEROIC_STRENGTH')):
                    strength = pUnit.baseCombatStr ()
                    pUnit.setBaseCombatStr(strength+2)
###Heroic Strength Promotion Part 2 End                  		
		if (not self.__LOG_UNITPROMOTED):
			return
		CvUtil.pyPrint('Unit Promotion Event: %s - %s' %(player.getCivilizationName(), pUnit.getName(),))

###Begin On Unit Upgraded2
	def onUnitUpgraded(self, argsList):
		'Unit Promoted'
		iOldUnitType, pNewUnit = argsList
	###Heroic Strength Promotion Part 3 Start ###
                if pNewUnit.isHasPromotion(gc.getInfoTypeForString('PROMOTION_HEROIC_STRENGTH')):
                    strength = pNewUnit.baseCombatStr ()
                    pNewUnit.setBaseCombatStr(strength+2)
	###Heroic Strength Promotion Part 3 End###
###End On Unit Upgraded2
	
	def onUnitSelected(self, argsList):
		'Unit Selected'
		unit = argsList[0]
		player = PyPlayer(unit.getOwner())
		if (not self.__LOG_UNITSELECTED):
			return
		CvUtil.pyPrint('%s was selected by Player %d Civilization %s' 
			%(PyInfo.UnitInfo(unit.getUnitType()).getDescription(), player.getID(), player.getCivilizationName()))
	
	def onUnitRename(self, argsList):
		'Unit is renamed'
		pUnit = argsList[0]
		if (pUnit.getOwner() == gc.getGame().getActivePlayer()):
			self.__eventEditUnitNameBegin(pUnit)
	
	def onUnitPillage(self, argsList):
		'Unit pillages a plot'
		pUnit, iImprovement, iRoute, iOwner = argsList
		iPlotX = pUnit.getX()
		iPlotY = pUnit.getY()
		pPlot = CyMap().plot(iPlotX, iPlotY)

### Festungen schleifen beginn ###
		if (iImprovement == gc.getInfoTypeForString("IMPROVEMENT_FORT")):
			if pUnit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_PILLAGE")):
				iPlotowner = pPlot.getOwner()
				iUnitowner = pUnit.getOwner()
				if (not iUnitowner == iPlotowner):
					pUnit.changeExperience(1,-1,0,0,0)
### Festungen schleifen ende ###
### nur fr echteImprovements - nicht fr Routes! Beginn###
		if (iImprovement > -1):
	### Wissen durch Promotion beginn ###
			if pUnit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_BRANDSCHATZEN")):
				iPlotowner = pPlot.getOwner()
				iUnitowner = pUnit.getOwner()
				if (not iUnitowner == iPlotowner):
					if (iPlotowner != -1):
						techcount=0
						pPlotowner = gc.getPlayer(iPlotowner)
						pUnitowner = gc.getPlayer(iUnitowner)
						WinnerTeam=gc.getTeam(pUnitowner.getTeam())
						LoserTeam=gc.getTeam(pPlotowner.getTeam())
		### Bevorzugung aktuell erforscherter Tech
						eCurrentResearch = pUnitowner.getCurrentResearch()
						if (eCurrentResearch != -1):
							if (LoserTeam.isHasTech(eCurrentResearch)):
								iFortschritt = WinnerTeam.getResearchProgress(eCurrentResearch)
								iPillageRate = 100+pUnit.getPillageChange()
								iPillageGold = gc.getImprovementInfo(iImprovement).getPillageGold()
								iBeute =(iPillageGold*iPillageRate/100)
								iNeuFortschritt = iFortschritt+iBeute
								WinnerTeam.setResearchProgress(eCurrentResearch, iNeuFortschritt,iUnitowner)
								Techname = gc.getTechInfo(eCurrentResearch).getDescription ()
				                	        CyInterface().addMessage(iUnitowner,false,15,CyTranslator().getText("TXT_KEY_BRANDSCHATZEN_SCIENCE",(Techname,iBeute)),'',0,'Art/Interface/Buttons/General/happy_person.dds',ColorTypes(44), iPlotX, iPlotY, True,True)
							else:
								for techcount in range (gc.getNumTechInfos()-6):
				                        		if ((LoserTeam.isHasTech(techcount)==true)and ((WinnerTeam.isHasTech(techcount)==false))):
										iFortschritt = WinnerTeam.getResearchProgress(techcount)
										iPillageRate = 100+pUnit.getPillageChange()
										iPillageGold = gc.getImprovementInfo(iImprovement).getPillageGold()
										iBeute =(iPillageGold*iPillageRate/100)
										iNeuFortschritt = iFortschritt+iBeute
										WinnerTeam.setResearchProgress(techcount, iNeuFortschritt,iUnitowner)
										Techname = gc.getTechInfo(techcount).getDescription ()
					                		        CyInterface().addMessage(iUnitowner,false,15,CyTranslator().getText("TXT_KEY_BRANDSCHATZEN_SCIENCE",(Techname,iBeute)),'',0,'Art/Interface/Buttons/General/happy_person.dds',ColorTypes(44), iPlotX, iPlotY, True,True)
        	                						break
		### Bevorzugung aktuell erforscherter Tech END
						else:
							for techcount in range (gc.getNumTechInfos()-6):
			                        		if ((LoserTeam.isHasTech(techcount)==true)and ((WinnerTeam.isHasTech(techcount)==false))):
									iFortschritt = WinnerTeam.getResearchProgress(techcount)
									iPillageRate = 100+pUnit.getPillageChange()
									iPillageGold = gc.getImprovementInfo(iImprovement).getPillageGold()
									iBeute =(iPillageGold*iPillageRate/100)
									iNeuFortschritt = iFortschritt+iBeute
									WinnerTeam.setResearchProgress(techcount, iNeuFortschritt,iUnitowner)
									Techname = gc.getTechInfo(techcount).getDescription ()
				                		        CyInterface().addMessage(iUnitowner,false,15,CyTranslator().getText("TXT_KEY_BRANDSCHATZEN_SCIENCE",(Techname,iBeute)),'',0,'Art/Interface/Buttons/General/happy_person.dds',ColorTypes(44), iPlotX, iPlotY, True,True)
                        						break
	### Wissen durch Promotion ende ###
	### Beutekunst beginn ###
			if pUnit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_BEUTEKUNST1")):
				iPlotowner = pPlot.getOwner()
				iUnitowner = pUnit.getOwner()
				if (not iUnitowner == iPlotowner):
					if (iPlotowner != -1):
						iPillageRate = 100+pUnit.getPillageChange()
						iPillageGold = gc.getImprovementInfo(iImprovement).getPillageGold()
						iBeute =(iPillageGold*iPillageRate/100)
						if pUnit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_BEUTEKUNST2")):
							iBeute = iBeute*2
							pNearestCity = gc.getMap().findCity(iPlotX, iPlotY, iUnitowner, pUnit.getTeam(), True, False, -1, -1, CyCity())
							CityName = pNearestCity.getName()
							pNearestCity.changeCulture(iUnitowner,iBeute/4,0)
						pPlot.changeCulture (iPlotowner, (-1*iBeute), true)
						pPlotowner = gc.getPlayer(iPlotowner)
						PlotownerName = pPlotowner.getName ()
		        	                CyInterface().addMessage(iUnitowner,false,15,CyTranslator().getText("TXT_KEY_VERBRANNTE_ERDE_CULTURE",(PlotownerName,iBeute)),'',0,'Art/Interface/Buttons/General/happy_person.dds',ColorTypes(44), iPlotX, iPlotY, True,True)
						if pUnit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_BEUTEKUNST2")):
			        	                CyInterface().addMessage(iUnitowner,false,15,CyTranslator().getText("TXT_KEY_VERBRANNTE_ERDE_CULTURE2",(CityName,iBeute/4)),'',0,'Art/Interface/Buttons/General/happy_person.dds',ColorTypes(44), iPlotX, iPlotY, True,True)
	### Beutekunst ende ###
	### Fourage beginn ###
			if pUnit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_FOURAGE")):
				iPlotowner = pPlot.getOwner()
				iUnitowner = pUnit.getOwner()
				if (not iUnitowner == iPlotowner):
					if (iPlotowner != -1):
						iPillageRate = 100+pUnit.getPillageChange()
						iPillageGold = pPlot.getYield(YieldTypes.YIELD_FOOD)
						iBeute =(iPillageGold*iPillageRate/100)
						pNearestCity = gc.getMap().findCity(iPlotX, iPlotY, iUnitowner, pUnit.getTeam(), True, False, -1, -1, CyCity())
						CityName = pNearestCity.getName()
						pNearestCity.changeFood(iBeute)
		        	                CyInterface().addMessage(iUnitowner,false,15,CyTranslator().getText("TXT_KEY_FOURAGE",(CityName,iBeute)),'',0,'Art/Interface/Buttons/General/happy_person.dds',ColorTypes(44), iPlotX, iPlotY, True,True)
	### Fourage ende ###
	### Demontage beginn ###
			if pUnit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_DEMONTAGE")):
				iPlotowner = pPlot.getOwner()
				iUnitowner = pUnit.getOwner()
				if (not iUnitowner == iPlotowner):
					if (iPlotowner != -1):
						iPillageRate = 100+pUnit.getPillageChange()
						iPillageGold = pPlot.getYield(YieldTypes.YIELD_PRODUCTION)+2
						iBeute =(iPillageGold*iPillageRate/100)
						pNearestCity = gc.getMap().findCity(iPlotX, iPlotY, iUnitowner, pUnit.getTeam(), True, False, -1, -1, CyCity())
						CityName = pNearestCity.getName()
						iOldFeatureProduction = pNearestCity.getFeatureProduction()
						pNearestCity.setFeatureProduction(iBeute+iOldFeatureProduction )
		        	                CyInterface().addMessage(iUnitowner,false,15,CyTranslator().getText("TXT_KEY_DEMONTAGE",(CityName,iBeute)),'',0,'Art/Interface/Buttons/General/happy_person.dds',ColorTypes(44), iPlotX, iPlotY, True,True)
	### Demontage ende ###
	### Verhr beginn ###
			if pUnit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_VERHOER")):
				iPlotowner = pPlot.getOwner()
				iUnitowner = pUnit.getOwner()
				if (not iUnitowner == iPlotowner):
					if (iPlotowner != -1):
						pPlotowner = gc.getPlayer(iPlotowner)
						pUnitowner = gc.getPlayer(iUnitowner)
						iLoserTeam =pPlotowner.getTeam()
						iPillageRate = 100+pUnit.getPillageChange()
						iPillageGold = gc.getImprovementInfo(iImprovement).getPillageGold()
						iBeute =(iPillageGold*iPillageRate/100)
						pWinnerTeam=gc.getTeam(pUnitowner.getTeam())
						pWinnerTeam.changeEspionagePointsAgainstTeam(iLoserTeam,iBeute )
						PlotownerName = pPlotowner.getName ()
		        	                CyInterface().addMessage(iUnitowner,false,15,CyTranslator().getText("TXT_KEY_VERHOER_ESPIONAGE",(PlotownerName,iBeute)),'',0,'Art/Interface/Buttons/General/happy_person.dds',ColorTypes(44), iPlotX, iPlotY, True,True)
	### Verhr ende ###
	### Zwangsrekrutierung beginn ###
			if pUnit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_ZWANGSREKRUTIERUNG")):
				iPlotowner = pPlot.getOwner()
				iUnitowner = pUnit.getOwner()
				if (not iUnitowner == iPlotowner):
					iBeute = -3
					if iImprovement == gc.getInfoTypeForString("IMPROVEMENT_HAMLET"):
						iBeute = -5
					elif iImprovement == gc.getInfoTypeForString("IMPROVEMENT_VILLAGE"):
						iBeute = -7
					elif iImprovement == gc.getInfoTypeForString("IMPROVEMENT_TOWN"):
						iBeute = -9
					pUnit.changeDamage(iBeute,iPlotowner)
	### Zwangsrekrutierung ende ###
### nur fr echteImprovements - nicht fr Routes! Beginn###
		if (not self.__LOG_UNITPILLAGE):
			return
		CvUtil.pyPrint("Player %d's %s pillaged improvement %d and route %d at plot at (%d, %d)" 
			%(iOwner, PyInfo.UnitInfo(pUnit.getUnitType()).getDescription(), iImprovement, iRoute, iPlotX, iPlotY))
	
	def onUnitSpreadReligionAttempt(self, argsList):
		'Unit tries to spread religion to a city'
		pUnit, iReligion, bSuccess = argsList
		
		iX = pUnit.getX()
		iY = pUnit.getY()
		pPlot = CyMap().plot(iX, iY)
		pCity = pPlot.getPlotCity()
###100% falls favorite religion begin###
		pPlayer = gc.getPlayer(pCity.getOwner())
		iLeader = pPlayer.getLeaderType ()
		pLeader = gc.getLeaderHeadInfo(iLeader)
		iFavoriteReligion = pLeader.getFavoriteReligion ()
		if iReligion == iFavoriteReligion:
			if (bSuccess == false):
				pCity.setHasReligion(iReligion,True,True,True)
				LeaderName = pPlayer.getName ()
				ReligionName = gc.getReligionInfo(iReligion).getAdjectiveKey()
				CyInterface().addMessage(pUnit.getOwner(),false,15,CyTranslator().getText("TXT_KEY_MISSIONARY_FAVORITE_RELIGION",(LeaderName ,ReligionName)),'',0,'Art/Interface/Buttons/General/happy_person.dds',ColorTypes(44), iX, iY, True,True)
###100% falls favorite religion end###
	
	def onUnitGifted(self, argsList):
		'Unit is gifted from one player to another'
		pUnit, iGiftingPlayer, pPlotLocation = argsList

	def onUnitBuildImprovement(self, argsList):
		'Unit begins enacting a Build (building an Improvement or Route)'
		pUnit, iBuild, bFinished = argsList

	def onGoodyReceived(self, argsList):
		'Goody received'
		iPlayer, pPlot, pUnit, iGoodyType = argsList

		if (not self.__LOG_GOODYRECEIVED):
			return
		CvUtil.pyPrint('%s received a goody' %(gc.getPlayer(iPlayer).getCivilizationDescription(0)),)
	
	def onGreatPersonBorn(self, argsList):
		'Unit Promoted'
		pUnit, iPlayer, pCity = argsList
		player = PyPlayer(iPlayer)

		if pUnit.isNone() or pCity.isNone():
			return
		if (not self.__LOG_GREATPERSON):
			return
		CvUtil.pyPrint('A %s was born for %s in %s' %(pUnit.getName(), player.getCivilizationName(), pCity.getName()))
	
#### Kathy Beginn CityStateMission
	def onCityStateMission(self, argsList):
		'CityStateMission'
		iMissionType, iPlayer, iX, iY, bStart = argsList

		pPlot = gc.getMap().plot(iX,iY)
		if (bStart):
			if (iMissionType == 1):
				StrText = "verlorene Soehne und Toechter"
			elif (iMissionType == 2):
				StrText = "Naturheiligtum eines Stadtstaates"
			elif (iMissionType == 3):
				StrText = "Expansionsziel eines Stadtstaates"
			CyEngine().addLandmark(pPlot,StrText)
		else:
			CyEngine().removeLandmark(pPlot)
### Kathy End CityStateMission

	def onTechAcquired(self, argsList):
		'Tech Acquired'
		iTechType, iTeam, iPlayer, bAnnounce = argsList
### Terraformng beginn###
	###Kultivierung Beginn
                if iTechType == gc.getInfoTypeForString("TECH_KULTIVIERUNG"):
			iMapW = gc.getMap().getGridWidth()
			iMapH = gc.getMap().getGridHeight()
			TerraformPlotArray = []
        		for x in range(iMapW):
        			for y in range(iMapH):
        				loopPlot = gc.getMap().plot(x,y)
					if (loopPlot.getOwner() == iPlayer):
 						if loopPlot != None and not loopPlot.isNone() and loopPlot.getFeatureType() == -1:
							if (loopPlot.getTerrainType() == gc.getInfoTypeForString("TERRAIN_GRASS")):
       								TerraformPlotArray.append(loopPlot)
      			if len(TerraformPlotArray ) > 0:
				iMeineZufallszahl = CyGame().getSorenRandNum(len(TerraformPlotArray), 'IrgendeinTextAusDemDieZahlBerechnetWird')
          			TerraformPlotArray[iMeineZufallszahl].setTerrainType(gc.getInfoTypeForString("TERRAIN_FERTILE"),true,true)
	                        pPlayer = gc.getPlayer(iPlayer)
                                if pPlayer.isHuman():
                                        popup = PyPopup.PyPopup(-1)
                                        popup.setHeaderString(CyTranslator().getText("TXT_KEY_TERRFORMING_HEADER",(1,1)))
                                        popup.setBodyString(CyTranslator().getText("TXT_KEY_TERRAFORMING_KULTIVIERUNG_TEXT",(1,1)))
                               		popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)

	###Kultivierung End
	###Irrigation Beginn
                if iTechType == gc.getInfoTypeForString("TECH_IRRIGATION"):
			iMapW = gc.getMap().getGridWidth()
			iMapH = gc.getMap().getGridHeight()
			TerraformPlotArray = []
        		for x in range(iMapW):
        			for y in range(iMapH):
        				loopPlot = gc.getMap().plot(x,y)
					if (loopPlot.getOwner() == iPlayer):
 						if loopPlot != None and not loopPlot.isNone() and loopPlot.getFeatureType() == -1:
							if (loopPlot.getTerrainType() == gc.getInfoTypeForString("TERRAIN_DESERT")):
       								TerraformPlotArray.append(loopPlot)
      			if len(TerraformPlotArray ) > 0:
				iMeineZufallszahl = CyGame().getSorenRandNum(len(TerraformPlotArray), 'IrgendeinTextAusDemDieZahlBerechnetWird')
          			TerraformPlotArray[iMeineZufallszahl].setTerrainType(gc.getInfoTypeForString("TERRAIN_PLAINS"),true,true)
	                        pPlayer = gc.getPlayer(iPlayer)
                                if pPlayer.isHuman():
                                        popup = PyPopup.PyPopup(-1)
                                        popup.setHeaderString(CyTranslator().getText("TXT_KEY_TERRFORMING_HEADER",(1,1)))
                                        popup.setBodyString(CyTranslator().getText("TXT_KEY_TERRAFORMING_IRRIGATION_TEXT",(1,1)))
                               		popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)

	###Irrigation End
	### Grnland beginn
                if iTechType == gc.getInfoTypeForString("TECH_GRUENLANDWIRTSCHAFT"):
			iMapW = gc.getMap().getGridWidth()
			iMapH = gc.getMap().getGridHeight()
			TerraformPlotArray = []
        		for x in range(iMapW):
        			for y in range(iMapH):
        				loopPlot = gc.getMap().plot(x,y)
					if (loopPlot.getOwner() == iPlayer):
 						if loopPlot != None and not loopPlot.isNone() and loopPlot.getFeatureType() == -1:
							if (loopPlot.getTerrainType() == gc.getInfoTypeForString("TERRAIN_GRASS")):
       								TerraformPlotArray.append(loopPlot)
      			if len(TerraformPlotArray ) > 0:
				iMeineZufallszahl = CyGame().getSorenRandNum(len(TerraformPlotArray), 'IrgendeinTextAusDemDieZahlBerechnetWird')
          			TerraformPlotArray[iMeineZufallszahl].setTerrainType(gc.getInfoTypeForString("TERRAIN_WEIDEN"),true,true)
	                        pPlayer = gc.getPlayer(iPlayer)
                                if pPlayer.isHuman():
                                        popup = PyPopup.PyPopup(-1)
                                        popup.setHeaderString(CyTranslator().getText("TXT_KEY_TERRFORMING_HEADER",(1,1)))
                                        popup.setBodyString(CyTranslator().getText("TXT_KEY_TERRAFORMING_GRUENLAND_TEXT",(1,1)))
                               		popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)
	### Grnland END
	###Deichbau beginn
                if iTechType == gc.getInfoTypeForString("TECH_NEULAND"):
			iMapW = gc.getMap().getGridWidth()
			iMapH = gc.getMap().getGridHeight()
			TerraformPlotArray = []
        		for x in range(iMapW):
        			for y in range(iMapH):
        				loopPlot = gc.getMap().plot(x,y)
					if (loopPlot.getOwner() == iPlayer):
 						if loopPlot != None and not loopPlot.isNone() and loopPlot.getFeatureType() == -1:
							if (loopPlot.getTerrainType() == gc.getInfoTypeForString("TERRAIN_MARSH")):
       								TerraformPlotArray.append(loopPlot)
      			if len(TerraformPlotArray ) > 0:
				iMeineZufallszahl = CyGame().getSorenRandNum(len(TerraformPlotArray), 'IrgendeinTextAusDemDieZahlBerechnetWird')
          			TerraformPlotArray[iMeineZufallszahl].setTerrainType(gc.getInfoTypeForString("TERRAIN_GRASS"),true,true)
	                        pPlayer = gc.getPlayer(iPlayer)
                                if pPlayer.isHuman():
                                        popup = PyPopup.PyPopup(-1)
                                        popup.setHeaderString(CyTranslator().getText("TXT_KEY_TERRFORMING_HEADER",(1,1)))
                                        popup.setBodyString(CyTranslator().getText("TXT_KEY_TERRAFORMING_NEULAND_TEXT",(1,1)))
                               		popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)
	###Deichbau END
	### Entwsserung beginn
                if iTechType == gc.getInfoTypeForString("TECH_PHYSIOCRACY"):
			iMapW = gc.getMap().getGridWidth()
			iMapH = gc.getMap().getGridHeight()
			TerraformPlotArray = []
        		for x in range(iMapW):
        			for y in range(iMapH):
        				loopPlot = gc.getMap().plot(x,y)
					if (loopPlot.getOwner() == iPlayer):
 						if loopPlot != None and not loopPlot.isNone() and loopPlot.getFeatureType() == -1:
							if (loopPlot.getTerrainType() == gc.getInfoTypeForString("TERRAIN_MARSH")):
       								TerraformPlotArray.append(loopPlot)
      			if len(TerraformPlotArray ) > 0:
				iMeineZufallszahl = CyGame().getSorenRandNum(len(TerraformPlotArray), 'IrgendeinTextAusDemDieZahlBerechnetWird')
          			TerraformPlotArray[iMeineZufallszahl].setTerrainType(gc.getInfoTypeForString("TERRAIN_WEIDEN"),true,true)
	                        pPlayer = gc.getPlayer(iPlayer)
                                if pPlayer.isHuman():
                                        popup = PyPopup.PyPopup(-1)
                                        popup.setHeaderString(CyTranslator().getText("TXT_KEY_TERRFORMING_HEADER",(1,1)))
                                        popup.setBodyString(CyTranslator().getText("TXT_KEY_TERRAFORMING_DRAINAGE_TEXT",(1,1)))
                               		popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)
	###Entwsserung END
	### Flurbereinigung beginn
                if iTechType == gc.getInfoTypeForString("TECH_PROSPEKTION"):
			iMapW = gc.getMap().getGridWidth()
			iMapH = gc.getMap().getGridHeight()
			TerraformPlotArray = []
        		for x in range(iMapW):
        			for y in range(iMapH):
        				loopPlot = gc.getMap().plot(x,y)
					if (loopPlot.getOwner() == iPlayer):
 						if loopPlot != None and not loopPlot.isNone() and loopPlot.getFeatureType() == -1:
							if (loopPlot.getTerrainType() == gc.getInfoTypeForString("TERRAIN_DESERT")):
       								TerraformPlotArray.append(loopPlot)
      			if len(TerraformPlotArray ) > 0:
				iMeineZufallszahl = CyGame().getSorenRandNum(len(TerraformPlotArray), 'IrgendeinTextAusDemDieZahlBerechnetWird')
          			TerraformPlotArray[iMeineZufallszahl].setTerrainType(gc.getInfoTypeForString("TERRAIN_ROCKY"),true,true)
	                        pPlayer = gc.getPlayer(iPlayer)
                                if pPlayer.isHuman():
                                        popup = PyPopup.PyPopup(-1)
                                        popup.setHeaderString(CyTranslator().getText("TXT_KEY_TERRFORMING_HEADER",(1,1)))
                                        popup.setBodyString(CyTranslator().getText("TXT_KEY_TERRAFORMING_PROSPEKTION_DESERT_TEXT",(1,1)))
                               		popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)
	### Flurbereinigung  END
	### Bewsserung Maschbau beginn
                if iTechType == gc.getInfoTypeForString("TECH_MASCHINENBAU"):
			iMapW = gc.getMap().getGridWidth()
			iMapH = gc.getMap().getGridHeight()
			TerraformPlotArray = []
        		for x in range(iMapW):
        			for y in range(iMapH):
        				loopPlot = gc.getMap().plot(x,y)
					if (loopPlot.getOwner() == iPlayer):
 						if loopPlot != None and not loopPlot.isNone() and loopPlot.getFeatureType() == -1:
							if (loopPlot.getTerrainType() == gc.getInfoTypeForString("TERRAIN_ROCKY")):
       								TerraformPlotArray.append(loopPlot)
      			if len(TerraformPlotArray ) > 0:
				iMeineZufallszahl = CyGame().getSorenRandNum(len(TerraformPlotArray), 'IrgendeinTextAusDemDieZahlBerechnetWird')
          			TerraformPlotArray[iMeineZufallszahl].setTerrainType(gc.getInfoTypeForString("TERRAIN_PLAINS"),true,true)
	                        pPlayer = gc.getPlayer(iPlayer)
                                if pPlayer.isHuman():
                                        popup = PyPopup.PyPopup(-1)
                                        popup.setHeaderString(CyTranslator().getText("TXT_KEY_TERRFORMING_HEADER",(1,1)))
                                        popup.setBodyString(CyTranslator().getText("TXT_KEY_TERRAFORMING_MACHINE_IRRIGATION_TEXT",(1,1)))
                               		popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)
	### Bewsserung Maschbau  END
	### Dnger1 beginn
                if iTechType == gc.getInfoTypeForString("TECH_FERTILIZER"):
			iMapW = gc.getMap().getGridWidth()
			iMapH = gc.getMap().getGridHeight()
			TerraformPlotArray = []
        		for x in range(iMapW):
        			for y in range(iMapH):
        				loopPlot = gc.getMap().plot(x,y)
					if (loopPlot.getOwner() == iPlayer):
 						if loopPlot != None and not loopPlot.isNone() and loopPlot.getFeatureType() == -1:
							if (loopPlot.getTerrainType() == gc.getInfoTypeForString("TERRAIN_TUNDRA")):
       								TerraformPlotArray.append(loopPlot)
      			if len(TerraformPlotArray ) > 0:
				iMeineZufallszahl = CyGame().getSorenRandNum(len(TerraformPlotArray), 'IrgendeinTextAusDemDieZahlBerechnetWird')
          			TerraformPlotArray[iMeineZufallszahl].setTerrainType(gc.getInfoTypeForString("TERRAIN_GRASS"),true,true)
	                        pPlayer = gc.getPlayer(iPlayer)
                                if pPlayer.isHuman():
                                        popup = PyPopup.PyPopup(-1)
                                        popup.setHeaderString(CyTranslator().getText("TXT_KEY_TERRFORMING_HEADER",(1,1)))
                                        popup.setBodyString(CyTranslator().getText("TXT_KEY_TERRAFORMING_DUENGER1_TEXT",(1,1)))
                               		popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)
	### Dnger1 END
	### Dnger2 beginn
                if iTechType == gc.getInfoTypeForString("TECH_HABER_BOSCH"):
			iMapW = gc.getMap().getGridWidth()
			iMapH = gc.getMap().getGridHeight()
			TerraformPlotArray = []
        		for x in range(iMapW):
        			for y in range(iMapH):
        				loopPlot = gc.getMap().plot(x,y)
					if (loopPlot.getOwner() == iPlayer):
 						if loopPlot != None and not loopPlot.isNone() and loopPlot.getFeatureType() == -1:
							if (loopPlot.getTerrainType() == gc.getInfoTypeForString("TERRAIN_GRASS")):
       								TerraformPlotArray.append(loopPlot)
      			if len(TerraformPlotArray ) > 0:
				iMeineZufallszahl = CyGame().getSorenRandNum(len(TerraformPlotArray), 'IrgendeinTextAusDemDieZahlBerechnetWird')
          			TerraformPlotArray[iMeineZufallszahl].setTerrainType(gc.getInfoTypeForString("TERRAIN_FERTILE"),true,true)
	                        pPlayer = gc.getPlayer(iPlayer)
                                if pPlayer.isHuman():
                                        popup = PyPopup.PyPopup(-1)
                                        popup.setHeaderString(CyTranslator().getText("TXT_KEY_TERRFORMING_HEADER",(1,1)))
                                        popup.setBodyString(CyTranslator().getText("TXT_KEY_TERRAFORMING_DUENGER2_TEXT",(1,1)))
                               		popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)
	### Dnger2 END
	### Pestizid beginn
                if iTechType == gc.getInfoTypeForString("TECH_PESTIZIDE"):
			iMapW = gc.getMap().getGridWidth()
			iMapH = gc.getMap().getGridHeight()
			TerraformPlotArray = []
        		for x in range(iMapW):
        			for y in range(iMapH):
        				loopPlot = gc.getMap().plot(x,y)
					if (loopPlot.getOwner() == iPlayer):
 						if loopPlot != None and not loopPlot.isNone() and loopPlot.getFeatureType() == -1:
							if (loopPlot.getTerrainType() == gc.getInfoTypeForString("TERRAIN_PLAINS")):
       								TerraformPlotArray.append(loopPlot)
      			if len(TerraformPlotArray ) > 0:
				iMeineZufallszahl = CyGame().getSorenRandNum(len(TerraformPlotArray), 'IrgendeinTextAusDemDieZahlBerechnetWird')
          			TerraformPlotArray[iMeineZufallszahl].setTerrainType(gc.getInfoTypeForString("TERRAIN_WEIDEN"),true,true)
	                        pPlayer = gc.getPlayer(iPlayer)
                                if pPlayer.isHuman():
                                        popup = PyPopup.PyPopup(-1)
                                        popup.setHeaderString(CyTranslator().getText("TXT_KEY_TERRFORMING_HEADER",(1,1)))
                                        popup.setBodyString(CyTranslator().getText("TXT_KEY_TERRAFORMING_PESTIZIDE_TEXT",(1,1)))
                               		popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)
	### Pestizid END
	### SteamTraktor beginn
                if iTechType == gc.getInfoTypeForString("TECH_LOKOMOBILE"):
			iMapW = gc.getMap().getGridWidth()
			iMapH = gc.getMap().getGridHeight()
			TerraformPlotArray = []
        		for x in range(iMapW):
        			for y in range(iMapH):
        				loopPlot = gc.getMap().plot(x,y)
					if (loopPlot.getOwner() == iPlayer):
 						if loopPlot != None and not loopPlot.isNone() and loopPlot.getFeatureType() == -1:
							if (loopPlot.getTerrainType() == gc.getInfoTypeForString("TERRAIN_MARSH")):
       								TerraformPlotArray.append(loopPlot)
      			if len(TerraformPlotArray ) > 0:
				iMeineZufallszahl = CyGame().getSorenRandNum(len(TerraformPlotArray), 'IrgendeinTextAusDemDieZahlBerechnetWird')
          			TerraformPlotArray[iMeineZufallszahl].setTerrainType(gc.getInfoTypeForString("TERRAIN_WETLANDS"),true,true)
	                        pPlayer = gc.getPlayer(iPlayer)
                                if pPlayer.isHuman():
                                        popup = PyPopup.PyPopup(-1)
                                        popup.setHeaderString(CyTranslator().getText("TXT_KEY_TERRFORMING_HEADER",(1,1)))
                                        popup.setBodyString(CyTranslator().getText("TXT_KEY_TERRAFORMING_STEAM_TRAKTOR_TEXT",(1,1)))
                               		popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)
	### SteamTraktor  END
	### Traktor beginn
                if iTechType == gc.getInfoTypeForString("TECH_LANDMASCHINEN"):
			iMapW = gc.getMap().getGridWidth()
			iMapH = gc.getMap().getGridHeight()
			TerraformPlotArray = []
        		for x in range(iMapW):
        			for y in range(iMapH):
        				loopPlot = gc.getMap().plot(x,y)
					if (loopPlot.getOwner() == iPlayer):
 						if loopPlot != None and not loopPlot.isNone() and loopPlot.getFeatureType() == -1:
							if (loopPlot.getTerrainType() == gc.getInfoTypeForString("TERRAIN_SNOW")):
       								TerraformPlotArray.append(loopPlot)
      			if len(TerraformPlotArray ) > 0:
				iMeineZufallszahl = CyGame().getSorenRandNum(len(TerraformPlotArray), 'IrgendeinTextAusDemDieZahlBerechnetWird')
          			TerraformPlotArray[iMeineZufallszahl].setTerrainType(gc.getInfoTypeForString("TERRAIN_TUNDRA"),true,true)
	                        pPlayer = gc.getPlayer(iPlayer)
                                if pPlayer.isHuman():
                                        popup = PyPopup.PyPopup(-1)
                                        popup.setHeaderString(CyTranslator().getText("TXT_KEY_TERRFORMING_HEADER",(1,1)))
                                        popup.setBodyString(CyTranslator().getText("TXT_KEY_TERRAFORMING_LANDMASCHINEN_PLUG_TEXT",(1,1)))
                               		popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)
	### Traktor  END
	### Green Wall beginn
                if iTechType == gc.getInfoTypeForString("TECH_NACHHALTIGKEIT"):
			iMapW = gc.getMap().getGridWidth()
			iMapH = gc.getMap().getGridHeight()
			TerraformPlotArray = []
        		for x in range(iMapW):
        			for y in range(iMapH):
        				loopPlot = gc.getMap().plot(x,y)
					if (loopPlot.getOwner() == iPlayer):
 						if loopPlot != None and not loopPlot.isNone() and loopPlot.getFeatureType() == -1:
							if (loopPlot.getTerrainType() == gc.getInfoTypeForString("TERRAIN_DESERT")):
								if (iPlot.getFeatureType() == -1):
	       								TerraformPlotArray.append(loopPlot)
      			if len(TerraformPlotArray ) > 0:
				iMeineZufallszahl = CyGame().getSorenRandNum(len(TerraformPlotArray), 'IrgendeinTextAusDemDieZahlBerechnetWird')
          			TerraformPlotArray[iMeineZufallszahl].setTerrainType(gc.getInfoTypeForString("TERRAIN_PLAINS"),true,true)
          			TerraformPlotArray[iMeineZufallszahl].setFeatureType(gc.getInfoTypeForString("FEATURE_PALMS"),0)
	                        pPlayer = gc.getPlayer(iPlayer)
                                if pPlayer.isHuman():
                                        popup = PyPopup.PyPopup(-1)
                                        popup.setHeaderString(CyTranslator().getText("TXT_KEY_TERRFORMING_HEADER",(1,1)))
                                        popup.setBodyString(CyTranslator().getText("TXT_KEY_TERRAFORMING_GREEN_WALL_TEXT",(1,1)))
                               		popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)
	###Green Wall end
	### Futur Farm beginn
                if iTechType == gc.getInfoTypeForString("TECH_GREEN_GENETIC_ENGINEERING"):
			iMapW = gc.getMap().getGridWidth()
			iMapH = gc.getMap().getGridHeight()
			TerraformPlotArray = []
        		for x in range(iMapW):
        			for y in range(iMapH):
        				loopPlot = gc.getMap().plot(x,y)
					if (loopPlot.getOwner() == iPlayer):
 						if loopPlot != None and not loopPlot.isNone() and loopPlot.getFeatureType() == -1:
							if (loopPlot.getTerrainType() == gc.getInfoTypeForString("TERRAIN_GRASS")):
       								TerraformPlotArray.append(loopPlot)
      			if len(TerraformPlotArray ) > 0:
				iMeineZufallszahl = CyGame().getSorenRandNum(len(TerraformPlotArray), 'IrgendeinTextAusDemDieZahlBerechnetWird')
          			TerraformPlotArray[iMeineZufallszahl].setTerrainType(gc.getInfoTypeForString("TERRAIN_WEIDEN"),true,true)
	                        pPlayer = gc.getPlayer(iPlayer)
                                if pPlayer.isHuman():
                                        popup = PyPopup.PyPopup(-1)
                                        popup.setHeaderString(CyTranslator().getText("TXT_KEY_TERRFORMING_HEADER",(1,1)))
                                        popup.setBodyString(CyTranslator().getText("TXT_KEY_TERRAFORMING_GREEN_GENETICS_TEXT",(1,1)))
                               		popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)
	### Future Farm END
	### Futur Farm beginn
                if iTechType == gc.getInfoTypeForString("TECH_FUTURE_FARMING"):
			iMapW = gc.getMap().getGridWidth()
			iMapH = gc.getMap().getGridHeight()
			TerraformPlotArray = []
        		for x in range(iMapW):
        			for y in range(iMapH):
        				loopPlot = gc.getMap().plot(x,y)
					if (loopPlot.getOwner() == iPlayer):
 						if loopPlot != None and not loopPlot.isNone() and loopPlot.getFeatureType() == -1:
							if (loopPlot.getTerrainType() == gc.getInfoTypeForString("TERRAIN_SNOW")):
       								TerraformPlotArray.append(loopPlot)
      			if len(TerraformPlotArray ) > 0:
				iMeineZufallszahl = CyGame().getSorenRandNum(len(TerraformPlotArray), 'IrgendeinTextAusDemDieZahlBerechnetWird')
          			TerraformPlotArray[iMeineZufallszahl].setTerrainType(gc.getInfoTypeForString("TERRAIN_PLAINS"),true,true)
	                        pPlayer = gc.getPlayer(iPlayer)
                                if pPlayer.isHuman():
                                        popup = PyPopup.PyPopup(-1)
                                        popup.setHeaderString(CyTranslator().getText("TXT_KEY_TERRFORMING_HEADER",(1,1)))
                                        popup.setBodyString(CyTranslator().getText("TXT_KEY_TERRAFORMING_FUTURE_TEXT",(1,1)))
                               		popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)
	### Future Farm END
### Terraformng end###
###Spawn Civs beginn###
	###Pirate beginn###
                if iTechType == gc.getInfoTypeForString("TECH_OPTICS"):
			if (gc.getGame().isOption(gc.getInfoTypeForString("GAMEOPTION_SPAWN_NEW_CIVS"))):
	                        pPlayer = gc.getPlayer(iPlayer)
        	                iTeam = pPlayer.getTeam()
                	        isTeamFirst = True
				iMaxTeams = gc.getMAX_CIV_TEAMS ()
		                for i in range(iMaxTeams):
        	                        if i == iTeam:continue
                	                pCurTeam = gc.getTeam(i)
                        	        if pCurTeam.isHasTech(iTechType):
                                	        isTeamFirst = False
                                        	break
	                        if isTeamFirst:
					if gc.getMAX_CIV_PLAYERS ()>CyGame().countCivPlayersAlive ():
					        NewID = -1
					        for NumCiv in xrange (gc.getMAX_PLAYERS ()):
        					        PotPlayer = gc.getPlayer(NumCiv)
        					        if not PotPlayer.isEverAlive ():
                					        NewID = NumCiv
                        					break
					        if NewID ==-1:
						        for NumCiv in xrange (gc.getMAX_PLAYERS ()):
        						        PotPlayer = gc.getPlayer(NumCiv)
        					        	if not PotPlayer.isAlive ():
                					        	NewID = NumCiv
                        						break
					        if NewID ==-1:
					                return
						aPirateStates = [gc.getInfoTypeForString("CIVILIZATION_PIRATE_VITALIER"),gc.getInfoTypeForString("CIVILIZATION_PIRATE_KILIKIEN"),gc.getInfoTypeForString("CIVILIZATION_PIRATE_NORMAN"),gc.getInfoTypeForString("CIVILIZATION_PIRATE_SOMALIA"),gc.getInfoTypeForString("CIVILIZATION_PIRATE_PORT_ROYAL"),gc.getInfoTypeForString("CIVILIZATION_PIRATE_BUKANIER"),gc.getInfoTypeForString("CIVILIZATION_STADTSTAAT_BARBARESK"),gc.getInfoTypeForString("CIVILIZATION_PIRATE_WOKOU")]
						dice = gc.getGame().getMapRand()
						randomNum = dice.get(len(aPirateStates) , "OracleSayMeTheLeader" )
						iCiv = aPirateStates[randomNum]
						PirateCiv = gc.getCivilizationInfo(iCiv)
###########alter Code
## 					        for iLeaders in range(gc.getNumLeaderHeadInfos ()):
  #    						       	if PirateCiv.isLeaders(iLeaders):
#    					              		NewLeaderID=iLeaders
 #                 						break
#### Leader sollen alle die zur Civ gehren werden knnen!!####
						LeaderArray = []
 					        for iLeaders in range(gc.getNumLeaderHeadInfos ()):
      						       	if PirateCiv.isLeaders(iLeaders):
       								LeaderArray.append(iLeaders)
			      			if len(LeaderArray  ) > 0:
							iMeineZufallszahl = CyGame().getSorenRandNum(len(LeaderArray), 'IrgendeinTextAusDemDieZahlBerechnetWird')
							NewLeaderID=LeaderArray[iMeineZufallszahl]
#### Leader solleen alle werden knnen!!###
						CyGame().addPlayer(NewID,NewLeaderID,iCiv)
	   					pNewPlayer = gc.getPlayer(NewID)
     						NewTeam = gc.getTeam(pNewPlayer.getTeam())
  						NewTeamID = NewTeam.getID()
						techcount=0
						pOldTeam = gc.getTeam(iTeam)
						for techcount in range (gc.getNumTechInfos()):
                			        	if ((pOldTeam.isHasTech(techcount)==true)):
                        					NewTeam.setHasTech(techcount,1,NewID,0,1)
						NewTeam.setHasTech(gc.getInfoTypeForString("TECH_SCHIFFSGESCHUETZE"),1,NewID,0,1)
						iMaxY = CyMap().getGridHeight()
						iMaxX = CyMap().getGridWidth()
						iSollNumCities = CyGame().getHandicapType()+1+CyMap().getWorldSize()/2
					###Bevor schlechte Sdte gesetzt werden: gute Barbarenstdte finden
						iBarbs= gc.getBARBARIAN_PLAYER ()
						pBarbs = gc.getPlayer(iBarbs)
						(loopCity, iter) = pBarbs.firstCity(false)
						while(loopCity):
							pNewPlayer.acquireCity(loopCity,False,True)
							(loopCity, iter) = (pBarbs.nextCity(iter, true))
						if pNewPlayer.getNumCities() < iSollNumCities :
					###Bevor schlechte Sdte gesetzt werden: gute Barbarenstdte finden ENDE
							for i in range(iMaxX):
								for j in range(iMaxY):
									if pNewPlayer.getNumCities() < iSollNumCities :
										loopPlot = gc.getMap().plot(i,j)
										bSiedlungsplatz = false
										if loopPlot.isCoastalLand():
											pArea = loopPlot.area()
											if loopPlot.getOwner() == -1:
												bSiedlungsplatz = true
											elif pArea.getNumCities() == 0:
												bSiedlungsplatz = true
											if bSiedlungsplatz:
												pNewPlayer.found(i,j)
						if pNewPlayer.canContact(iPlayer):
							if (pPlayer.getNumCities > 10):
								(loopCity, iter) = (pPlayer.firstCity(True))
								while(loopCity):
									if loopCity.isCoastal(20):
										if (loopCity.isCapital() == false):
											pNewPlayer.acquireCity(loopCity,False,True)
											break
									(loopCity, iter) = (pPlayer.nextCity(iter, true))
						for i in range (pNewPlayer.getNumCities()):
							pCity = pNewPlayer.getCity(i)
							pCity.changePopulation(4)
							iCityX = pCity.getX()
							iCityY = pCity.getY()
							for i in range(3):
								Defender = pCity.getConscriptUnit()
								pNewPlayer.initUnit( Defender, iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH ) 
								if pCity.isCoastal(20):  
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_PRIVATEER"), iCityX,iCityY, UnitAITypes.UNITAI_PIRATE_SEA, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_SEESOLDATEN"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
							pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_BOMBARD_TOWER"), iCityX,iCityY, UnitAITypes.UNITAI_RANGED_ATTACK, DirectionTypes.DIRECTION_NORTH )
							pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_FIELD_ARTILLERY"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
							pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_WORKER"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
							if pCity.isCoastal(20):
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_WORKBOAT"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER_SEA, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_GALLEON"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
							pCity.changeCulture(NewID,10,1)
							pCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_LIGHTHOUSE"),1)
							pCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_GRANARY"),1)
							pCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_HERBERGE"),1)
							pCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_HARBOR"),1)
							pCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_NETHERLANDS_DIKE"),1)
						(loopUnit, iter) = pNewPlayer.firstUnit(true)
						while(loopUnit):
							loopUnit.changeExperience(5,10,false,false,false)
							if (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_SEA")):
								loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_PIRATE1"),1)
								loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_PIRATE2"),1)
							elif (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_IMMOBILE")):
								loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_GARRISON1"),1)
								loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_DRILL1"),1)
							else:
								loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_GARRISON1"),1)
								loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_AMPHIBIOUS"),1)
							(loopUnit, iter) = (pNewPlayer.nextUnit(iter, true))
						iOldCiv = pPlayer.getCivilizationType()
				        	pNewPlayer.setGold(pPlayer.getGold()*10)
						PlayerAdjectiv = gc.getCivilizationInfo(iOldCiv).getDescription()
						NewPlayerAdjectiv = PirateCiv.getDescription()
                	                        for iPlayer in range (gc.getMAX_CIV_PLAYERS()):
                        	                	pMessagePlayer = gc.getPlayer(iPlayer)
                                	        	if pMessagePlayer.isHuman():
                                        	        	popup = PyPopup.PyPopup(-1)
                                                		popup.setHeaderString(CyTranslator().getText("TXT_KEY_PIRATESTATE_BORN_HEADER",(PlayerAdjectiv,NewPlayerAdjectiv)))
                                                        	popup.setBodyString(CyTranslator().getText("TXT_KEY_PIRATESTATE_BORN_TEXT",(PlayerAdjectiv,NewPlayerAdjectiv)))
                               		               		popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)
	###Pirate ENDE###
	### Rise of Empire beginn###
                elif iTechType == gc.getInfoTypeForString("TECH_STRATEGY"):
			if (gc.getGame().isOption(gc.getInfoTypeForString("GAMEOPTION_SPAWN_NEW_CIVS"))):
	                        pPlayer = gc.getPlayer(iPlayer)
        	                iTeam = pPlayer.getTeam()
                	        isTeamFirst = True
				iMaxTeams = gc.getMAX_CIV_TEAMS ()
		                for i in range(iMaxTeams):
        	                        if i == iTeam:continue
                	                pCurTeam = gc.getTeam(i)
                        	        if pCurTeam.isHasTech(iTechType):
                                	        isTeamFirst = False
                                        	break
	                        if isTeamFirst:
					if gc.getMAX_CIV_PLAYERS ()>CyGame().countCivPlayersAlive ():
					        NewID = -1
					        for NumCiv in xrange (gc.getMAX_PLAYERS ()):
        					        PotPlayer = gc.getPlayer(NumCiv)
        					        if not PotPlayer.isEverAlive ():
                					        NewID = NumCiv
                        					break
					        if NewID ==-1:
						        for NumCiv in xrange (gc.getMAX_PLAYERS ()):
        						        PotPlayer = gc.getPlayer(NumCiv)
        						        if not PotPlayer.isAlive():
                						        NewID = NumCiv
                        						break
					        if NewID ==-1:
					                return
						aPirateStates = [gc.getInfoTypeForString("CIVILIZATION_ROME"),gc.getInfoTypeForString("CIVILIZATION_GREECE"),gc.getInfoTypeForString("CIVILIZATION_MACEDONIA"),gc.getInfoTypeForString("CIVILIZATION_MINOA"),gc.getInfoTypeForString("CIVILIZATION_CARTHAGE")]
						dice = gc.getGame().getMapRand()
						randomNum = dice.get(len(aPirateStates) , "OracleSayMeTheLeader" )
						iCiv = aPirateStates[randomNum]
						PirateCiv = gc.getCivilizationInfo(iCiv)
# 					        for iLeaders in range(gc.getNumLeaderHeadInfos ()):
 #     						       	if PirateCiv .isLeaders(iLeaders):
  #  					              		NewLeaderID=iLeaders
   #               						break
#### Leader sollen alle die zur Civ gehren werden knnen!!####
						LeaderArray = []
 					        for iLeaders in range(gc.getNumLeaderHeadInfos ()):
      						       	if PirateCiv.isLeaders(iLeaders):
       								LeaderArray.append(iLeaders)
			      			if len(LeaderArray  ) > 0:
							iMeineZufallszahl = CyGame().getSorenRandNum(len(LeaderArray), 'IrgendeinTextAusDemDieZahlBerechnetWird')
							NewLeaderID=LeaderArray[iMeineZufallszahl]
#### Leader solleen alle werden knnen!!###
						CyGame().addPlayer(NewID,NewLeaderID,iCiv)
	   					pNewPlayer = gc.getPlayer(NewID)
     						NewTeam = gc.getTeam(pNewPlayer.getTeam())
  						NewTeamID = NewTeam.getID()
		###getbiggestEmpire
						iDPlayerBiggestEmpire = -1
						iNumBiggestEmpireCities = 0
						for iPlayer in range(gc.getMAX_PLAYERS()):
							player = gc.getPlayer(iPlayer)
							if (player.isAlive()):
								iPlayerCities = player.getNumCities()
								if iPlayerCities > iNumBiggestEmpireCities:
									if iPlayerCities > 2:
										iNumBiggestEmpireCities = iPlayerCities
										iDPlayerBiggestEmpire = iPlayer
						if (iDPlayerBiggestEmpire  > -1):
							pTargetEmpire = gc.getPlayer(iDPlayerBiggestEmpire)
							iTargetEmpireTeam = pTargetEmpire.getTeam ()
							pTargetEmpireTeam = gc.getTeam(iTargetEmpireTeam)
		###getbiggestEmpire END
							techcount=0
							for techcount in range (gc.getNumTechInfos()):
                				        	if ((pTargetEmpireTeam.isHasTech(techcount)==true)):
                        				    		NewTeam.setHasTech(techcount,1,NewID,0,1)
							iCitiesNewPlayer = pTargetEmpire.getNumCities()/2
							iCityCount = 0
							(loopCity, iter) = pTargetEmpire.firstCity(True)
							while(loopCity):
								iCityX = loopCity.getX()
								iCityY = loopCity.getY()
								pNewPlayer.acquireCity(loopCity,False,True)
								Defender = loopCity.getConscriptUnit()
								for i in range(3):
		###init Units
									pNewPlayer.initUnit( Defender, iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )                
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_SWORDSMAN"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_WORKER"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_BALLISTENSTELLUNG"), iCityX,iCityY, UnitAITypes.UNITAI_RANGED_ATTACK, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_BALLISTA"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
								if loopCity.isCoastal(20):
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_TRIREME_PIRAT"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER_SEA, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_WORKBOAT"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER_SEA, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_BIREME"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )			
		###init Units
		###init Gebude und Kultur
### More culture!!!								loopCity.changeCulture(NewID,10,1)
								iExtraCulture = loopCity.getCulture(iDPlayerBiggestEmpire)/2
								loopCity.changeCulture(NewID,iExtraCulture,1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_GRANARY"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_LIBRARY"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_MARKET"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_BARRACKS"),1)
		###init Gebude und Kultur
								iCityCount = iCityCount+1
								if iCityCount == iCitiesNewPlayer:
									break
								(loopCity, iter) = pTargetEmpire.nextCity(iter, true)
						        pNewPlayer.setGold(pTargetEmpire.getGold()/2)
		###Basisbefrderungen Einheiten
							(loopUnit, iter) = pNewPlayer.firstUnit(true)
							while(loopUnit):
								loopUnit.changeExperience(2,10,false,false,false)
								if (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_SEA")):
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT1"),1)
								elif (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_IMMOBILE")):
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_GARRISON1"),1)
								else:
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_GARRISON1"),1)
								(loopUnit, iter) = (pNewPlayer.nextUnit(iter, true))
		###Basisbefrderungen Einheiten
							iOldCiv = pTargetEmpire.getCivilizationType()
							PlayerAdjectiv = gc.getCivilizationInfo(iOldCiv).getDescription()
							NewPlayerAdjectiv = PirateCiv.getDescription()
                	                		for iPlayer in range (gc.getMAX_CIV_PLAYERS()):
                        	                		pMessagePlayer = gc.getPlayer(iPlayer)
                                	               		if pMessagePlayer.isHuman():
                                        	               		popup = PyPopup.PyPopup(-1)
                                                	        	popup.setHeaderString(CyTranslator().getText("TXT_KEY_NEW_EMPIRE_CONQUEST_HEADER",(PlayerAdjectiv,NewPlayerAdjectiv)))
                                                       			popup.setBodyString(CyTranslator().getText("TXT_KEY_NEW_EMPIRE_CONQUEST_ANTIK_TEXT",(PlayerAdjectiv,NewPlayerAdjectiv)))
                                                       			popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)
	### Rise of Empire End###
	### Seevlker beginn###
                elif iTechType == gc.getInfoTypeForString("TECH_PIRATERIE"):
			if (gc.getGame().isOption(gc.getInfoTypeForString("GAMEOPTION_SPAWN_NEW_CIVS"))):
	                        pPlayer = gc.getPlayer(iPlayer)
        	                iTeam = pPlayer.getTeam()
                	        isTeamFirst = True
				iMaxTeams = gc.getMAX_CIV_TEAMS ()
		                for i in range(iMaxTeams):
        	                        if i == iTeam:continue
                	                pCurTeam = gc.getTeam(i)
                        	        if pCurTeam.isHasTech(iTechType):
                                	        isTeamFirst = False
                                        	break
	                        if isTeamFirst:
					if gc.getMAX_CIV_PLAYERS ()>CyGame().countCivPlayersAlive ():
					        NewID = -1
					        for NumCiv in xrange (gc.getMAX_PLAYERS ()):
        					        PotPlayer = gc.getPlayer(NumCiv)
        					        if not PotPlayer.isEverAlive ():
                					        NewID = NumCiv
                        					break
					        if NewID ==-1:
						        for NumCiv in xrange (gc.getMAX_PLAYERS ()):
        						        PotPlayer = gc.getPlayer(NumCiv)
        						        if not PotPlayer.isAlive():
                						        NewID = NumCiv
                        						break
					        if NewID ==-1:
					                return
						aPirateStates = [gc.getInfoTypeForString("CIVILIZATION_PHOENICIAN"),gc.getInfoTypeForString("CIVILIZATION_VIKING"),gc.getInfoTypeForString("CIVILIZATION_POLYNESIA"),gc.getInfoTypeForString("CIVILIZATION_VENEZIEN"),gc.getInfoTypeForString("CIVILIZATION_DENMARK")]
						dice = gc.getGame().getMapRand()
						randomNum = dice.get(len(aPirateStates) , "OracleSayMeTheLeader" )
						iCiv = aPirateStates[randomNum]
						PirateCiv = gc.getCivilizationInfo(iCiv)
# 					        for iLeaders in range(gc.getNumLeaderHeadInfos ()):
 #     						       	if PirateCiv .isLeaders(iLeaders):
  #  					              		NewLeaderID=iLeaders
   #               						break
#### Leader sollen alle die zur Civ gehren werden knnen!!####
						LeaderArray = []
 					        for iLeaders in range(gc.getNumLeaderHeadInfos ()):
      						       	if PirateCiv.isLeaders(iLeaders):
       								LeaderArray.append(iLeaders)
			      			if len(LeaderArray  ) > 0:
							iMeineZufallszahl = CyGame().getSorenRandNum(len(LeaderArray), 'IrgendeinTextAusDemDieZahlBerechnetWird')
							NewLeaderID=LeaderArray[iMeineZufallszahl]
#### Leader solleen alle werden knnen!!###
						CyGame().addPlayer(NewID,NewLeaderID,iCiv)
	   					pNewPlayer = gc.getPlayer(NewID)
     						NewTeam = gc.getTeam(pNewPlayer.getTeam())
  						NewTeamID = NewTeam.getID()
		###getbiggestEmpire
						iDPlayerBiggestEmpire = -1
						iNumBiggestEmpireCities = 0
						for iPlayer in range(gc.getMAX_PLAYERS()):
							player = gc.getPlayer(iPlayer)
							if (player.isAlive()):
								iPlayerCities = player.getNumCities()
								if iPlayerCities > iNumBiggestEmpireCities:
									if iPlayerCities > 2:
										iNumBiggestEmpireCities = iPlayerCities
										iDPlayerBiggestEmpire = iPlayer
						if (iDPlayerBiggestEmpire  > -1):
							pTargetEmpire = gc.getPlayer(iDPlayerBiggestEmpire)
							iTargetEmpireTeam = pTargetEmpire.getTeam ()
							pTargetEmpireTeam = gc.getTeam(iTargetEmpireTeam)
		###getbiggestEmpire END
							techcount=0
							for techcount in range (gc.getNumTechInfos()):
                				        	if ((pTargetEmpireTeam.isHasTech(techcount)==true)):
                        				    		NewTeam.setHasTech(techcount,1,NewID,0,1)
							iCitiesNewPlayer = pTargetEmpire.getNumCities()/2
							iCityCount = 0
							(loopCity, iter) = pTargetEmpire.firstCity(True)
							while(loopCity):
								iCityX = loopCity.getX()
								iCityY = loopCity.getY()
								pNewPlayer.acquireCity(loopCity,False,True)
								for i in range(3):
		###init Units
									Defender = loopCity.getConscriptUnit ()
									pNewPlayer.initUnit( Defender, iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )                
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_STREITAXT"), iCityX,iCityY, UnitAITypes.UNITAI_RANGED_ATTACK, DirectionTypes.DIRECTION_NORTH )
									if loopCity.isCoastal(20):
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_TRIREME_PIRAT"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER_SEA, DirectionTypes.DIRECTION_NORTH )
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_WORKBOAT"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER_SEA, DirectionTypes.DIRECTION_NORTH )
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_BIREME"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )			

								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_WACHTURM"), iCityX,iCityY, UnitAITypes.UNITAI_RANGED_ATTACK, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_WORKER"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_HEAVY_SPEARMAN"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_HEAVY_ARCHER"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_RAMME"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
		###init Units
		###init Gebude und Kultur
### More culture!!!								loopCity.changeCulture(NewID,10,1)
								iExtraCulture = loopCity.getCulture(iDPlayerBiggestEmpire)/2
								loopCity.changeCulture(NewID,iExtraCulture,1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_GRANARY"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_STABLE"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_STEUEREINTREIBER"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_BARRACKS"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_TRAINING_CAMP"),1)
								if loopCity.isCoastal(20):
									loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_HARBOR"),1)
		###init Gebude und Kultur
								iCityCount = iCityCount+1
								if iCityCount == iCitiesNewPlayer:
									break
								(loopCity, iter) = pTargetEmpire.nextCity(iter, true)
						        pNewPlayer.setGold(pTargetEmpire.getGold()/2)
		###Basisbefrderungen Einheiten
							(loopUnit, iter) = pNewPlayer.firstUnit(true)
							while(loopUnit):
								loopUnit.changeExperience(3,10,false,false,false)
								if (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_SEA")):
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT1"),1)
								elif (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_IMMOBILE")):
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_GARRISON1"),1)
								else:
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_GARRISON1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_SHOCK1"),1)
								(loopUnit, iter) = (pNewPlayer.nextUnit(iter, true))
		###Basisbefrderungen Einheiten
							iOldCiv = pTargetEmpire.getCivilizationType()
							PlayerAdjectiv = gc.getCivilizationInfo(iOldCiv).getDescription()
							NewPlayerAdjectiv = PirateCiv.getDescription()
                	                		for iPlayer in range (gc.getMAX_CIV_PLAYERS()):
                        	                		pMessagePlayer = gc.getPlayer(iPlayer)
                                	               		if pMessagePlayer.isHuman():
                                        	               		popup = PyPopup.PyPopup(-1)
                                                	        	popup.setHeaderString(CyTranslator().getText("TXT_KEY_NEW_EMPIRE_CONQUEST_HEADER",(PlayerAdjectiv,NewPlayerAdjectiv)))
                                                       			popup.setBodyString(CyTranslator().getText("TXT_KEY_NEW_EMPIRE_CONQUEST_SEEVOLK_TEXT",(PlayerAdjectiv,NewPlayerAdjectiv)))
                                                       			popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)
	### Seevlker End###
	### Reiterhorden beginn###
                elif iTechType == gc.getInfoTypeForString("TECH_STIRRUP"):
			if (gc.getGame().isOption(gc.getInfoTypeForString("GAMEOPTION_SPAWN_NEW_CIVS"))):
	                        pPlayer = gc.getPlayer(iPlayer)
        	                iTeam = pPlayer.getTeam()
                	        isTeamFirst = True
				iMaxTeams = gc.getMAX_CIV_TEAMS ()
		                for i in range(iMaxTeams):
        	                        if i == iTeam:continue
                	                pCurTeam = gc.getTeam(i)
                        	        if pCurTeam.isHasTech(iTechType):
                                	        isTeamFirst = False
                                        	break
	                        if isTeamFirst:
					if gc.getMAX_CIV_PLAYERS ()>CyGame().countCivPlayersAlive ():
					        NewID = -1
					        for NumCiv in xrange (gc.getMAX_PLAYERS ()):
        					        PotPlayer = gc.getPlayer(NumCiv)
        					        if not PotPlayer.isEverAlive ():
                					        NewID = NumCiv
                        					break
					        if NewID ==-1:
						        for NumCiv in xrange (gc.getMAX_PLAYERS ()):
        						        PotPlayer = gc.getPlayer(NumCiv)
        						        if not PotPlayer.isAlive():
                						        NewID = NumCiv
                        						break
					        if NewID ==-1:
					                return
						aPirateStates = [gc.getInfoTypeForString("CIVILIZATION_SCYTH"),gc.getInfoTypeForString("CIVILIZATION_MONGOL"),gc.getInfoTypeForString("CIVILIZATION_HUNNEN"),gc.getInfoTypeForString("CIVILIZATION_BERBERS"),gc.getInfoTypeForString("CIVILIZATION_APACHE"),gc.getInfoTypeForString("CIVILIZATION_STADTSTAAT_UZBEKISTAN"),gc.getInfoTypeForString("CIVILIZATION_UKRAINE")]
						dice = gc.getGame().getMapRand()
						randomNum = dice.get(len(aPirateStates) , "OracleSayMeTheLeader" )
						iCiv = aPirateStates[randomNum]
						PirateCiv = gc.getCivilizationInfo(iCiv)
# 					        for iLeaders in range(gc.getNumLeaderHeadInfos ()):
 #     						       	if PirateCiv .isLeaders(iLeaders):
  #  					              		NewLeaderID=iLeaders
   #               						break
#### Leader sollen alle die zur Civ gehren werden knnen!!####
						LeaderArray = []
 					        for iLeaders in range(gc.getNumLeaderHeadInfos ()):
      						       	if PirateCiv.isLeaders(iLeaders):
       								LeaderArray.append(iLeaders)
			      			if len(LeaderArray  ) > 0:
							iMeineZufallszahl = CyGame().getSorenRandNum(len(LeaderArray), 'IrgendeinTextAusDemDieZahlBerechnetWird')
							NewLeaderID=LeaderArray[iMeineZufallszahl] 
#### Leader solleen alle werden knnen!!###
						CyGame().addPlayer(NewID,NewLeaderID,iCiv)
	   					pNewPlayer = gc.getPlayer(NewID)
     						NewTeam = gc.getTeam(pNewPlayer.getTeam())
  						NewTeamID = NewTeam.getID()
		###getbiggestEmpire
						iDPlayerBiggestEmpire = -1
						iNumBiggestEmpireCities = 0
						for iPlayer in range(gc.getMAX_PLAYERS()):
							player = gc.getPlayer(iPlayer)
							if (player.isAlive()):
								iPlayerCities = player.getNumCities()
								if iPlayerCities > iNumBiggestEmpireCities:
									if iPlayerCities > 2:
										iNumBiggestEmpireCities = iPlayerCities
										iDPlayerBiggestEmpire = iPlayer
						if (iDPlayerBiggestEmpire  > -1):
							pTargetEmpire = gc.getPlayer(iDPlayerBiggestEmpire)
							iTargetEmpireTeam = pTargetEmpire.getTeam ()
							pTargetEmpireTeam = gc.getTeam(iTargetEmpireTeam)
		###getbiggestEmpire END
							techcount=0
							for techcount in range (gc.getNumTechInfos()):
                				        	if ((pTargetEmpireTeam.isHasTech(techcount)==true)):
                        				    		NewTeam.setHasTech(techcount,1,NewID,0,1)
							iCitiesNewPlayer = pTargetEmpire.getNumCities()/2
							iCityCount = 0
							(loopCity, iter) = pTargetEmpire.firstCity(True)
							while(loopCity):
								iCityX = loopCity.getX()
								iCityY = loopCity.getY()
								pNewPlayer.acquireCity(loopCity,False,True)
								for i in range(3):
		###init Units
									Defender = loopCity.getConscriptUnit ()
									pNewPlayer.initUnit( Defender, iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )                
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_REITERKRIEGER"), iCityX,iCityY, UnitAITypes.UNITAI_RANGED_ATTACK, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_CAVALRY_ARCHER"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_WORKER"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_HEAVY_SPEARMAN"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_KOMPOSITBOGEN"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_CATAPULT"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
								if loopCity.isCoastal(20):
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_TRIREME_PIRAT"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER_SEA, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_WORKBOAT"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER_SEA, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_BIREME"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )			
		###init Units
		###init Gebude und Kultur
### More culture!!!								loopCity.changeCulture(NewID,10,1)
								iExtraCulture = loopCity.getCulture(iDPlayerBiggestEmpire)/2
								loopCity.changeCulture(NewID,iExtraCulture,1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_GRANARY"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_STABLE"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_STEUEREINTREIBER"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_BARRACKS"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_ARCHERYRANGE"),1)
		###init Gebude und Kultur
								iCityCount = iCityCount+1
								if iCityCount == iCitiesNewPlayer:
									break
								(loopCity, iter) = pTargetEmpire.nextCity(iter, true)
						        pNewPlayer.setGold(pTargetEmpire.getGold()/2)
		###Basisbefrderungen Einheiten
							(loopUnit, iter) = pNewPlayer.firstUnit(true)
							while(loopUnit):
								loopUnit.changeExperience(3,10,false,false,false)
								if (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_SEA")):
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT1"),1)
								elif (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_IMMOBILE")):
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_GARRISON1"),1)
								else:
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_GARRISON1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_FLANKING1"),1)
								(loopUnit, iter) = (pNewPlayer.nextUnit(iter, true))
		###Basisbefrderungen Einheiten
							iOldCiv = pTargetEmpire.getCivilizationType()
							PlayerAdjectiv = gc.getCivilizationInfo(iOldCiv).getDescription()
							NewPlayerAdjectiv = PirateCiv.getDescription()
                	                		for iPlayer in range (gc.getMAX_CIV_PLAYERS()):
                        	                		pMessagePlayer = gc.getPlayer(iPlayer)
                                	               		if pMessagePlayer.isHuman():
                                        	               		popup = PyPopup.PyPopup(-1)
                                                	        	popup.setHeaderString(CyTranslator().getText("TXT_KEY_NEW_EMPIRE_CONQUEST_HEADER",(PlayerAdjectiv,NewPlayerAdjectiv)))
                                                       			popup.setBodyString(CyTranslator().getText("TXT_KEY_NEW_EMPIRE_CONQUEST_REITERHORDE_TEXT",(PlayerAdjectiv,NewPlayerAdjectiv)))
                                                       			popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)
	### Reiterhorden  End###
	### Kreuzug beginn###
                elif iTechType == gc.getInfoTypeForString("TECH_HEILIGER_KRIEG"):
			if (gc.getGame().isOption(gc.getInfoTypeForString("GAMEOPTION_SPAWN_NEW_CIVS"))):
	                        pPlayer = gc.getPlayer(iPlayer)
        	                iTeam = pPlayer.getTeam()
                	        isTeamFirst = True
				iMaxTeams = gc.getMAX_CIV_TEAMS ()
		                for i in range(iMaxTeams):
        	                        if i == iTeam:continue
                	                pCurTeam = gc.getTeam(i)
                        	        if pCurTeam.isHasTech(iTechType):
                                	        isTeamFirst = False
                                        	break
	                        if isTeamFirst:
					if gc.getMAX_CIV_PLAYERS ()>CyGame().countCivPlayersAlive ():
					        NewID = -1
					        for NumCiv in xrange (gc.getMAX_PLAYERS ()):
        					        PotPlayer = gc.getPlayer(NumCiv)
        					        if not PotPlayer.isEverAlive ():
                					        NewID = NumCiv
                        					break
					        if NewID ==-1:
						        for NumCiv in xrange (gc.getMAX_PLAYERS ()):
        						        PotPlayer = gc.getPlayer(NumCiv)
        						        if not PotPlayer.isAlive():
                						        NewID = NumCiv
                        						break
					        if NewID ==-1:
					                return
						aPirateStates = [gc.getInfoTypeForString("CIVILIZATION_CRUSADER_STATES"),gc.getInfoTypeForString("CIVILIZATION_BYZANTIUM"),gc.getInfoTypeForString("CIVILIZATION_STADTSTAAT_EDESSA"),gc.getInfoTypeForString("CIVILIZATION_STADTSTAAT_ANTIOCHIA"),gc.getInfoTypeForString("CIVILIZATION_HOLY_ROMAN")]
						dice = gc.getGame().getMapRand()
						randomNum = dice.get(len(aPirateStates) , "OracleSayMeTheLeader" )
						iCiv = aPirateStates[randomNum]
						PirateCiv = gc.getCivilizationInfo(iCiv)
# 					        for iLeaders in range(gc.getNumLeaderHeadInfos ()):
 #     						       	if PirateCiv .isLeaders(iLeaders):
  #  					              		NewLeaderID=iLeaders
   #               						break
#### Leader sollen alle die zur Civ gehren werden knnen!!####
						LeaderArray = []
 					        for iLeaders in range(gc.getNumLeaderHeadInfos ()):
      						       	if PirateCiv.isLeaders(iLeaders):
       								LeaderArray.append(iLeaders)
			      			if len(LeaderArray  ) > 0:
							iMeineZufallszahl = CyGame().getSorenRandNum(len(LeaderArray), 'IrgendeinTextAusDemDieZahlBerechnetWird')
							NewLeaderID=LeaderArray[iMeineZufallszahl]
#### Leader solleen alle werden knnen!!###
						CyGame().addPlayer(NewID,NewLeaderID,iCiv)
	   					pNewPlayer = gc.getPlayer(NewID)
     						NewTeam = gc.getTeam(pNewPlayer.getTeam())
  						NewTeamID = NewTeam.getID()
		###getbiggestEmpire
						iDPlayerBiggestEmpire = -1
						iNumBiggestEmpireCities = 0
						for iPlayer in range(gc.getMAX_PLAYERS()):
							player = gc.getPlayer(iPlayer)
							if (player.isAlive()):
								iPlayerCities = player.getNumCities()
								if iPlayerCities > iNumBiggestEmpireCities:
									if iPlayerCities > 2:
										iNumBiggestEmpireCities = iPlayerCities
										iDPlayerBiggestEmpire = iPlayer
						if (iDPlayerBiggestEmpire  > -1):
							pTargetEmpire = gc.getPlayer(iDPlayerBiggestEmpire)
							iTargetEmpireTeam = pTargetEmpire.getTeam ()
							pTargetEmpireTeam = gc.getTeam(iTargetEmpireTeam)
		###getbiggestEmpire END
							techcount=0
							for techcount in range (gc.getNumTechInfos()):
                				        	if ((pTargetEmpireTeam.isHasTech(techcount)==true)):
                        				    		NewTeam.setHasTech(techcount,1,NewID,0,1)
							iCitiesNewPlayer = pTargetEmpire.getNumCities()/2
							pLeader = gc.getLeaderHeadInfo(NewLeaderID)
							iFavoriteReligion = pLeader.getFavoriteReligion ()
	##						if (iCiv == gc.getInfoTypeForString("CIVILIZATION_PERSIA")):
	##							iFavoriteReligion  = gc.getInfoTypeForString("RELIGION_ISLAM")
							iCityCount = 0
							(loopCity, iter) = pTargetEmpire.firstCity(True)
							while(loopCity):
								iCityX = loopCity.getX()
								iCityY = loopCity.getY()
								pNewPlayer.acquireCity(loopCity,False,True)
								if ( iFavoriteReligion != -1):
									loopCity.setHasReligion(iFavoriteReligion,true,true,true )
								for i in range(4):
		###init Units
									Defender = loopCity.getConscriptUnit ()
									pNewPlayer.initUnit( Defender, iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )                
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_KNIGHT"), iCityX,iCityY, UnitAITypes.UNITAI_RANGED_ATTACK, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_CRUSADER"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_BURG"), iCityX,iCityY, UnitAITypes.UNITAI_RANGED_ATTACK, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_WORKER"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_HELLEBARDIER"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_MACEMAN"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_TREBUCHET"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
								if loopCity.isCoastal(20):
									for i in range(2):
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_TRIREME_PIRAT"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER_SEA, DirectionTypes.DIRECTION_NORTH )
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_WORKBOAT"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER_SEA, DirectionTypes.DIRECTION_NORTH )
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_GALEERE"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )			
		###init Units
		###init Gebude und Kultur
### More culture!!!								loopCity.changeCulture(NewID,10,1)
								iExtraCulture = loopCity.getCulture(iDPlayerBiggestEmpire)/2
								loopCity.changeCulture(NewID,iExtraCulture,1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_GRANARY"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_STABLE"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_MARKET"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_BARRACKS"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_ARCHERYRANGE"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_OBELISK"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_WALLS"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_LAZARETT"),1)
		###init Gebude und Kultur
								iCityCount = iCityCount+1
								if iCityCount == iCitiesNewPlayer:
									break
								(loopCity, iter) = pTargetEmpire.nextCity(iter, true)
						        pNewPlayer.setGold(pTargetEmpire.getGold()/2)
		###Basisbefrderungen Einheiten
							(loopUnit, iter) = pNewPlayer.firstUnit(true)
							while(loopUnit):
								loopUnit.changeExperience(4,10,false,false,false)
								loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_EIFER1"),1)
								if (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_SEA")):
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT1"),1)
								elif (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_IMMOBILE")):
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_GARRISON1"),1)
								else:
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_RAIDER1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT1"),1)
								(loopUnit, iter) = (pNewPlayer.nextUnit(iter, true))
		###Basisbefrderungen Einheiten
							iOldCiv = pTargetEmpire.getCivilizationType()
							PlayerAdjectiv = gc.getCivilizationInfo(iOldCiv).getDescription()
							NewPlayerAdjectiv = PirateCiv.getDescription()
                #	                		aIslamReligions = [gc.getInfoTypeForString("RELIGION_ISLAM"),gc.getInfoTypeForString("RELIGION_SHIIT")]
							for iPlayer in range (gc.getMAX_CIV_PLAYERS()):
                        	                		pMessagePlayer = gc.getPlayer(iPlayer)
                                	               		if pMessagePlayer.isHuman():
                                        	               		popup = PyPopup.PyPopup(-1)
                                                	        	popup.setHeaderString(CyTranslator().getText("TXT_KEY_NEW_EMPIRE_CONQUEST_HEADER",(PlayerAdjectiv,NewPlayerAdjectiv)))
							#		if (iFavoriteReligion in aIslamReligions ):
                                                       	#			popup.setBodyString(CyTranslator().getText("TXT_KEY_NEW_EMPIRE_CONQUEST_JIHAD_TEXT",(PlayerAdjectiv,NewPlayerAdjectiv)))
							#		else:
                                                       			popup.setBodyString(CyTranslator().getText("TXT_KEY_NEW_EMPIRE_CONQUEST_CRUSADE_TEXT",(PlayerAdjectiv,NewPlayerAdjectiv)))
									popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)
	###Kreuzzug End###
	###Jihad beginn###
                elif iTechType == gc.getInfoTypeForString("TECH_DOGMATISM"):
			if (gc.getGame().isOption(gc.getInfoTypeForString("GAMEOPTION_SPAWN_NEW_CIVS"))):
	                        pPlayer = gc.getPlayer(iPlayer)
        	                iTeam = pPlayer.getTeam()
                	        isTeamFirst = True
				iMaxTeams = gc.getMAX_CIV_TEAMS ()
		                for i in range(iMaxTeams):
        	                        if i == iTeam:continue
                	                pCurTeam = gc.getTeam(i)
                        	        if pCurTeam.isHasTech(iTechType):
                                	        isTeamFirst = False
                                        	break
	                        if isTeamFirst:
					if gc.getMAX_CIV_PLAYERS ()>CyGame().countCivPlayersAlive ():
					        NewID = -1
					        for NumCiv in xrange (gc.getMAX_PLAYERS ()):
        					        PotPlayer = gc.getPlayer(NumCiv)
        					        if not PotPlayer.isEverAlive ():
                					        NewID = NumCiv
                        					break
					        if NewID ==-1:
						        for NumCiv in xrange (gc.getMAX_PLAYERS ()):
        						        PotPlayer = gc.getPlayer(NumCiv)
        						        if not PotPlayer.isAlive():
                						        NewID = NumCiv
                        						break
					        if NewID ==-1:
					                return
						aPirateStates = [gc.getInfoTypeForString("CIVILIZATION_PERSIA"),gc.getInfoTypeForString("CIVILIZATION_OTTOMAN"),gc.getInfoTypeForString("CIVILIZATION_ARABIA"),gc.getInfoTypeForString("CIVILIZATION_STADTSTAAT_KURDISTAN")]
						dice = gc.getGame().getMapRand()
						randomNum = dice.get(len(aPirateStates) , "OracleSayMeTheLeader" )
						iCiv = aPirateStates[randomNum]
						PirateCiv = gc.getCivilizationInfo(iCiv)
# 					        for iLeaders in range(gc.getNumLeaderHeadInfos ()):
 #     						       	if PirateCiv .isLeaders(iLeaders):
  #  					              		NewLeaderID=iLeaders
   #               						break
#### Leader sollen alle die zur Civ gehren werden knnen!!####
						LeaderArray = []
 					        for iLeaders in range(gc.getNumLeaderHeadInfos ()):
      						       	if PirateCiv.isLeaders(iLeaders):
       								LeaderArray.append(iLeaders)
			      			if len(LeaderArray  ) > 0:
							iMeineZufallszahl = CyGame().getSorenRandNum(len(LeaderArray), 'IrgendeinTextAusDemDieZahlBerechnetWird')
							NewLeaderID=LeaderArray[iMeineZufallszahl]
#### Leader solleen alle werden knnen!!###
						CyGame().addPlayer(NewID,NewLeaderID,iCiv)
	   					pNewPlayer = gc.getPlayer(NewID)
     						NewTeam = gc.getTeam(pNewPlayer.getTeam())
  						NewTeamID = NewTeam.getID()
		###getbiggestEmpire
						iDPlayerBiggestEmpire = -1
						iNumBiggestEmpireCities = 0
						for iPlayer in range(gc.getMAX_PLAYERS()):
							player = gc.getPlayer(iPlayer)
							if (player.isAlive()):
								iPlayerCities = player.getNumCities()
								if iPlayerCities > iNumBiggestEmpireCities:
									if iPlayerCities > 2:
										iNumBiggestEmpireCities = iPlayerCities
										iDPlayerBiggestEmpire = iPlayer
						if (iDPlayerBiggestEmpire  > -1):
							pTargetEmpire = gc.getPlayer(iDPlayerBiggestEmpire)
							iTargetEmpireTeam = pTargetEmpire.getTeam ()
							pTargetEmpireTeam = gc.getTeam(iTargetEmpireTeam)
		###getbiggestEmpire END
							techcount=0
							for techcount in range (gc.getNumTechInfos()):
                				        	if ((pTargetEmpireTeam.isHasTech(techcount)==true)):
                        				    		NewTeam.setHasTech(techcount,1,NewID,0,1)
							iCitiesNewPlayer = pTargetEmpire.getNumCities()/2
							pLeader = gc.getLeaderHeadInfo(NewLeaderID)
							iFavoriteReligion = pLeader.getFavoriteReligion ()
							if (iCiv == gc.getInfoTypeForString("CIVILIZATION_PERSIA")):
								iFavoriteReligion  = gc.getInfoTypeForString("RELIGION_ISLAM")
							iCityCount = 0
							(loopCity, iter) = pTargetEmpire.firstCity(True)
							while(loopCity):
								iCityX = loopCity.getX()
								iCityY = loopCity.getY()
								pNewPlayer.acquireCity(loopCity,False,True)
								if ( iFavoriteReligion != -1):
									loopCity.setHasReligion(iFavoriteReligion,true,true,true )
								for i in range(4):
		###init Units
									Defender = loopCity.getConscriptUnit ()
									pNewPlayer.initUnit( Defender, iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )                
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_KNIGHT"), iCityX,iCityY, UnitAITypes.UNITAI_RANGED_ATTACK, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_CRUSADER"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_WORKER"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_KEEP"), iCityX,iCityY, UnitAITypes.UNITAI_RANGED_ATTACK, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_HELLEBARDIER"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_MACEMAN"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_TREBUCHET"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
								if loopCity.isCoastal(20):
									for i in range(2):
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_TRIREME_PIRAT"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER_SEA, DirectionTypes.DIRECTION_NORTH )
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_WORKBOAT"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER_SEA, DirectionTypes.DIRECTION_NORTH )
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_GALEERE"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )			
		###init Units
		###init Gebude und Kultur
### More culture!!!								loopCity.changeCulture(NewID,10,1)
								iExtraCulture = loopCity.getCulture(iDPlayerBiggestEmpire)/2
								loopCity.changeCulture(NewID,iExtraCulture,1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_GRANARY"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_STABLE"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_MARKET"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_BARRACKS"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_ARCHERYRANGE"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_OBELISK"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_WALLS"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_LAZARETT"),1)
		###init Gebude und Kultur
								iCityCount = iCityCount+1
								if iCityCount == iCitiesNewPlayer:
									break
								(loopCity, iter) = pTargetEmpire.nextCity(iter, true)
						        pNewPlayer.setGold(pTargetEmpire.getGold()/2)
		###Basisbefrderungen Einheiten
							(loopUnit, iter) = pNewPlayer.firstUnit(true)
							while(loopUnit):
								loopUnit.changeExperience(5,10,false,false,false)
								loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_EIFER1"),1)
								if (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_SEA")):
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT1"),1)
								elif (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_IMMOBILE")):
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_GARRISON1"),1)
								else:
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_RAIDER1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT1"),1)
								(loopUnit, iter) = (pNewPlayer.nextUnit(iter, true))
		###Basisbefrderungen Einheiten
							iOldCiv = pTargetEmpire.getCivilizationType()
							PlayerAdjectiv = gc.getCivilizationInfo(iOldCiv).getDescription()
							NewPlayerAdjectiv = PirateCiv.getDescription()
                	                		aIslamReligions = [gc.getInfoTypeForString("RELIGION_ISLAM"),gc.getInfoTypeForString("RELIGION_SHIIT")]
							for iPlayer in range (gc.getMAX_CIV_PLAYERS()):
                        	                		pMessagePlayer = gc.getPlayer(iPlayer)
                                	               		if pMessagePlayer.isHuman():
                                        	               		popup = PyPopup.PyPopup(-1)
                                                	        	popup.setHeaderString(CyTranslator().getText("TXT_KEY_NEW_EMPIRE_CONQUEST_HEADER",(PlayerAdjectiv,NewPlayerAdjectiv)))
							#		if (iFavoriteReligion in aIslamReligions ):
                                                       			popup.setBodyString(CyTranslator().getText("TXT_KEY_NEW_EMPIRE_CONQUEST_JIHAD_TEXT",(PlayerAdjectiv,NewPlayerAdjectiv)))
							#		else:
                                                       	#			popup.setBodyString(CyTranslator().getText("TXT_KEY_NEW_EMPIRE_CONQUEST_CRUSADE_TEXT",(PlayerAdjectiv,NewPlayerAdjectiv)))
									popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)
	### Jihad End###
	###Conquista beginn###
                elif iTechType == gc.getInfoTypeForString("TECH_GEOGRAPHIE"):
			if (gc.getGame().isOption(gc.getInfoTypeForString("GAMEOPTION_SPAWN_NEW_CIVS"))):
	                        pPlayer = gc.getPlayer(iPlayer)
        	                iTeam = pPlayer.getTeam()
                	        isTeamFirst = True
				iMaxTeams = gc.getMAX_CIV_TEAMS ()
		                for i in range(iMaxTeams):
        	                        if i == iTeam:continue
                	                pCurTeam = gc.getTeam(i)
                        	        if pCurTeam.isHasTech(iTechType):
                                	        isTeamFirst = False
                                        	break
	                        if isTeamFirst:
					if gc.getMAX_CIV_PLAYERS ()>CyGame().countCivPlayersAlive ():
					        NewID = -1
					        for NumCiv in xrange (gc.getMAX_PLAYERS ()):
        					        PotPlayer = gc.getPlayer(NumCiv)
        					        if not PotPlayer.isEverAlive ():
                					        NewID = NumCiv
                        					break
					        if NewID ==-1:
						        for NumCiv in xrange (gc.getMAX_PLAYERS ()):
        						        PotPlayer = gc.getPlayer(NumCiv)
        						        if not PotPlayer.isAlive():
                						        NewID = NumCiv
                        						break
					        if NewID ==-1:
					                return
						aPirateStates = [gc.getInfoTypeForString("CIVILIZATION_SPAIN"),gc.getInfoTypeForString("CIVILIZATION_FRANCE"),gc.getInfoTypeForString("CIVILIZATION_NETHERLANDS"),gc.getInfoTypeForString("CIVILIZATION_PORTUGAL"),gc.getInfoTypeForString("CIVILIZATION_SCHWEDEN"),gc.getInfoTypeForString("CIVILIZATION_ENGLAND")]
						dice = gc.getGame().getMapRand()
						randomNum = dice.get(len(aPirateStates) , "OracleSayMeTheLeader" )
						iCiv = aPirateStates[randomNum]
						PirateCiv = gc.getCivilizationInfo(iCiv)
#### Leader sollen alle die zur Civ gehren werden knnen!!####
						LeaderArray = []
 					        for iLeaders in range(gc.getNumLeaderHeadInfos ()):
      						       	if PirateCiv.isLeaders(iLeaders):
       								LeaderArray.append(iLeaders)
			      			if len(LeaderArray  ) > 0:
							iMeineZufallszahl = CyGame().getSorenRandNum(len(LeaderArray), 'IrgendeinTextAusDemDieZahlBerechnetWird')
							NewLeaderID=LeaderArray[iMeineZufallszahl]
#### Leader solleen alle werden knnen!!###
						CyGame().addPlayer(NewID,NewLeaderID,iCiv)
	   					pNewPlayer = gc.getPlayer(NewID)
     						NewTeam = gc.getTeam(pNewPlayer.getTeam())
  						NewTeamID = NewTeam.getID()
		###getbiggestEmpire
						iDPlayerBiggestEmpire = -1
						iNumBiggestEmpireCities = 0
						for iPlayer in range(gc.getMAX_PLAYERS()):
							player = gc.getPlayer(iPlayer)
							if (player.isAlive()):
								iPlayerCities = player.getNumCities()
								if iPlayerCities > iNumBiggestEmpireCities:
									if iPlayerCities > 2:
										iNumBiggestEmpireCities = iPlayerCities
										iDPlayerBiggestEmpire = iPlayer
						if (iDPlayerBiggestEmpire  > -1):
							pTargetEmpire = gc.getPlayer(iDPlayerBiggestEmpire)
							iTargetEmpireTeam = pTargetEmpire.getTeam ()
							pTargetEmpireTeam = gc.getTeam(iTargetEmpireTeam)
		###getbiggestEmpire END
							techcount=0
							for techcount in range (gc.getNumTechInfos()):
                				        	if ((pTargetEmpireTeam.isHasTech(techcount)==true)):
                        				    		NewTeam.setHasTech(techcount,1,NewID,0,1)
							iCitiesNewPlayer = pTargetEmpire.getNumCities()/2
							pLeader = gc.getLeaderHeadInfo(NewLeaderID)
							iFavoriteReligion = pLeader.getFavoriteReligion ()
							iCityCount = 0
							(loopCity, iter) = pTargetEmpire.firstCity(True)
							while(loopCity):
								iCityX = loopCity.getX()
								iCityY = loopCity.getY()
								pNewPlayer.acquireCity(loopCity,False,True)
								if ( iFavoriteReligion != -1):
									loopCity.setHasReligion(iFavoriteReligion,true,true,true )
								for i in range(5):
		###init Units
									Defender = loopCity.getConscriptUnit ()
									pNewPlayer.initUnit( Defender, iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )                
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_LANZENREITER"), iCityX,iCityY, UnitAITypes.UNITAI_RANGED_ATTACK, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_ARKEBUSIERREITER"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
								for i in range(2):
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_WORKER"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_PIKEMAN"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_32POUNDER"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_BLOCKHOUSE"), iCityX,iCityY, UnitAITypes.UNITAI_RANGED_ATTACK, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_EXPLORER"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_FIELD_ARTILLERY"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
								if loopCity.isCoastal(20):
									for i in range(3):
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_SLOOP"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER_SEA, DirectionTypes.DIRECTION_NORTH )
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_WORKBOAT"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER_SEA, DirectionTypes.DIRECTION_NORTH )
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_GALLEON"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_PRIVATEER"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_WARGALEON"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
		###init Units
		###init Gebude und Kultur
### More culture!!!								loopCity.changeCulture(NewID,10,1)
								iExtraCulture = loopCity.getCulture(iDPlayerBiggestEmpire)/2
								loopCity.changeCulture(NewID,iExtraCulture,1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_GRANARY"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_STABLE"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_MARKET"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_BARRACKS"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_TRAINING"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_LIBRARY"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_WALLS"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_LAZARETT"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_HARBOR"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_SCHOOL"),1)
		###init Gebude und Kultur
								iCityCount = iCityCount+1
								if iCityCount == iCitiesNewPlayer:
									break
								(loopCity, iter) = pTargetEmpire.nextCity(iter, true)
						        pNewPlayer.setGold(pTargetEmpire.getGold()*2)
		###Basisbefrderungen Einheiten
							(loopUnit, iter) = pNewPlayer.firstUnit(true)
							while(loopUnit):
								loopUnit.changeExperience(5,10,false,false,false)
								if (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_SEA")):
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_SEEGEFECHT1"),1)
								elif (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_IMMOBILE")):
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_GARRISON1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_DRILL1"),1)
								else:
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_PILLAGE"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_GUERILLA1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_RAIDER1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT1"),1)
								(loopUnit, iter) = (pNewPlayer.nextUnit(iter, true))
		###Basisbefrderungen Einheiten
							iOldCiv = pTargetEmpire.getCivilizationType()
							PlayerAdjectiv = gc.getCivilizationInfo(iOldCiv).getDescription()
							NewPlayerAdjectiv = PirateCiv.getDescription()
                	                		for iPlayer in range (gc.getMAX_CIV_PLAYERS()):
                        	                		pMessagePlayer = gc.getPlayer(iPlayer)
                                	               		if pMessagePlayer.isHuman():
                                        	               		popup = PyPopup.PyPopup(-1)
                                                	        	popup.setHeaderString(CyTranslator().getText("TXT_KEY_NEW_EMPIRE_CONQUEST_HEADER",(PlayerAdjectiv,NewPlayerAdjectiv)))
									popup.setBodyString(CyTranslator().getText("TXT_KEY_NEW_EMPIRE_CONQUEST_CONQUISTA_TEXT",(PlayerAdjectiv,NewPlayerAdjectiv)))
									popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)
	###Conquista End###
	###Bauernkriege beginn###
                elif iTechType == gc.getInfoTypeForString("TECH_NATURRECHT"):
			if (gc.getGame().isOption(gc.getInfoTypeForString("GAMEOPTION_SPAWN_NEW_CIVS"))):
	                        pPlayer = gc.getPlayer(iPlayer)
        	                iTeam = pPlayer.getTeam()
                	        isTeamFirst = True
				iMaxTeams = gc.getMAX_CIV_TEAMS ()
		                for i in range(iMaxTeams):
        	                        if i == iTeam:continue
                	                pCurTeam = gc.getTeam(i)
                        	        if pCurTeam.isHasTech(iTechType):
                                	        isTeamFirst = False
                                        	break
	                        if isTeamFirst:
					if gc.getMAX_CIV_PLAYERS ()>CyGame().countCivPlayersAlive ():
					        NewID = -1
					        for NumCiv in xrange (gc.getMAX_PLAYERS ()):
        					        PotPlayer = gc.getPlayer(NumCiv)
        					        if not PotPlayer.isEverAlive ():
                					        NewID = NumCiv
                        					break
					        if NewID ==-1:
						        for NumCiv in xrange (gc.getMAX_PLAYERS ()):
        						        PotPlayer = gc.getPlayer(NumCiv)
        						        if not PotPlayer.isAlive():
                						        NewID = NumCiv
                        						break
					        if NewID ==-1:
					                return
						aPirateStates = [gc.getInfoTypeForString("CIVILIZATION_POLAND"),gc.getInfoTypeForString("CIVILIZATION_BOHEMIA"),gc.getInfoTypeForString("CIVILIZATION_SUISSE"),gc.getInfoTypeForString("CIVILIZATION_SERBIA"),gc.getInfoTypeForString("CIVILIZATION_STADTSTAAT_BULGARIA"),gc.getInfoTypeForString("CIVILIZATION_STADTSTAAT_BURGUND"),gc.getInfoTypeForString("CIVILIZATION_STADTSTAAT_BAYERN")]
						dice = gc.getGame().getMapRand()
						randomNum = dice.get(len(aPirateStates) , "OracleSayMeTheLeader" )
						iCiv = aPirateStates[randomNum]
						PirateCiv = gc.getCivilizationInfo(iCiv)
#### Leader sollen alle die zur Civ gehren werden knnen!!####
						LeaderArray = []
 					        for iLeaders in range(gc.getNumLeaderHeadInfos ()):
      						       	if PirateCiv.isLeaders(iLeaders):
       								LeaderArray.append(iLeaders)
			      			if len(LeaderArray  ) > 0:
							iMeineZufallszahl = CyGame().getSorenRandNum(len(LeaderArray), 'IrgendeinTextAusDemDieZahlBerechnetWird')
							NewLeaderID=LeaderArray[iMeineZufallszahl]
#### Leader solleen alle werden knnen!!###
						CyGame().addPlayer(NewID,NewLeaderID,iCiv)
	   					pNewPlayer = gc.getPlayer(NewID)
     						NewTeam = gc.getTeam(pNewPlayer.getTeam())
  						NewTeamID = NewTeam.getID()
		###getbiggestEmpire
						iDPlayerBiggestEmpire = -1
						iNumBiggestEmpireCities = 0
						for iPlayer in range(gc.getMAX_PLAYERS()):
							player = gc.getPlayer(iPlayer)
							if (player.isAlive()):
								iPlayerCities = player.getNumCities()
								if iPlayerCities > iNumBiggestEmpireCities:
									if iPlayerCities > 2:
										iNumBiggestEmpireCities = iPlayerCities
										iDPlayerBiggestEmpire = iPlayer
						if (iDPlayerBiggestEmpire  > -1):
							pTargetEmpire = gc.getPlayer(iDPlayerBiggestEmpire)
							iTargetEmpireTeam = pTargetEmpire.getTeam ()
							pTargetEmpireTeam = gc.getTeam(iTargetEmpireTeam)
		###getbiggestEmpire END
							techcount=0
							for techcount in range (gc.getNumTechInfos()):
                				        	if ((pTargetEmpireTeam.isHasTech(techcount)==true)):
                        				    		NewTeam.setHasTech(techcount,1,NewID,0,1)
							iCitiesNewPlayer = pTargetEmpire.getNumCities()/2
							pLeader = gc.getLeaderHeadInfo(NewLeaderID)
							iFavoriteReligion = pLeader.getFavoriteReligion ()
							iCityCount = 0
							(loopCity, iter) = pTargetEmpire.firstCity(True)
							while(loopCity):
								iCityX = loopCity.getX()
								iCityY = loopCity.getY()
								pNewPlayer.acquireCity(loopCity,False,True)
								if ( iFavoriteReligion != -1):
									loopCity.setHasReligion(iFavoriteReligion,true,true,true )
								for i in range(5):
		###init Units
									Defender = loopCity.getConscriptUnit ()
									pNewPlayer.initUnit( Defender, iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )                
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_KRIEGSSENSE"), iCityX,iCityY, UnitAITypes.UNITAI_RANGED_ATTACK, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_FLAILMAN"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
								for i in range(2):
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_WORKER"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_MARAUDER"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_MUSKETMAN"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_PISTOLIER"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_EXPLORER"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_BASTION"), iCityX,iCityY, UnitAITypes.UNITAI_RANGED_ATTACK, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_CULVERINE"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_DRAGOON"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_WARWAGON"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
								if loopCity.isCoastal(20):
									for i in range(3):
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_BARQUE"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER_SEA, DirectionTypes.DIRECTION_NORTH )
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_WORKBOAT"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER_SEA, DirectionTypes.DIRECTION_NORTH )
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_MERCHANTMAN"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_FLUSSSCHIFF"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_PRIVATEER"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
		###init Units
		###init Gebude und Kultur
### More culture!!!								loopCity.changeCulture(NewID,10,1)
								iExtraCulture = loopCity.getCulture(iDPlayerBiggestEmpire)/2
								loopCity.changeCulture(NewID,iExtraCulture,1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_GRANARY"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_STABLE"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_MARKET"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_BARRACKS"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_TRAINING"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_LIBRARY"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_WALLS"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_LAZARETT"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_HARBOR"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_SCHOOL"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_BEWAESSERUNG"),1)
		###init Gebude und Kultur
								iCityCount = iCityCount+1
								if iCityCount == iCitiesNewPlayer:
									break
								(loopCity, iter) = pTargetEmpire.nextCity(iter, true)
						        pNewPlayer.setGold(pTargetEmpire.getGold()*2)
		###Basisbefrderungen Einheiten
							(loopUnit, iter) = pNewPlayer.firstUnit(true)
							while(loopUnit):
								loopUnit.changeExperience(5,10,false,false,false)
								if (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_SEA")):
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_SEEGEFECHT1"),1)
								elif (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_IMMOBILE")):
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_GARRISON1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_DRILL1"),1)
								else:
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_PILLAGE"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_GUERILLA1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_RAIDER1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT1"),1)
								(loopUnit, iter) = (pNewPlayer.nextUnit(iter, true))
		###Basisbefrderungen Einheiten
							iOldCiv = pTargetEmpire.getCivilizationType()
							PlayerAdjectiv = gc.getCivilizationInfo(iOldCiv).getDescription()
							NewPlayerAdjectiv = PirateCiv.getDescription()
                	                		for iPlayer in range (gc.getMAX_CIV_PLAYERS()):
                        	                		pMessagePlayer = gc.getPlayer(iPlayer)
                                	               		if pMessagePlayer.isHuman():
                                        	               		popup = PyPopup.PyPopup(-1)
                                                	        	popup.setHeaderString(CyTranslator().getText("TXT_KEY_INDEPENDENCE_HEADER",(PlayerAdjectiv,NewPlayerAdjectiv)))
									popup.setBodyString(CyTranslator().getText("TXT_KEY_INDEPENDENCE_BAUERN_TEXT",(PlayerAdjectiv,NewPlayerAdjectiv)))
									popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)
	###Bauernkriege End###
	###Erste Unabhngigkeitswelle beginn###
                elif iTechType == gc.getInfoTypeForString("TECH_DEMOCRACY"):
			if (gc.getGame().isOption(gc.getInfoTypeForString("GAMEOPTION_SPAWN_NEW_CIVS"))):
	                        pPlayer = gc.getPlayer(iPlayer)
        	                iTeam = pPlayer.getTeam()
                	        isTeamFirst = True
				iMaxTeams = gc.getMAX_CIV_TEAMS ()
		                for i in range(iMaxTeams):
        	                        if i == iTeam:continue
                	                pCurTeam = gc.getTeam(i)
                        	        if pCurTeam.isHasTech(iTechType):
                                	        isTeamFirst = False
                                        	break
	                        if isTeamFirst:
					if gc.getMAX_CIV_PLAYERS ()>CyGame().countCivPlayersAlive ():
					        NewID = -1
					        for NumCiv in xrange (gc.getMAX_PLAYERS ()):
        					        PotPlayer = gc.getPlayer(NumCiv)
        					        if not PotPlayer.isEverAlive ():
                					        NewID = NumCiv
                        					break
					        if NewID ==-1:
						        for NumCiv in xrange (gc.getMAX_PLAYERS ()):
        						        PotPlayer = gc.getPlayer(NumCiv)
        						        if not PotPlayer.isAlive():
                						        NewID = NumCiv
                        						break
					        if NewID ==-1:
					                return
		###getbiggestEmpire
						iDPlayerBiggestEmpire = -1
						iNumBiggestEmpireCities = 0
						for iPlayer in range(gc.getMAX_PLAYERS()):
							player = gc.getPlayer(iPlayer)
							if (player.isAlive()):
								iPlayerCities = player.getNumCities()
								if iPlayerCities > iNumBiggestEmpireCities:
									if iPlayerCities > 2:
										iNumBiggestEmpireCities = iPlayerCities
										iDPlayerBiggestEmpire = iPlayer
						if (iDPlayerBiggestEmpire  > -1):
							pTargetEmpire = gc.getPlayer(iDPlayerBiggestEmpire)
							iTargetEmpireTeam = pTargetEmpire.getTeam ()
							pTargetEmpireTeam = gc.getTeam(iTargetEmpireTeam)
		###getbiggestEmpire END	
							aPirateStates = [gc.getInfoTypeForString("CIVILIZATION_CONFEDERATE"),gc.getInfoTypeForString("CIVILIZATION_AMERICA"),gc.getInfoTypeForString("CIVILIZATION_BRAZIL"),gc.getInfoTypeForString("CIVILIZATION_ARGENTINA"),gc.getInfoTypeForString("CIVILIZATION_KOLUMBIEN"),gc.getInfoTypeForString("CIVILIZATION_MEXICO")]
							iOldCiv = pTargetEmpire.getCivilizationType()
							iDerivativeCiv = PlayerAdjectiv = gc.getCivilizationInfo(iOldCiv).getDerivativeCiv()
							if ( iDerivativeCiv in aPirateStates ):
								iCiv = iDerivativeCiv
							else:
								dice = gc.getGame().getMapRand()
								randomNum = dice.get(len(aPirateStates) , "OracleSayMeTheLeader" )
								iCiv = aPirateStates[randomNum]
							PirateCiv = gc.getCivilizationInfo(iCiv)
 						        #for iLeaders in range(gc.getNumLeaderHeadInfos ()):
      							 #      	if PirateCiv .isLeaders(iLeaders):
    						          #    		NewLeaderID=iLeaders
                  					#		break
#### Leader sollen alle die zur Civ gehren werden knnen!!####
							LeaderArray = []
 						        for iLeaders in range(gc.getNumLeaderHeadInfos ()):
      							       	if PirateCiv.isLeaders(iLeaders):
       									LeaderArray.append(iLeaders)
			      				if len(LeaderArray  ) > 0:
								iMeineZufallszahl = CyGame().getSorenRandNum(len(LeaderArray), 'IrgendeinTextAusDemDieZahlBerechnetWird')
								NewLeaderID=LeaderArray[iMeineZufallszahl] 
#### Leader solleen alle werden knnen!!###
							CyGame().addPlayer(NewID,NewLeaderID,iCiv)
		   					pNewPlayer = gc.getPlayer(NewID)
     							NewTeam = gc.getTeam(pNewPlayer.getTeam())
  							NewTeamID = NewTeam.getID()
							techcount=0
							for techcount in range (gc.getNumTechInfos()):
                				        	if ((pTargetEmpireTeam.isHasTech(techcount)==true)):
                        				    		NewTeam.setHasTech(techcount,1,NewID,0,1)
							iCitiesNewPlayer = pTargetEmpire.getNumCities()/3
							pLeader = gc.getLeaderHeadInfo(NewLeaderID)
							iCityCount = 0
							(loopCity, iter) = pTargetEmpire.firstCity(True)
							while(loopCity):
								iCityX = loopCity.getX()
								iCityY = loopCity.getY()
								pNewPlayer.acquireCity(loopCity,False,True)
								for i in range(6):
		###init Units
									Defender = loopCity.getConscriptUnit ()
									pNewPlayer.initUnit( Defender, iCityX,iCityY, UnitAITypes.UNITAI_CITY_DEFENSE, DirectionTypes.DIRECTION_NORTH )                
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_CUIRASSIER"), iCityX,iCityY, UnitAITypes.UNITAI_ATTACK, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_DRAGOON"), iCityX,iCityY, UnitAITypes.UNITAI_ATTACK, DirectionTypes.DIRECTION_NORTH )
								for i in range(3):
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_WORKER"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_MILITIA"), iCityX,iCityY, UnitAITypes.UNITAI_CITY_DEFENSE, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_CANNON"), iCityX,iCityY, UnitAITypes.UNITAI_RANGED_ATTACK, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_AUFKLAERER"), iCityX,iCityY, UnitAITypes.UNITAI_CITY_DEFENSE, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_COASTALFORTRESS"), iCityX,iCityY, UnitAITypes.UNITAI_RANGED_ATTACK, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_FIELD_ARTILLERY"), iCityX,iCityY, UnitAITypes.UNITAI_RANGED_ATTACK, DirectionTypes.DIRECTION_NORTH )
								if loopCity.isCoastal(20):
									for i in range(3):
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_FRIGATE"), iCityX,iCityY, UnitAITypes.UNITAI_ATTACK_SEA, DirectionTypes.DIRECTION_NORTH )
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_WORKBOAT"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER_SEA, DirectionTypes.DIRECTION_NORTH )
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_BRIGG"), iCityX,iCityY, UnitAITypes.UNITAI_ASSAULT_SEA, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_KORVETTE"), iCityX,iCityY, UnitAITypes.UNITAI_ATTACK_SEA, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_SHIP_OF_THE_LINE"), iCityX,iCityY, UnitAITypes.UNITAI_ATTACK_SEA, DirectionTypes.DIRECTION_NORTH )
		###init Units
		###init Gebude und Kultur
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_BEWAESSERUNG"),1)
								loopCity.changeCulture(NewID,loopCity.getCulture(iDPlayerBiggestEmpire),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_GRANARY"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_STABLE"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_MARKET"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_BARRACKS"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_TRAINING"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_LIBRARY"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_WALLS"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_LAZARETT"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_HARBOR"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_SCHOOL"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_JAIL"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_TOWN_CENTER"),1)
		###init Gebude und Kultur
								iCityCount = iCityCount+1
								if iCityCount == iCitiesNewPlayer:
									break
								(loopCity, iter) = pTargetEmpire.nextCity(iter, true)
						        pNewPlayer.setGold(pTargetEmpire.getGold())
		###Basisbefrderungen Einheiten
							(loopUnit, iter) = pNewPlayer.firstUnit(true)
							while(loopUnit):
								loopUnit.changeExperience(6,10,false,false,false)
								if (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_SEA")):
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COASTGUARD1"),1)
								elif (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_IMMOBILE")):
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_GARRISON1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_DRILL1"),1)
								else:
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_WOODSMAN1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_GUERILLA1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_GARRISON1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT1"),1)
								(loopUnit, iter) = (pNewPlayer.nextUnit(iter, true))
		###Basisbefrderungen Einheiten
							PlayerAdjectiv = gc.getCivilizationInfo(iOldCiv).getDescription()
							NewPlayerAdjectiv = PirateCiv.getDescription()
                	                		for iPlayer in range (gc.getMAX_CIV_PLAYERS()):
                        	                		pMessagePlayer = gc.getPlayer(iPlayer)
                                	               		if pMessagePlayer.isHuman():
                                        	               		popup = PyPopup.PyPopup(-1)
                                                	        	popup.setHeaderString(CyTranslator().getText("TXT_KEY_INDEPENDENCE_HEADER",(PlayerAdjectiv,NewPlayerAdjectiv)))
									popup.setBodyString(CyTranslator().getText("TXT_KEY_INDEPENDENCE_DAY_TEXT",(PlayerAdjectiv,NewPlayerAdjectiv)))
									popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)
	###Erste Unabhngigkeitswelle End###
	###Restauration beginn###
                elif iTechType == gc.getInfoTypeForString("TECH_REACTION"):
			if (gc.getGame().isOption(gc.getInfoTypeForString("GAMEOPTION_SPAWN_NEW_CIVS"))):
	                        pPlayer = gc.getPlayer(iPlayer)
                	        isTeamFirst = True
        	                iTeam = pPlayer.getTeam()
				iMaxTeams = gc.getMAX_CIV_TEAMS ()
		                for i in range(iMaxTeams):
        	                        if i == iTeam:continue
                	                pCurTeam = gc.getTeam(i)
                        	        if pCurTeam.isHasTech(iTechType):
                                	        isTeamFirst = False
                                        	break
	                        if isTeamFirst:
					DeadCivArray = []
					iReturnPlayerID =-1
					for iPlayer in range(gc.getMAX_PLAYERS()):
						pDeadPlayer = gc.getPlayer(iPlayer)
						if (pDeadPlayer.isEverAlive() ):
							if (not pDeadPlayer.isAlive() ):
								DeadCivArray.append(iPlayer)
		      			if len(DeadCivArray ) > 0:
						iMeineZufallszahl = CyGame().getSorenRandNum(len(DeadCivArray), 'IllBeBack')
						iReturnPlayerID=DeadCivArray[iMeineZufallszahl]
					if (iReturnPlayerID != -1):
						pReturnEmpire = gc.getPlayer(iReturnPlayerID )
						iReturnTeam = pReturnEmpire.getTeam ()
						pReturnTeam = gc.getTeam(iReturnTeam)
						for iPlayer2 in range(gc.getMAX_PLAYERS()):
							pPlayer2 = gc.getPlayer(iPlayer2)
							if(pPlayer2.getTeam() != iReturnTeam ):
								if (not gc.getTeam(pPlayer2.getTeam()).isBarbarian() ):
									gc.getTeam(pPlayer2.getTeam()).makePeace(iReturnTeam)
								(loopCity, iter) = pPlayer2.firstCity(True)
								while(loopCity):
									if not (loopCity.isCapital()):
										if (loopCity.getOriginalOwner() == iReturnPlayerID):
											iCityX = loopCity.getX()
											iCityY = loopCity.getY()
											pReturnEmpire.acquireCity(loopCity,False,True)
	###init Units
											for i in range(6):
												Defender = loopCity.getConscriptUnit ()
												pReturnEmpire.initUnit( Defender, iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
												pReturnEmpire.initUnit( gc.getInfoTypeForString("UNIT_KARABINIERS"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
											for i in range(3):
												pReturnEmpire.initUnit( gc.getInfoTypeForString("UNIT_FIELD_CANNON"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
												pReturnEmpire.initUnit( gc.getInfoTypeForString("UNIT_WORKER"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
												pReturnEmpire.initUnit( gc.getInfoTypeForString("UNIT_BASTION"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
												pReturnEmpire.initUnit( gc.getInfoTypeForString("UNIT_CANNON"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
											pReturnEmpire.initUnit( gc.getInfoTypeForString("UNIT_GARDEINFANTERY"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
											pReturnEmpire.initUnit( gc.getInfoTypeForString("UNIT_COASTALFORTRESS"), iCityX,iCityY, UnitAITypes.UNITAI_RANGED_ATTACK, DirectionTypes.DIRECTION_NORTH )
											pReturnEmpire.initUnit( gc.getInfoTypeForString("UNIT_AUFKLAERER"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
											pReturnEmpire.initUnit( gc.getInfoTypeForString("UNIT_BALLON"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
											pReturnEmpire.initUnit( gc.getInfoTypeForString("UNIT_STAR_FORT"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
											if loopCity.isCoastal(20):
												for i in range(3):
													pReturnEmpire.initUnit( gc.getInfoTypeForString("UNIT_MISSILE_SHIP"), iCityX,iCityY, UnitAITypes.UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
													pReturnEmpire.initUnit( gc.getInfoTypeForString("UNIT_WORKBOAT"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER_SEA, DirectionTypes.DIRECTION_NORTH )
													pReturnEmpire.initUnit( gc.getInfoTypeForString("UNIT_GALIOT_A_BOMBE"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
												pReturnEmpire.initUnit( gc.getInfoTypeForString("UNIT_BRIGG"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
												pReturnEmpire.initUnit( gc.getInfoTypeForString("UNIT_DREIDECKER"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
				###init Units
			###init Gebude und Kultur
											iExtraCulture = loopCity.getCulture(iPlayer2 )/2
											loopCity.changeCulture(iReturnPlayerID,iExtraCulture,1)
											loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_BEWAESSERUNG"),1)
											loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_GRANARY"),1)
											loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_STABLE"),1)
											loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_MARKET"),1)
											loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_BARRACKS"),1)
											loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_TRAINING"),1)
											loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_LIBRARY"),1)
											loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_WAFFENKAMMER"),1)
											loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_LAZARETT"),1)
											loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_HARBOR"),1)
											loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_SCHOOL"),1)
											loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_JAIL"),1)
											loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_TOWN_CENTER"),1)
											loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_FORGE"),1)
		###init Gebude und Kultur
									(loopCity, iter) = pPlayer2.nextCity(iter, true)
			###Basisbefrderungen Einheiten
						(loopUnit, iter) = pReturnEmpire.firstUnit(true)
						while(loopUnit):
							loopUnit.changeExperience(7,12,false,false,false)
							if (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_SEA")):
								loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_BREITSEITE1"),1)
								loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT1"),1)
								loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COASTGUARD1"),1)
							elif (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_IMMOBILE")):
								loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_GARRISON1"),1)
								loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_DRILL1"),1)
						#	elif (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_AIR")):
						#		loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT1"),1)
							else:
								loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_RAIDER1"),1)
								loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_PINCH1"),1)
								loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_REITERFALLE1"),1)
								loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_GARRISON1"),1)
								loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT1"),1)
							(loopUnit, iter) = (pReturnEmpire.nextUnit(iter, true))
		###Basisbefrderungen Einheiten
						iOldCiv = pReturnEmpire.getCivilizationType()
						PlayerAdjectiv = gc.getCivilizationInfo(iOldCiv).getDescription()
						for iPlayer in range(gc.getMAX_PLAYERS()):
							if gc.getPlayer(iPlayer).isHuman():
					               		popup = PyPopup.PyPopup(-1)
			 	    		        	popup.setHeaderString(CyTranslator().getText("TXT_KEY_HEADER_RESTAURATION",(-1,-1)))
 			       					popup.setBodyString(CyTranslator().getText("TXT_KEY_MESSAGE_RESTAURATION",(PlayerAdjectiv,PlayerAdjectiv)))
  	        		     				popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)
##	###Restauration end###
	###Imperialismus beginn###
                elif iTechType == gc.getInfoTypeForString("TECH_IMPERIALISM"):
			if (gc.getGame().isOption(gc.getInfoTypeForString("GAMEOPTION_SPAWN_NEW_CIVS"))):
	                        pPlayer = gc.getPlayer(iPlayer)
        	                iTeam = pPlayer.getTeam()
                	        isTeamFirst = True
				iMaxTeams = gc.getMAX_CIV_TEAMS ()
		                for i in range(iMaxTeams):
        	                        if i == iTeam:continue
                	                pCurTeam = gc.getTeam(i)
                        	        if pCurTeam.isHasTech(iTechType):
                                	        isTeamFirst = False
                                        	break
	                        if isTeamFirst:
					if gc.getMAX_CIV_PLAYERS ()>CyGame().countCivPlayersAlive ():
					        NewID = -1
					        for NumCiv in xrange (gc.getMAX_PLAYERS ()):
        					        PotPlayer = gc.getPlayer(NumCiv)
        					        if not PotPlayer.isEverAlive ():
                					        NewID = NumCiv
                        					break
					        if NewID ==-1:
						        for NumCiv in xrange (gc.getMAX_PLAYERS ()):
        						        PotPlayer = gc.getPlayer(NumCiv)
        						        if not PotPlayer.isAlive():
                						        NewID = NumCiv
                        						break
					        if NewID ==-1:
					                return
						aPirateStates = [gc.getInfoTypeForString("CIVILIZATION_BELGIUM"),gc.getInfoTypeForString("CIVILIZATION_ITALY"),gc.getInfoTypeForString("CIVILIZATION_AUSTRIA"),gc.getInfoTypeForString("CIVILIZATION_PRUSSIA"),gc.getInfoTypeForString("CIVILIZATION_RUSSIA"),gc.getInfoTypeForString("CIVILIZATION_JAPAN")]
						dice = gc.getGame().getMapRand()
						randomNum = dice.get(len(aPirateStates) , "OracleSayMeTheLeader" )
						iCiv = aPirateStates[randomNum]
						PirateCiv = gc.getCivilizationInfo(iCiv)
#### Leader sollen alle die zur Civ gehren werden knnen!!####
						LeaderArray = []
 					        for iLeaders in range(gc.getNumLeaderHeadInfos ()):
      						       	if PirateCiv.isLeaders(iLeaders):
       								LeaderArray.append(iLeaders)
			      			if len(LeaderArray  ) > 0:
							iMeineZufallszahl = CyGame().getSorenRandNum(len(LeaderArray), 'IrgendeinTextAusDemDieZahlBerechnetWird')
							NewLeaderID=LeaderArray[iMeineZufallszahl] 
#### Leader solleen alle werden knnen!!###
						CyGame().addPlayer(NewID,NewLeaderID,iCiv)
	   					pNewPlayer = gc.getPlayer(NewID)
     						NewTeam = gc.getTeam(pNewPlayer.getTeam())
  						NewTeamID = NewTeam.getID()
		###getbiggestEmpire
						iDPlayerBiggestEmpire = -1
						iNumBiggestEmpireCities = 0
						for iPlayer in range(gc.getMAX_PLAYERS()):
							player = gc.getPlayer(iPlayer)
							if (player.isAlive()):
								iPlayerCities = player.getNumCities()
								if iPlayerCities > iNumBiggestEmpireCities:
									if iPlayerCities > 2:
										iNumBiggestEmpireCities = iPlayerCities
										iDPlayerBiggestEmpire = iPlayer
						if (iDPlayerBiggestEmpire  > -1):
							pTargetEmpire = gc.getPlayer(iDPlayerBiggestEmpire)
							iTargetEmpireTeam = pTargetEmpire.getTeam ()
							pTargetEmpireTeam = gc.getTeam(iTargetEmpireTeam)
		###getbiggestEmpire END
							techcount=0
							for techcount in range (gc.getNumTechInfos()):
                				        	if ((pTargetEmpireTeam.isHasTech(techcount)==true)):
                        				    		NewTeam.setHasTech(techcount,1,NewID,0,1)
							iCitiesNewPlayer = pTargetEmpire.getNumCities()/3
							pLeader = gc.getLeaderHeadInfo(NewLeaderID)
							iFavoriteReligion = pLeader.getFavoriteReligion ()
							iCityCount = 0
							(loopCity, iter) = pTargetEmpire.firstCity(True)
							while(loopCity):
								iCityX = loopCity.getX()
								iCityY = loopCity.getY()
								pNewPlayer.acquireCity(loopCity,False,True)
								if ( iFavoriteReligion != -1):
									loopCity.setHasReligion(iFavoriteReligion,true,true,true )
								for i in range(6):
		###init Units
									Defender = loopCity.getConscriptUnit ()
									pNewPlayer.initUnit( Defender, iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )                
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_CAVALRY"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_LIGHT_ARTILLERY"), iCityX,iCityY, UnitAITypes.UNITAI_RANGED_ATTACK, DirectionTypes.DIRECTION_NORTH )
								for i in range(3):
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_WORKER"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_GATLING"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_ARTILLERY"), iCityX,iCityY, UnitAITypes.UNITAI_RANGED_ATTACK, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_GARDEINFANTERY"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_COLUMBIAD"), iCityX,iCityY, UnitAITypes.UNITAI_RANGED_ATTACK, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_ARTILLERIE_BEOBACHTER"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_AIRSHIP"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_PANZERKUPPEL"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
								if loopCity.isCoastal(20):
									for i in range(3):
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_IRONCLAD"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_WORKBOAT"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER_SEA, DirectionTypes.DIRECTION_NORTH )
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_KANONENBOOT"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_STEAMER"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_HEAVY_ARMORED_SHIP"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
		###init Units
		###init Gebude und Kultur
### More culture!!!								loopCity.changeCulture(NewID,10,1)
								iExtraCulture = loopCity.getCulture(iDPlayerBiggestEmpire)/2
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_BEWAESSERUNG"),1)
								loopCity.changeCulture(NewID,iExtraCulture,1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_GRANARY"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_STABLE"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_MARKET"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_BARRACKS"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_TRAINING"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_LIBRARY"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_WAFFENKAMMER"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_LAZARETT"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_HARBOR"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_SCHOOL"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_JAIL"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_TOWN_CENTER"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_FORGE"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_POLICE"),1)
		###init Gebude und Kultur
								iCityCount = iCityCount+1
								if iCityCount == iCitiesNewPlayer:
									break
								(loopCity, iter) = pTargetEmpire.nextCity(iter, true)
						        pNewPlayer.setGold(pTargetEmpire.getGold())
		###Basisbefrderungen Einheiten
							(loopUnit, iter) = pNewPlayer.firstUnit(true)
							while(loopUnit):
								loopUnit.changeExperience(7,12,false,false,false)
								if (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_SEA")):
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_MANEUVER1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COASTGUARD1"),1)
								elif (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_IMMOBILE")):
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_GARRISON1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_DRILL1"),1)
								elif (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_AIR")):
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT1"),1)
								else:
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_RAIDER1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_PINCH1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_REITERFALLE1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_GARRISON1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT1"),1)
								(loopUnit, iter) = (pNewPlayer.nextUnit(iter, true))
		###Basisbefrderungen Einheiten
							iOldCiv = pTargetEmpire.getCivilizationType()
							PlayerAdjectiv = gc.getCivilizationInfo(iOldCiv).getDescription()
							NewPlayerAdjectiv = PirateCiv.getDescription()
                	                		for iPlayer in range (gc.getMAX_CIV_PLAYERS()):
                        	                		pMessagePlayer = gc.getPlayer(iPlayer)
                                	               		if pMessagePlayer.isHuman():
                                        	               		popup = PyPopup.PyPopup(-1)
                                                	        	popup.setHeaderString(CyTranslator().getText("TXT_KEY_NEW_EMPIRE_CONQUEST_HEADER",(PlayerAdjectiv,NewPlayerAdjectiv)))
									popup.setBodyString(CyTranslator().getText("TXT_KEY_NEW_EMPIRE_CONQUEST_IMPERIALISM_TEXT",(PlayerAdjectiv,NewPlayerAdjectiv)))
									popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)
	###Imperialismus End###
	###Extremismus beginn###
                elif iTechType == gc.getInfoTypeForString("TECH_MILITARISM"):
			if (gc.getGame().isOption(gc.getInfoTypeForString("GAMEOPTION_SPAWN_NEW_CIVS"))):
	                        pPlayer = gc.getPlayer(iPlayer)
        	                iTeam = pPlayer.getTeam()
                	        isTeamFirst = True
				iMaxTeams = gc.getMAX_CIV_TEAMS ()
		                for i in range(iMaxTeams):
        	                        if i == iTeam:continue
                	                pCurTeam = gc.getTeam(i)
                        	        if pCurTeam.isHasTech(iTechType):
                                	        isTeamFirst = False
                                        	break
	                        if isTeamFirst:
					if gc.getMAX_CIV_PLAYERS ()>CyGame().countCivPlayersAlive ():
					        NewID = -1
					        for NumCiv in xrange (gc.getMAX_PLAYERS ()):
        					        PotPlayer = gc.getPlayer(NumCiv)
        					        if not PotPlayer.isEverAlive ():
                					        NewID = NumCiv
                        					break
					        if NewID ==-1:
						        for NumCiv in xrange (gc.getMAX_PLAYERS ()):
        						        PotPlayer = gc.getPlayer(NumCiv)
        						        if not PotPlayer.isAlive():
                						        NewID = NumCiv
                        						break
					        if NewID ==-1:
					                return
						aExtremeLeaders = [gc.getInfoTypeForString("LEADER_CHINESE_LEADER"),gc.getInfoTypeForString("LEADER_MUSOLINI"),gc.getInfoTypeForString("LEADER_FRANCO"),gc.getInfoTypeForString("LEADER_HINDENBURG"),gc.getInfoTypeForString("LEADER_STALIN")]
						dice = gc.getGame().getMapRand()
						randomNum = dice.get(len(aExtremeLeaders ) , "OracleSayMeTheLeader" )
						NewLeaderID = aExtremeLeaders[randomNum]
 					        for i in range(gc.getNumCivilizationInfos()):
      						       	if gc.getCivilizationInfo(i).isLeaders(NewLeaderID ):
    					              		iCiv = i
                  						break
						PirateCiv = gc.getCivilizationInfo(iCiv)
						CyGame().addPlayer(NewID,NewLeaderID,iCiv)
	   					pNewPlayer = gc.getPlayer(NewID)
     						NewTeam = gc.getTeam(pNewPlayer.getTeam())
  						NewTeamID = NewTeam.getID()
		###getbiggestEmpire
						iDPlayerBiggestEmpire = -1
						iNumBiggestEmpireCities = 0
						for iPlayer in range(gc.getMAX_PLAYERS()):
							player = gc.getPlayer(iPlayer)
							if (player.isAlive()):
								iPlayerCities = player.getNumCities()
								if iPlayerCities > iNumBiggestEmpireCities:
									if iPlayerCities > 2:
										iNumBiggestEmpireCities = iPlayerCities
										iDPlayerBiggestEmpire = iPlayer
						if (iDPlayerBiggestEmpire  > -1):
							pTargetEmpire = gc.getPlayer(iDPlayerBiggestEmpire)
							iTargetEmpireTeam = pTargetEmpire.getTeam ()
							pTargetEmpireTeam = gc.getTeam(iTargetEmpireTeam)
		###getbiggestEmpire END
							techcount=0
							for techcount in range (gc.getNumTechInfos()):
                				        	if ((pTargetEmpireTeam.isHasTech(techcount)==true)):
                        				    		NewTeam.setHasTech(techcount,1,NewID,0,1)
							iCitiesNewPlayer = pTargetEmpire.getNumCities()/3
							pLeader = gc.getLeaderHeadInfo(NewLeaderID)
							iCityCount = 0
							(loopCity, iter) = pTargetEmpire.firstCity(True)
							while(loopCity):
								iCityX = loopCity.getX()
								iCityY = loopCity.getY()
								pNewPlayer.acquireCity(loopCity,False,True)
								for i in range(7):
		###init Units
									Defender = loopCity.getConscriptUnit ()
									pNewPlayer.initUnit( Defender, iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )                
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_ARMORED_CAR"), iCityX,iCityY, UnitAITypes.UNITAI_RANGED_ATTACK, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_PAK"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
								for i in range(3):
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_DOPPELDECKER"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_WORKER"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_MACHINE_GUN"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_ARTILLERY"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
								for i in range(2):
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNITCLASS_MINENWERFER"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_LAND_IRONCLAD"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_MOTORBIKE"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_LIGHT_AA"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_MOTORBIKE_SCOUT"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
							#	pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_MEDIC"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_AIRSHIP"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_FESTUNG"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
								if loopCity.isCoastal(20):
									for i in range(3):
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_DESTROYER"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER_SEA, DirectionTypes.DIRECTION_NORTH )
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_WORKBOAT"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER_SEA, DirectionTypes.DIRECTION_NORTH )
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_TORPEDOBOOT"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_STEAMER"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_PANZERKREUZER"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_EINHEITSLINIENSCHIFF"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
		###init Units
		###init Gebude und Kultur
								loopCity.changeCulture(NewID,loopCity.getCulture(iDPlayerBiggestEmpire),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_GRANARY"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_SIEGEWORKSHOP"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_MARKET"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_BEWAESSERUNG"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_BARRACKS"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_TRAINING"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_LIBRARY"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_WAFFENKAMMER"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_LAZARETT"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_HARBOR"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_SCHOOL"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_JAIL"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_TOWN_CENTER"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_FORGE"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_POLICE"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_GYMNASIUM"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_COLOSSEUM"),1)
		###init Gebude und Kultur
								iCityCount = iCityCount+1
								if iCityCount == iCitiesNewPlayer:
									break
								(loopCity, iter) = pTargetEmpire.nextCity(iter, true)
						        pNewPlayer.setGold(pTargetEmpire.getGold())
		###Basisbefrderungen Einheiten
							(loopUnit, iter) = pNewPlayer.firstUnit(true)
							while(loopUnit):
								loopUnit.changeExperience(8,15,false,false,false)
								if (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_SEA")):
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_MANEUVER1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_PATROL1"),1)
								elif (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_IMMOBILE")):
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_GARRISON1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_DRILL1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT1"),1)
								elif (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_AIR")):
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT1"),1)
								else:
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_RAIDER1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_SECURITY"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_REITERFALLE1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_GARRISON1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_DISCIPLINE1"),1)
								(loopUnit, iter) = (pNewPlayer.nextUnit(iter, true))
		###Basisbefrderungen Einheiten
							iOldCiv = pTargetEmpire.getCivilizationType()
							PlayerAdjectiv = gc.getCivilizationInfo(iOldCiv).getDescription()
							NewPlayerAdjectiv = PirateCiv.getDescription()
                	                		for iPlayer in range (gc.getMAX_CIV_PLAYERS()):
                        	                		pMessagePlayer = gc.getPlayer(iPlayer)
                                	               		if pMessagePlayer.isHuman():
                                        	               		popup = PyPopup.PyPopup(-1)
                                                	        	popup.setHeaderString(CyTranslator().getText("TXT_KEY_INDEPENDENCE_HEADER",(PlayerAdjectiv,NewPlayerAdjectiv)))
									popup.setBodyString(CyTranslator().getText("TXT_KEY_INDEPENDENCE_EXTREMIST_TEXT",(PlayerAdjectiv,NewPlayerAdjectiv)))
									popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)
	###Extremismus End###
	###Appeasement beginn###
                elif iTechType == gc.getInfoTypeForString("TECH_FASCISM"):
			if (gc.getGame().isOption(gc.getInfoTypeForString("GAMEOPTION_SPAWN_NEW_CIVS"))):
	                        pPlayer = gc.getPlayer(iPlayer)
                	        isTeamFirst = True
        	                iTeam = pPlayer.getTeam()
				iMaxTeams = gc.getMAX_CIV_TEAMS ()
		                for i in range(iMaxTeams):
        	                        if i == iTeam:continue
                	                pCurTeam = gc.getTeam(i)
                        	        if pCurTeam.isHasTech(iTechType):
                                	        isTeamFirst = False
                                        	break
	                        if isTeamFirst:
					iDPlayerSmallestEmpire = -1
					iNumSmallestEmpireCities = 255
					for iPlayer in range(gc.getMAX_PLAYERS()):
						player = gc.getPlayer(iPlayer)
						if (player.isAlive()):
							iCurCiv = gc.getPlayer(iPlayer).getCivilizationType()
							if not (gc.getCivilizationInfo(iCurCiv).isCitystate()):
								iPlayerCities = player.getNumCities()
								if iPlayerCities < iNumSmallestEmpireCities:
									iNumSmallestEmpireCities = iPlayerCities
									iDPlayerSmallestEmpire = iPlayer
					pTargetEmpire = gc.getPlayer(iDPlayerSmallestEmpire )
					iTargetEmpireTeam = pTargetEmpire.getTeam ()
					pTargetEmpireTeam = gc.getTeam(iTargetEmpireTeam)
			#### Relikt von Vlkerwanderung - fr Appeasement unerheblich
			#	iNumContacts = 0
			#	ContactCivArray = []
			#	for iPlayer in range(gc.getMAX_PLAYERS()):
			#		pPlayer2 = gc.getPlayer(iPlayer)
			#		if(pPlayer2.getTeam() != iTargetEmpireTeam):
			#			iTeam2 = pPlayer2.getTeam ()
			#			if pTargetEmpireTeam.canContact(iTeam2):
			#				iNumContacts = iNumContacts+1
			#	if iNumContacts < iNumBiggestEmpireCities/2 :
			#### Relikt von Vlkerwanderung - fr Appeasement unerheblich
					for iPlayer2 in range(gc.getMAX_PLAYERS()):
						pPlayer2 = gc.getPlayer(iPlayer2)
						if(pPlayer2.getTeam() != iTargetEmpireTeam):
							iTeam2 = pPlayer2.getTeam ()
							if pTargetEmpireTeam.canContact(iTeam2):
								iPlayer2Civ = gc.getPlayer(iPlayer2).getCivilizationType()
								if not (gc.getCivilizationInfo(iPlayer2Civ).isCitystate()):
									if (pPlayer2.getNumCities > 2):
										iBestCityCulture = 0
										iBestOcupyCity = -1
										bFirstCity = 1
										(loopCity, iter) = pPlayer2.firstCity(True)
										while(loopCity):
											if not (loopCity.isCapital()):
												iCurTargetCulture = loopCity.getCulture(iDPlayerSmallestEmpire)
												if bFirstCity:
													iBestCityCulture = iCurTargetCulture
													iBestOcupyCity = loopCity.getID()
													bFirstCity = 0
												if (loopCity.getOriginalOwner() == iDPlayerSmallestEmpire):
													iCurTargetCulture = iCurTargetCulture*2
												if (iCurTargetCulture > iBestCityCulture):
													iBestCityCulture = iCurTargetCulture
													iBestOcupyCity = loopCity.getID()
											(loopCity, iter) = pPlayer2.nextCity(iter, true)
#										if (iBestOcupyCity == -1):
#											iBestOcupyCity = pPlayer2.getNumCities()-1
										OcupiedCity = pPlayer2.getCity(iBestOcupyCity )
										if OcupiedCity != -1:
											iCityX = OcupiedCity.getX()
											iCityY = OcupiedCity.getY()
											Defender = OcupiedCity.getConscriptUnit ()
											pTargetEmpire.acquireCity(OcupiedCity,False,True)
			###init Units	
											for i in range(5):
												pTargetEmpire.initUnit( Defender, iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
											for i in range(6):
												pTargetEmpire.initUnit( gc.getInfoTypeForString("UNIT_PANZERWAGEN"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
												pTargetEmpire.initUnit( gc.getInfoTypeForString("UNIT_MILITAERFAHRZEUG"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
											for i in range(3):
												pTargetEmpire.initUnit( gc.getInfoTypeForString("UNIT_FIGHTER"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
												pTargetEmpire.initUnit( gc.getInfoTypeForString("UNIT_WORKER"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
												pTargetEmpire.initUnit( gc.getInfoTypeForString("UNIT_HALFTRACK"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
												pTargetEmpire.initUnit( gc.getInfoTypeForString("UNIT_SELBSTFAHRLAFETTE"), iCityX,iCityY, UnitAITypes.UNITAI_RANGED_ATTACK, DirectionTypes.DIRECTION_NORTH )
												pTargetEmpire.initUnit( gc.getInfoTypeForString("UNIT_LONG_CANNON"), iCityX,iCityY, UnitAITypes.UNITAI_RANGED_ATTACK, DirectionTypes.DIRECTION_NORTH )
											for i in range(2):
												pTargetEmpire.initUnit( gc.getInfoTypeForString("UNIT_TANK"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
												pTargetEmpire.initUnit( gc.getInfoTypeForString("UNIT_BOMBER"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
												pTargetEmpire.initUnit( gc.getInfoTypeForString("UNIT_LIGHT_AA_TOWED"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
											pTargetEmpire.initUnit( gc.getInfoTypeForString("UNIT_PILLBOX"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
											pTargetEmpire.initUnit( gc.getInfoTypeForString("UNIT_MOTORBIKE_SCOUT"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
											pTargetEmpire.initUnit( gc.getInfoTypeForString("UNIT_MINEUR"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
											pTargetEmpire.initUnit( gc.getInfoTypeForString("UNIT_LAND_MINE"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
											pTargetEmpire.initUnit( gc.getInfoTypeForString("UNIT_STUKA"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
											if OcupiedCity.isCoastal(20):
												for i in range(3):
													pTargetEmpire.initUnit( gc.getInfoTypeForString("UNIT_ESCORT_DESTROYER"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
													pTargetEmpire.initUnit( gc.getInfoTypeForString("UNIT_WORKBOAT"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER_SEA, DirectionTypes.DIRECTION_NORTH )
													pTargetEmpire.initUnit( gc.getInfoTypeForString("UNIT_TRANSPORT"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
												for i in range(2):
													pTargetEmpire.initUnit( gc.getInfoTypeForString("UNIT_LIGHT_CRUISER"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
					(loopUnit, iter) = pTargetEmpire.firstUnit(true)
					while(loopUnit):
						if loopUnit.getExperience() == 0:
							loopUnit.changeExperience(8,15,false,false,false)
						(loopUnit, iter) = (pTargetEmpire.nextUnit(iter, true))
					for iPlayer in range(gc.getMAX_PLAYERS()):
						if gc.getPlayer(iPlayer).isHuman():
					               	popup = PyPopup.PyPopup(-1)
	 	    			        	popup.setHeaderString(CyTranslator().getText("TXT_KEY_HEADER_APPEASEMENT",(-1,-1)))
        						popup.setBodyString(CyTranslator().getText("TXT_KEY_MESSAGE_APPEASEMENT",(pTargetEmpire.getCivilizationDescription(0),pTargetEmpire.getCivilizationDescription(0))))
               						popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)
#	###Appeasement end###
	###Dekolonialisierung beginn###
                elif iTechType == gc.getInfoTypeForString("TECH_SOZIALE_MW"):
			if (gc.getGame().isOption(gc.getInfoTypeForString("GAMEOPTION_SPAWN_NEW_CIVS"))):
	                        pPlayer = gc.getPlayer(iPlayer)
        	                iTeam = pPlayer.getTeam()
                	        isTeamFirst = True
				iMaxTeams = gc.getMAX_CIV_TEAMS ()
		                for i in range(iMaxTeams):
        	                        if i == iTeam:continue
                	                pCurTeam = gc.getTeam(i)
                        	        if pCurTeam.isHasTech(iTechType):
                                	        isTeamFirst = False
                                        	break
	                        if isTeamFirst:
					if gc.getMAX_CIV_PLAYERS ()>CyGame().countCivPlayersAlive ():
					        NewID = -1
					        for NumCiv in xrange (gc.getMAX_PLAYERS ()):
        					        PotPlayer = gc.getPlayer(NumCiv)
        					        if not PotPlayer.isEverAlive ():
                					        NewID = NumCiv
                        					break
					        if NewID ==-1:
						        for NumCiv in xrange (gc.getMAX_PLAYERS ()):
        						        PotPlayer = gc.getPlayer(NumCiv)
        						        if not PotPlayer.isAlive():
                						        NewID = NumCiv
                        						break
					        if NewID ==-1:
					                return
						aPirateStates = [gc.getInfoTypeForString("CIVILIZATION_SOUTH_AFRICA"),gc.getInfoTypeForString("CIVILIZATION_KONGO"),gc.getInfoTypeForString("CIVILIZATION_MALI"),gc.getInfoTypeForString("CIVILIZATION_AUSTRALIA"),gc.getInfoTypeForString("CIVILIZATION_CANADA"),gc.getInfoTypeForString("CIVILIZATION_YORUBA")]
						dice = gc.getGame().getMapRand()
						randomNum = dice.get(len(aPirateStates) , "OracleSayMeTheLeader" )
						iCiv = aPirateStates[randomNum]
						PirateCiv = gc.getCivilizationInfo(iCiv)
#### Leader sollen alle die zur Civ gehren werden knnen!!####
						LeaderArray = []
 					        for iLeaders in range(gc.getNumLeaderHeadInfos ()):
      						       	if PirateCiv.isLeaders(iLeaders):
       								LeaderArray.append(iLeaders)
			      			if len(LeaderArray  ) > 0:
							iMeineZufallszahl = CyGame().getSorenRandNum(len(LeaderArray), 'IrgendeinTextAusDemDieZahlBerechnetWird')
							NewLeaderID=NewLeaderID=LeaderArray[iMeineZufallszahl]
#### Leader solleen alle werden knnen!!###
						CyGame().addPlayer(NewID,NewLeaderID,iCiv)
	   					pNewPlayer = gc.getPlayer(NewID)
     						NewTeam = gc.getTeam(pNewPlayer.getTeam())
  						NewTeamID = NewTeam.getID()
		###getbiggestEmpire
						iDPlayerBiggestEmpire = -1
						iNumBiggestEmpireCities = 0
						for iPlayer in range(gc.getMAX_PLAYERS()):
							player = gc.getPlayer(iPlayer)
							if (player.isAlive()):
								iPlayerCities = player.getNumCities()
								if iPlayerCities > iNumBiggestEmpireCities:
									if iPlayerCities > 2:
										iNumBiggestEmpireCities = iPlayerCities
										iDPlayerBiggestEmpire = iPlayer
						if (iDPlayerBiggestEmpire  > -1):
							pTargetEmpire = gc.getPlayer(iDPlayerBiggestEmpire)
							iTargetEmpireTeam = pTargetEmpire.getTeam ()
							pTargetEmpireTeam = gc.getTeam(iTargetEmpireTeam)
		###getbiggestEmpire END
							techcount=0
							for techcount in range (gc.getNumTechInfos()):
                				        	if ((pTargetEmpireTeam.isHasTech(techcount)==true)):
                        				    		NewTeam.setHasTech(techcount,1,NewID,0,1)
							iCitiesNewPlayer = pTargetEmpire.getNumCities()/4
							pLeader = gc.getLeaderHeadInfo(NewLeaderID)
							iCityCount = 0
							(loopCity, iter) = pTargetEmpire.firstCity(True)
							while(loopCity):
								iCityX = loopCity.getX()
								iCityY = loopCity.getY()
								pNewPlayer.acquireCity(loopCity,False,True)
								for i in range(7):
		###init Units
									Defender = loopCity.getConscriptUnit ()
									pNewPlayer.initUnit( Defender, iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )                
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_RADPANZER"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_JEEP"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
								for i in range(3):
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_ESCORT_FIGHTER"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_WORKER"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_SCHUTZENPANZER"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_HAUBITZE"), iCityX,iCityY, UnitAITypes.UNITAI_RANGED_ATTACK, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_PANZERARTILLERY"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
								for i in range(2):
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_KAMPFPANZER"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_GROUND_ATTACK_PLANE"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_SAM_INFANTRY"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_TRIKE"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
							#	pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_MEDIC"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_PIONIER"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_LAND_MINE"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_MULTIROLE_HELICOPTER"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
								if loopCity.isCoastal(20):
									for i in range(4):
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_DESTROYER_MODERN"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_WORKBOAT"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER_SEA, DirectionTypes.DIRECTION_NORTH )
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_HEAVY_TRANSPORT"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
									for i in range(2):
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_CRUISER_MODERN"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
		###init Units
		###init Gebude und Kultur
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_BEWAESSERUNG"),1)
								loopCity.changeCulture(NewID,loopCity.getCulture(iDPlayerBiggestEmpire),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_GRANARY"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_SIEGEWORKSHOP"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_MARKET"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_BARRACKS"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_TRAINING"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_LIBRARY"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_WAFFENKAMMER"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_LAZARETT"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_HARBOR"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_SCHOOL"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_JAIL"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_TOWN_CENTER"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_FORGE"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_POLICE"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_GYMNASIUM"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_COLOSSEUM"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_MUSEUM"),1)
		###init Gebude und Kultur
								iCityCount = iCityCount+1
								if iCityCount == iCitiesNewPlayer:
									break
								(loopCity, iter) = pTargetEmpire.nextCity(iter, true)
						        pNewPlayer.setGold(pTargetEmpire.getGold())
		###Basisbefrderungen Einheiten
							(loopUnit, iter) = pNewPlayer.firstUnit(true)
							while(loopUnit):
								loopUnit.changeExperience(8,15,false,false,false)
								if (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_SEA")):
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_PIRATE1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_PATROL1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COASTGUARD1"),1)
								elif (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_IMMOBILE")):
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_GARRISON1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_DRILL1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT1"),1)
								elif (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_AIR")):
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT2"),1)
								else:
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_RAIDER1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_SECURITY"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_GUERILLA1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_GARRISON1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_DISCIPLINE1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_WOODSMAN1"),1)
								(loopUnit, iter) = (pNewPlayer.nextUnit(iter, true))
		###Basisbefrderungen Einheiten
							iOldCiv = pTargetEmpire.getCivilizationType()
							PlayerAdjectiv = gc.getCivilizationInfo(iOldCiv).getDescription()
							NewPlayerAdjectiv = PirateCiv.getDescription()
                	                		for iPlayer in range (gc.getMAX_CIV_PLAYERS()):
                        	                		pMessagePlayer = gc.getPlayer(iPlayer)
                                	               		if pMessagePlayer.isHuman():
                                        	               		popup = PyPopup.PyPopup(-1)
                                                	        	popup.setHeaderString(CyTranslator().getText("TXT_KEY_INDEPENDENCE_HEADER",(PlayerAdjectiv,NewPlayerAdjectiv)))
									popup.setBodyString(CyTranslator().getText("TXT_KEY_INDEPENDENCE_DEKOLONISIERUNG_TEXT",(PlayerAdjectiv,NewPlayerAdjectiv)))
									popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)
	###Dekolonialisierung End###
	###Rogue Nation beginn###
                elif iTechType == gc.getInfoTypeForString("TECH_OUTSOURCING"):
			if (gc.getGame().isOption(gc.getInfoTypeForString("GAMEOPTION_SPAWN_NEW_CIVS"))):
	                        pPlayer = gc.getPlayer(iPlayer)
        	                iTeam = pPlayer.getTeam()
                	        isTeamFirst = True
				iMaxTeams = gc.getMAX_CIV_TEAMS ()
		                for i in range(iMaxTeams):
        	                        if i == iTeam:continue
                	                pCurTeam = gc.getTeam(i)
                        	        if pCurTeam.isHasTech(iTechType):
                                	        isTeamFirst = False
                                        	break
	                        if isTeamFirst:
					if gc.getMAX_CIV_PLAYERS ()>CyGame().countCivPlayersAlive ():
					        NewID = -1
					        for NumCiv in xrange (gc.getMAX_PLAYERS ()):
        					        PotPlayer = gc.getPlayer(NumCiv)
        					        if not PotPlayer.isEverAlive ():
                					        NewID = NumCiv
                        					break
					        if NewID ==-1:
						        for NumCiv in xrange (gc.getMAX_PLAYERS ()):
        						        PotPlayer = gc.getPlayer(NumCiv)
        						        if not PotPlayer.isAlive():
                						        NewID = NumCiv
                        						break
					        if NewID ==-1:
					                return
						aPirateStates = [gc.getInfoTypeForString("CIVILIZATION_KOREA"),gc.getInfoTypeForString("CIVILIZATION_AFGHAN"),gc.getInfoTypeForString("CIVILIZATION_PAKISTAN"),gc.getInfoTypeForString("CIVILIZATION_VIETNAM")]
						dice = gc.getGame().getMapRand()
						randomNum = dice.get(len(aPirateStates) , "OracleSayMeTheLeader" )
						iCiv = aPirateStates[randomNum]
						PirateCiv = gc.getCivilizationInfo(iCiv)
#### Leader sollen alle die zur Civ gehren werden knnen!!####
						LeaderArray = []
 					        for iLeaders in range(gc.getNumLeaderHeadInfos ()):
      						       	if PirateCiv.isLeaders(iLeaders):
       								LeaderArray.append(iLeaders)
			      			if len(LeaderArray  ) > 0:
							iMeineZufallszahl = CyGame().getSorenRandNum(len(LeaderArray), 'IrgendeinTextAusDemDieZahlBerechnetWird')
							NewLeaderID=NewLeaderID=LeaderArray[iMeineZufallszahl]
#### Leader solleen alle werden knnen!!###
						CyGame().addPlayer(NewID,NewLeaderID,iCiv)
	   					pNewPlayer = gc.getPlayer(NewID)
     						NewTeam = gc.getTeam(pNewPlayer.getTeam())
  						NewTeamID = NewTeam.getID()
		###getbiggestEmpire
						iDPlayerBiggestEmpire = -1
						iNumBiggestEmpireCities = 0
						for iPlayer in range(gc.getMAX_PLAYERS()):
							player = gc.getPlayer(iPlayer)
							if (player.isAlive()):
								iPlayerCities = player.getNumCities()
								if iPlayerCities > iNumBiggestEmpireCities:
									if iPlayerCities > 2:
										iNumBiggestEmpireCities = iPlayerCities
										iDPlayerBiggestEmpire = iPlayer
						if (iDPlayerBiggestEmpire  > -1):
							pTargetEmpire = gc.getPlayer(iDPlayerBiggestEmpire)
							iTargetEmpireTeam = pTargetEmpire.getTeam ()
							pTargetEmpireTeam = gc.getTeam(iTargetEmpireTeam)
		###getbiggestEmpire END
							techcount=0
							for techcount in range (gc.getNumTechInfos()):
                				        	if ((pTargetEmpireTeam.isHasTech(techcount)==true)):
                        				    		NewTeam.setHasTech(techcount,1,NewID,0,1)
							iCitiesNewPlayer = pTargetEmpire.getNumCities()/4
							pLeader = gc.getLeaderHeadInfo(NewLeaderID)
							iFavoriteReligion = pLeader.getFavoriteReligion ()
							iCityCount = 0
							(loopCity, iter) = pTargetEmpire.firstCity(True)
							while(loopCity):
								iCityX = loopCity.getX()
								iCityY = loopCity.getY()
								pNewPlayer.acquireCity(loopCity,False,True)
								if ( iFavoriteReligion != -1):
									loopCity.setHasReligion(iFavoriteReligion,true,true,true )
								for i in range(8):
		###init Units
									Defender = loopCity.getConscriptUnit ()
									pNewPlayer.initUnit( Defender, iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )                
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_RADPANZER"), iCityX,iCityY, UnitAITypes.UNITAI_RANGED_ATTACK, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_WARJEEP"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
								for i in range(3):
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_JET_FIGHTER"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_WORKER"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_TERRORIST"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_GIFTGAS"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_SAM_INFANTRY"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_PARTISAN"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
								for i in range(2):
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_JIHAD"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_KAMPFPANZER"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
									pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_MODERN_BOMBER"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_MOTORBIKE_SCOUT"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
						#		pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_MEDIC"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_HUBSCHRAUBER"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
								pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_MISSILE_FORTRESS"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
								if loopCity.isCoastal(20):
									for i in range(4):
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_DESTROYER_MODERN"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER_SEA, DirectionTypes.DIRECTION_NORTH )
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_WORKBOAT"), iCityX,iCityY, UnitAITypes.UNITAI_WORKER_SEA, DirectionTypes.DIRECTION_NORTH )
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_TRANSPORT"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
									for i in range(2):
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_CRUISER_MODERN"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_CRUISE_MISSILE"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
										pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_ATTACK_SUBMARINE"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
		###init Units
		###init Gebude und Kultur
								loopCity.changeCulture(NewID,loopCity.getCulture(iDPlayerBiggestEmpire),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_GRANARY"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_SIEGEWORKSHOP"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_MARKET"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_BARRACKS"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_TRAINING"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_BEWAESSERUNG"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_LIBRARY"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_WAFFENKAMMER"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_LAZARETT"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_HARBOR"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_SCHOOL"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_JAIL"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_TOWN_CENTER"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_FORGE"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_POLICE"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_GYMNASIUM"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_COLOSSEUM"),1)
								loopCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_MUSEUM"),1)
		###init Gebude und Kultur
								iCityCount = iCityCount+1
								if iCityCount == iCitiesNewPlayer:
									break
								(loopCity, iter) = pTargetEmpire.nextCity(iter, true)
						        pNewPlayer.setGold(pTargetEmpire.getGold())
		###Basisbefrderungen Einheiten
							(loopUnit, iter) = pNewPlayer.firstUnit(true)
							while(loopUnit):
								loopUnit.changeExperience(9,17,false,false,false)
								if (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_SEA")):
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_PIRATE1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_PATROL1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COASTGUARD1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_MANEUVER1"),1)
								elif (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_IMMOBILE")):
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_GARRISON1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_DRILL1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT1"),1)
								elif (loopUnit.getDomainType() == gc.getInfoTypeForString("DOMAIN_AIR")):
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT2"),1)
								else:
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_RAIDER1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_SECURITY"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_GUERILLA1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_CITY_GARRISON1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMBAT1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_DISCIPLINE1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_WOODSMAN1"),1)
									loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_DESERTWAR1"),1)
								(loopUnit, iter) = (pNewPlayer.nextUnit(iter, true))
		###Basisbefrderungen Einheiten
							iOldCiv = pTargetEmpire.getCivilizationType()
							PlayerAdjectiv = gc.getCivilizationInfo(iOldCiv).getDescription()
							NewPlayerAdjectiv = PirateCiv.getDescription()
                	                		for iPlayer in range (gc.getMAX_CIV_PLAYERS()):
                        	                		pMessagePlayer = gc.getPlayer(iPlayer)
                                	               		if pMessagePlayer.isHuman():
                                        	               		popup = PyPopup.PyPopup(-1)
                                                	        	popup.setHeaderString(CyTranslator().getText("TXT_KEY_INDEPENDENCE_HEADER",(PlayerAdjectiv,NewPlayerAdjectiv)))
									popup.setBodyString(CyTranslator().getText("TXT_KEY_INDEPENDENCE_ROGUE_NATION_TEXT",(PlayerAdjectiv,NewPlayerAdjectiv)))
									popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)
	###Rogue Nation End###
	###PATRIOT beginn###
                elif iTechType == gc.getInfoTypeForString("TECH_PATRIOTISMUS"):
			if (gc.getGame().isOption(gc.getInfoTypeForString("GAMEOPTION_SPAWN_NEW_CIVS"))):
	                        pPlayer = gc.getPlayer(iPlayer)
        	                iTeam = pPlayer.getTeam()
                	        isTeamFirst = True
				iMaxTeams = gc.getMAX_CIV_TEAMS ()
		                for i in range(iMaxTeams):
        	                        if i == iTeam:continue
                	                pCurTeam = gc.getTeam(i)
                        	        if pCurTeam.isHasTech(iTechType):
                                	        isTeamFirst = False
                                        	break
	                        if isTeamFirst:
					if gc.getMAX_CIV_PLAYERS ()>CyGame().countCivPlayersAlive ():
					        NewID = -1
					        for NumCiv in xrange (gc.getMAX_PLAYERS ()):
        					        PotPlayer = gc.getPlayer(NumCiv)
        					        if not PotPlayer.isEverAlive():
        	       					        NewID = NumCiv
                        					break
					        if NewID ==-1:
						        for NumCiv in xrange (gc.getMAX_PLAYERS ()):
        						        PotPlayer = gc.getPlayer(NumCiv)
        						        if not PotPlayer.isAlive():
                						        NewID = NumCiv
         	              						break
					        if NewID ==-1:
					                return
						iOldCiv = pPlayer.getCivilizationType()
						pOldCiv = gc.getCivilizationInfo(iOldCiv)
	
						iCiv = pOldCiv.getDerivativeCitystate()
						if (iCiv == -1):
							iCiv =gc.getInfoTypeForString("CIVILIZATION_STADTSTAAT_VATIKAN")
						PirateCiv = gc.getCivilizationInfo(iCiv)
#### Leader sollen alle die zur Civ gehren werden knnen!!####
						LeaderArray = []
 					        for iLeaders in range(gc.getNumLeaderHeadInfos ()):
      						       	if PirateCiv.isLeaders(iLeaders):
       								LeaderArray.append(iLeaders)
			      			if len(LeaderArray  ) > 0:
							iMeineZufallszahl = CyGame().getSorenRandNum(len(LeaderArray), 'IrgendeinTextAusDemDieZahlBerechnetWird')
							NewLeaderID=NewLeaderID=LeaderArray[iMeineZufallszahl] 
#### Leader solleen alle werden knnen!!###
						pIndependendCity = -1
						pCapital = pPlayer.getCapitalCity()
						iCapitalX = pCapital.getX()
						iCapitalY = pCapital.getY()
						PCapitalPlot = gc.getMap().plot(iCapitalX,iCapitalY)
						iCapitalArea = PCapitalPlot.getArea()
						(loopCity, iter) = pPlayer.firstCity(True)
						while(loopCity):
							iCityX = loopCity.getX()
							iCityY = loopCity.getY()
							PCityPlot = gc.getMap().plot(iCityX,iCityY)
							if (PCityPlot.getArea() != iCapitalArea) :
								pArea = PCityPlot.area()
								if (pArea.getNumCities() == 1):
									pIndependendCity = loopCity
									loopCity.changeCulture(NewID,loopCity.getCulture(iPlayer),1)
							(loopCity, iter) = pPlayer.nextCity(iter, true)
						if (pIndependendCity != -1):
	      						CyGame().addPlayer(NewID,NewLeaderID,iCiv)
   							pNewPlayer = gc.getPlayer(NewID)
     							NewTeam = gc.getTeam(pNewPlayer.getTeam())
  							NewTeamID = NewTeam.getID()
							techcount=0
							pOldTeam = gc.getTeam(iTeam)
							for techcount in range (gc.getNumTechInfos()):
                				        	if ((pOldTeam.isHasTech(techcount)==true)):
                        				    		NewTeam.setHasTech(techcount,1,NewID,0,1)
							iCityX = pIndependendCity.getX()
							iCityY = pIndependendCity.getY()
							Defender = pIndependendCity.getConscriptUnit()
							pNewPlayer.acquireCity(pIndependendCity,False,True)###pIndependendCity existiert nun nicht mehr!!!
							for i in range(3):
								pNewPlayer.initUnit( Defender, iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )                
							pNewPlayer.initUnit( gc.getInfoTypeForString("UNIT_COASTALFORTRESS"), iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )                
#### Basis-Erfahrung, damit nichts aufgelst wird
							(loopUnit, iter) = pNewPlayer.firstUnit(true)
							while(loopUnit):
								loopUnit.changeExperience(1,1,false,false,false)
								(loopUnit, iter) = (pNewPlayer.nextUnit(iter, true))
#### Basis-Erfahrung, damit nichts aufgelst wird
							pNewPlayer.setGold(pPlayer.getGold()/2)
							PlayerAdjectiv = pOldCiv.getDescription()
							NewPlayerAdjectiv = PirateCiv.getDescription()
	                                		for iPlayer in range (gc.getMAX_CIV_PLAYERS()):
        	                                		pMessagePlayer = gc.getPlayer(iPlayer)
                	                               		if pMessagePlayer.isHuman():
                        	                               		popup = PyPopup.PyPopup(-1)
                                	                        	popup.setHeaderString(CyTranslator().getText("TXT_KEY_INDEPENDENCE_HEADER",(PlayerAdjectiv,NewPlayerAdjectiv)))
                                        	               		popup.setBodyString(CyTranslator().getText("TXT_KEY_INDEPENDENCE_PATRIOT_TEXT",(PlayerAdjectiv,NewPlayerAdjectiv)))
                                                	       		popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)
	###PATRI#OT ENDE###
	###Independence beginn: Aufklaerung###
                if iTechType == gc.getInfoTypeForString("TECH_AUFKLAERUNG"):
			if (gc.getGame().isOption(gc.getInfoTypeForString("GAMEOPTION_SPAWN_NEW_CIVS"))):
	                        iMaxPlayers = gc.getMAX_CIV_PLAYERS()
        	        	pPlayer = gc.getPlayer(iPlayer)
                	        iTeam = pPlayer.getTeam()
				pPlayerTeam = gc.getTeam(iTeam)
	                        isTeamFirst = True
				iMaxTeams = gc.getMAX_CIV_TEAMS ()
	        	        for i in range(iMaxTeams):
                        	        if i == iTeam:continue
                                	pCurTeam = gc.getTeam(i)
	                                if pCurTeam.isHasTech(iTechType):
        	                                isTeamFirst = False
                	                        break
                        	if isTeamFirst:
					for i in range(iMaxPlayers):
						if i == iPlayer:continue
						pCurPlayer = gc.getPlayer(i)
						iCutTeam = pCurPlayer.getTeam()
                	                	pCurTeam = gc.getTeam(iCutTeam)
						if pCurTeam.isVassal(iTeam):
							bIndependence = True
							iOpferCiv = pCurPlayer.getCivilizationType ()
							if ( gc.getCivilizationInfo(iOpferCiv ).isCitystate()):
								bIndependence = False
							if bIndependence:
								pCurTeam.setVassal(iTeam, false, false)
								iOldCiv = pPlayer.getCivilizationType()
								PlayerAdjectiv = gc.getCivilizationInfo(iOldCiv).getDescription()
								NewPlayerAdjectiv = pCurPlayer.getName ()
                        	        	        	for i in range (iMaxPlayers):
                                	        			pMessagePlayer = gc.getPlayer(i)
	                                        			if pMessagePlayer.isHuman():
        	                                        	        	popup = PyPopup.PyPopup(-1)
	        	                                        	        popup.setHeaderString(CyTranslator().getText("TXT_KEY_INDEPENDENCE_HEADER",(PlayerAdjectiv,NewPlayerAdjectiv)))
        	        	                                        	popup.setBodyString(CyTranslator().getText("TXT_KEY_INDEPENDENCE_AUFKLAERUNG_TEXT",(PlayerAdjectiv,NewPlayerAdjectiv)))
                	        	        	                        popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)
								break
	###Independence end: Aufklaerung###
	###Independence beginn: Banditen###
                elif iTechType == gc.getInfoTypeForString("TECH_CODE_OF_LAWS"):
			if (gc.getGame().isOption(gc.getInfoTypeForString("GAMEOPTION_SPAWN_NEW_CIVS"))):
	                        iMaxPlayers = gc.getMAX_CIV_PLAYERS()
        	        	pPlayer = gc.getPlayer(iPlayer)
                	        iTeam = pPlayer.getTeam()
				pPlayerTeam = gc.getTeam(iTeam)
	                        isTeamFirst = True
				iMaxTeams = gc.getMAX_CIV_TEAMS ()
	        	        for i in range(iMaxTeams):
                        	        if i == iTeam:continue
                                	pCurTeam = gc.getTeam(i)
	                                if pCurTeam.isHasTech(iTechType):
        	                                isTeamFirst = False
                	                        break
                        	if isTeamFirst:
					iCityNumber = pPlayer.getNumCities()
					if iCityNumber  > 5:
						pCapital = pPlayer.getCapitalCity()
						pLastCity = pPlayer.getCity(iCityNumber-1)
						iPlotY = pLastCity.getY()
						iPlotX = pLastCity.getX()
						iCapitalY = pCapital.getY()
						iCapitalX = pCapital.getX()
						pLastCityPlot = gc.getMap().plot(iPlotX ,iPlotY )
						Defender = pLastCity.getConscriptUnit()
						CityName = pLastCity.getName ()
						iUnitsToMove = pLastCityPlot.getNumUnits()
						for i in range(iUnitsToMove+1 ):
							pUnitToMove= pLastCityPlot.getUnit(iUnitsToMove-i)
							pUnitToMove.setXY(iCapitalX, iCapitalY , false, false,false)
						iBandits = gc.getBARBARIAN_PLAYER ()
						pBandits = gc.getPlayer(iBandits)
						pBandits.acquireCity (pLastCity, true, false)
						if (pLastCity == -1):
							pBandits.found(iPlotX,iPlotY)
						for i in range(4):
							pBandits.initUnit(Defender, iPlotX ,iPlotY , UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )                
						iOldCiv = pPlayer.getCivilizationType()
						PlayerAdjectiv = gc.getCivilizationInfo(iOldCiv).getDescription()
                       	        	        for i in range (iMaxPlayers):
                               	       			pMessagePlayer = gc.getPlayer(i)
                                       			if pMessagePlayer.isHuman():
                                       	        		popup = PyPopup.PyPopup(-1)
	                                         	        popup.setHeaderString(CyTranslator().getText("TXT_KEY_INDEPENDENCE_HEADER",(PlayerAdjectiv,CityName )))
      		                                               	popup.setBodyString(CyTranslator().getText("TXT_KEY_INDEPENDENCE_BANDIT_TEXT",(PlayerAdjectiv,CityName )))
               		                                        popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)
	###Independence end: Banditen###
### spawn civs Ende###
### obsolete Corporations start part 1
		found = false
		for e in range (gc.getNumCorporationInfos ()):
                        if CyGame().isCorporationFounded(e):
                                found = True
                                break
                if found:
                        countcorp = 0
        		for i in range(gc.getNumBuildingInfos ()):
                                thisbuilding = gc.getBuildingInfo (i)
                                if thisbuilding.getFoundsCorporation ()>-1:
                                        countcorp = countcorp+1
                                        if countcorp >gc.getNumCorporationInfos ():
                                                return
                                        obsoleteTech = thisbuilding.getObsoleteTech()
                                        if obsoleteTech==-1:continue
                                        if iTechType == obsoleteTech:
                                                pPlayer = gc.getPlayer(iPlayer)
                                                for iCity in range(pPlayer.getNumCities()):
                                                        pCity = pPlayer.getCity(iCity)
                                                        pCity.setHasCorporation(thisbuilding.getFoundsCorporation (),False,False,True)
							if pCity == gc.getGame().getHeadquarters(thisbuilding.getFoundsCorporation ()):
								gc.getGame().clearHeadquarters (thisbuilding.getFoundsCorporation ())
                                                if pPlayer.isHuman():
                                                        popup = PyPopup.PyPopup(-1)
                                                        popup.setHeaderString(CyTranslator().getText("TXT_CORPORATION_DESTROYED_HEADER",(thisbuilding.getDescription (),thisbuilding.getDescription ())))
                                                        popup.setBodyString(CyTranslator().getText("TXT_CORPORATION_DESTROYED_TEXT",(thisbuilding.getDescription (),thisbuilding.getDescription ())))
                                                        popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)    
###obsolete corporations end part 1

		# Note that iPlayer may be NULL (-1) and not a refer to a player object
		
		# Show tech splash when applicable
		if (iPlayer > -1 and bAnnounce and not CyInterface().noTechSplash()):
			if (gc.getGame().isFinalInitialized() and not gc.getGame().GetWorldBuilderMode()):
				if ((not gc.getGame().isNetworkMultiPlayer()) and (iPlayer == gc.getGame().getActivePlayer())):
					popupInfo = CyPopupInfo()
					popupInfo.setButtonPopupType(ButtonPopupTypes.BUTTONPOPUP_PYTHON_SCREEN)
					popupInfo.setData1(iTechType)
					popupInfo.setText(u"showTechSplash")
					popupInfo.addPopup(iPlayer)

		if (not self.__LOG_TECH):
			return
		CvUtil.pyPrint('%s was finished by Team %d' 
			%(PyInfo.TechnologyInfo(iTechType).getDescription(), iTeam))
	
	def onTechSelected(self, argsList):
		'Tech Selected'
		iTechType, iPlayer = argsList
		if (not self.__LOG_TECH):
			return
		CvUtil.pyPrint('%s was selected by Player %d' %(PyInfo.TechnologyInfo(iTechType).getDescription(), iPlayer))
	
	def onReligionFounded(self, argsList):
		'Religion Founded'
		iReligion, iFounder = argsList
		player = PyPlayer(iFounder)

		iCityId = gc.getGame().getHolyCity(iReligion).getID()
		if (gc.getGame().isFinalInitialized() and not gc.getGame().GetWorldBuilderMode()):
			if ((not gc.getGame().isNetworkMultiPlayer()) and (iFounder == gc.getGame().getActivePlayer())):
				popupInfo = CyPopupInfo()
				popupInfo.setButtonPopupType(ButtonPopupTypes.BUTTONPOPUP_PYTHON_SCREEN)
				popupInfo.setData1(iReligion)
				popupInfo.setData2(iCityId)
				popupInfo.setData3(1)
				popupInfo.setText(u"showWonderMovie")
				popupInfo.addPopup(iFounder)
		
		if (not self.__LOG_RELIGION):
			return
		CvUtil.pyPrint('Player %d Civilization %s has founded %s'
			%(iFounder, player.getCivilizationName(), gc.getReligionInfo(iReligion).getDescription()))

	def onReligionSpread(self, argsList):
		'Religion Has Spread to a City'
		iReligion, iOwner, pSpreadCity = argsList
		player = PyPlayer(iOwner)
		if (not self.__LOG_RELIGIONSPREAD):
			return
		CvUtil.pyPrint('%s has spread to Player %d Civilization %s city of %s'
			%(gc.getReligionInfo(iReligion).getDescription(), iOwner, player.getCivilizationName(), pSpreadCity.getName()))

	def onReligionRemove(self, argsList):
		'Religion Has been removed from a City'
		iReligion, iOwner, pRemoveCity = argsList
		player = PyPlayer(iOwner)
		if (not self.__LOG_RELIGIONSPREAD):
			return
		CvUtil.pyPrint('%s has been removed from Player %d Civilization %s city of %s'
			%(gc.getReligionInfo(iReligion).getDescription(), iOwner, player.getCivilizationName(), pRemoveCity.getName()))
				
	def onCorporationFounded(self, argsList):
		'Corporation Founded'
		iCorporation, iFounder = argsList
		player = PyPlayer(iFounder)
		
		if (not self.__LOG_RELIGION):
			return
		CvUtil.pyPrint('Player %d Civilization %s has founded %s'
			%(iFounder, player.getCivilizationName(), gc.getCorporationInfo(iCorporation).getDescription()))

	def onCorporationSpread(self, argsList):
		'Corporation Has Spread to a City'
		iCorporation, iOwner, pSpreadCity = argsList
		player = PyPlayer(iOwner)
### obsolete corporations part 2 start		
		for i in range(gc.getNumBuildingInfos ()):
                                thisbuilding = gc.getBuildingInfo (i)
                                if thisbuilding.getFoundsCorporation ()==iCorporation:                                        
                                        pPlayer = gc.getPlayer(iOwner)
                                        iTeam = pPlayer.getTeam ()
                                        MyTeam = gc.getTeam(iTeam)
                                        obsoleteTech = thisbuilding.getObsoleteTech()
                                        if obsoleteTech==-1:continue
                                        if MyTeam.isHasTech(obsoleteTech):                                       
                                                pSpreadCity.setHasCorporation(thisbuilding.getFoundsCorporation (),False,False,True)
                                        break
###obsolete corporations part 2 end                          
		if (not self.__LOG_RELIGIONSPREAD):
			return
		CvUtil.pyPrint('%s has spread to Player %d Civilization %s city of %s'
			%(gc.getCorporationInfo(iCorporation).getDescription(), iOwner, player.getCivilizationName(), pSpreadCity.getName()))

	def onCorporationRemove(self, argsList):
		'Corporation Has been removed from a City'
		iCorporation, iOwner, pRemoveCity = argsList
		player = PyPlayer(iOwner)
		if (not self.__LOG_RELIGIONSPREAD):
			return
		CvUtil.pyPrint('%s has been removed from Player %d Civilization %s city of %s'
			%(gc.getReligionInfo(iReligion).getDescription(), iOwner, player.getCivilizationName(), pRemoveCity.getName()))
				
	def onGoldenAge(self, argsList):
		'Golden Age'
		iPlayer = argsList[0]
		player = PyPlayer(iPlayer)
		if (not self.__LOG_GOLDENAGE):
			return
		CvUtil.pyPrint('Player %d Civilization %s has begun a golden age'
			%(iPlayer, player.getCivilizationName()))

	def onEndGoldenAge(self, argsList):
		'End Golden Age'
		iPlayer = argsList[0]
		player = PyPlayer(iPlayer)
		if (not self.__LOG_ENDGOLDENAGE):
			return
		CvUtil.pyPrint('Player %d Civilization %s golden age has ended'
			%(iPlayer, player.getCivilizationName()))

	def onChangeWar(self, argsList):
		'War Status Changes'
		bIsWar = argsList[0]
		iTeam = argsList[1]
		iRivalTeam = argsList[2]
		if (not self.__LOG_WARPEACE):
			return
		if (bIsWar):
			strStatus = "declared war"
###beginn Stadtstaat gerettet###
			for iPlayer in range(gc.getMAX_PLAYERS()):
				player = gc.getPlayer(iPlayer)
				if (player.getTeam() == iRivalTeam ):
					iOpferCiv = player.getCivilizationType ()
					if ( gc.getCivilizationInfo(iOpferCiv ).isCitystate()):
						for iPlayer in range(gc.getMAX_PLAYERS()):
							player = gc.getPlayer(iPlayer)
							pAgressorTeam = gc.getTeam(iTeam )
							pRivalTeam = gc.getTeam(iRivalTeam)
							if (player.isAlive() and player.isHuman()):
								popup = PyPopup.PyPopup(-1)
								popup.setHeaderString(CyTranslator().getText("TXT_CITYSTATE_UNDER_ATTACK_HEADER",(-1,-1)))
								popup.setBodyString(CyTranslator().getText("TXT_CITYSTATE_UNDER_ATTACK_TEXT",(pAgressorTeam.getName() ,pRivalTeam.getName())))
								popup.launch(True, PopupStates.POPUPSTATE_IMMEDIATE)
###end Stadtstaat gerettet###
		else:
			strStatus = "declared peace"
		CvUtil.pyPrint('Team %d has %s on Team %d'
			%(iTeam, strStatus, iRivalTeam))
	
	def onChat(self, argsList):
		'Chat Message Event'
		chatMessage = "%s" %(argsList[0],)
		
	def onSetPlayerAlive(self, argsList):
		'Set Player Alive Event'
		iPlayerID = argsList[0]
		bNewValue = argsList[1]
		CvUtil.pyPrint("Player %d's alive status set to: %d" %(iPlayerID, int(bNewValue)))
		
	def onPlayerChangeStateReligion(self, argsList):
		'Player changes his state religion'
		iPlayer, iNewReligion, iOldReligion = argsList
		
	def onPlayerGoldTrade(self, argsList):
		'Player Trades gold to another player'
		iFromPlayer, iToPlayer, iGoldAmount = argsList
		
	def onCityBuilt(self, argsList):
		'City Built'
		city = argsList[0]
		if (city.getOwner() == gc.getGame().getActivePlayer()):
			self.__eventEditCityNameBegin(city, False)	
		CvUtil.pyPrint('City Built Event: %s' %(city.getName()))
###KI-Bonus Beginn###
		pPlayer = gc.getPlayer(city.getOwner())
		bKi = true
		if pPlayer.isHuman:
			bKi = false
		if bKi:
			iPlotY = city.getY()
			iPlotX = city.getX()
			pCityPlot = gc.getMap().plot(iPlotX ,iPlotY )
			if pCityPlot.getBonusType == gc.getInfoTypeForString("BONUS_RUINS"):
				pCityPlot.setBonusType(-1)
				pNextPlot = gc.getMap().plot(iPlotX+1 ,iPlotY )
				pNextPlot.setImprovementType(gc.getInfoTypeForString("IMPROVEMENT_AUSGRABUNG"))
			for i in range(5):
				for j in range(5):
					loopPlot = gc.getMap().plot(iPlotX + i - 2, iPlotY + j - 2)
					if loopPlot.getFeatureType() == gc.getInfoTypeForString("FEATURE_CAVE"):
						iPlayerTeam = pPlayer.getTeam()
						pPlayerTeam = gc.getTeam(iPlayerTeam )
						if pPlayerTeam.isHasTech(gc.getInfoTypeForString("TECH_HOEHLENMALEREI")):
							loopPlot.setFeatureType(-1,1)
							loopPlot.setImprovementType(gc.getInfoTypeForString("IMPROVEMENT_HOEHLENFORSCHUNG"))
					elif loopPlot.getFeatureType() == gc.getInfoTypeForString("FEATURE_GOODY_ISLAND"):
						iPlayerTeam = pPlayer.getTeam()
						pPlayerTeam = gc.getTeam(iPlayerTeam )
						if pPlayerTeam.isHasTech(gc.getInfoTypeForString("TECH_NAVIGATION")):
							loopPlot.setFeatureType(-1,1)
							loopPlot.setImprovementType(gc.getInfoTypeForString("IMPROVEMENT_GOODY_ISLAND"))
###KI-Bonus End###
###100% falls favorite religion begin###
		iLeader = pPlayer.getLeaderType()
		pLeader = gc.getLeaderHeadInfo(iLeader)
		iFavoriteReligion = pLeader.getFavoriteReligion()
		iReligion = pPlayer.getStateReligion()
		if iReligion == iFavoriteReligion:
			if iReligion != -1:
				city.setHasReligion(iReligion,True,True,True) 
###100% falls favorite religion end###

	def onCityRazed(self, argsList):
		'City Razed'
		city, iPlayer = argsList
		iOwner = city.findHighestCulture()
#### messages - wonder destroyed start ####
		pCity = city		
		NumWonders = pCity.getNumWorldWonders
		if NumWonders ()>0:
                        Counter = 0
                        for i in range(gc.getNumBuildingInfos ()):
                                thisbuilding = gc.getBuildingInfo (i)
                                if pCity.getNumBuilding(i)>0:
                                        iBuildingClass = thisbuilding.getBuildingClassType ()
                                        thisbuildingclass = gc.getBuildingClassInfo (iBuildingClass)
                                        if thisbuildingclass.getMaxGlobalInstances ()==1:
                                                ConquerPlayer = gc.getPlayer(iPlayer)
                                                iConquerTeam = ConquerPlayer.getTeam()
                                                ConquerName = ConquerPlayer.getName ()
                                                WonderName = thisbuilding.getDescription ()
                                                iX = pCity.getX()
                                                iY = pCity.getY()
                                                for iAllPlayer in range (gc.getMAX_CIV_PLAYERS ()):
                                                        ThisPlayer = gc.getPlayer(iAllPlayer)
                                                        iThisTeam = ThisPlayer.getTeam()
                                                        ThisTeam = gc.getTeam(iThisTeam)
                                                        if ThisTeam.isHasMet(iConquerTeam):
                                                                if iAllPlayer == iPlayer:
                                                                        CyInterface().addMessage(iAllPlayer,False,15,CyTranslator().getText("TXT_KEY_YOU_DESTROYED_WONDER",(ConquerName,WonderName)),'',0,'Art/Interface/Buttons/General/warning_popup.dds',ColorTypes(gc.getInfoTypeForString("COLOR_RED")), iX, iY, True,True)
                                                                else:
                                                                        CyInterface().addMessage(iAllPlayer,False,15,CyTranslator().getText("TXT_KEY_DESTROYED_WONDER",(ConquerName,WonderName)),'',0,'Art/Interface/Buttons/General/warning_popup.dds',ColorTypes(gc.getInfoTypeForString("COLOR_RED")), iX, iY, True,True)
### Set Ruin begin###
			iX = pCity.getX()
			iY = pCity.getY()
			pPlot = CyMap().plot(iX, iY)
			if pPlot.getBonusType(-1) == -1:
				pPlot.setBonusType(gc.getInfoTypeForString("BONUS_RUINS"))			
### Set Ruin end ###
#### messages - wonder destroyed end ####

		if pCity.getPopulation() > 1 and iOwner != -1 and iPlayer != -1:

	### beginn extra Beute
			iExtraGold = pCity.getPopulation()*5
			iExtraGold = iExtraGold+(pCity.getCulture(iOwner)/25)
		###Raze killt Kultur
			iPreviousOwner = pCity.getPreviousOwner()
			iPreviousCuture = pCity.getCulture(iPreviousOwner)
			iExtraGold = iExtraGold+iPreviousCuture/10
			pCity.changeCulture(iPreviousOwner,-iPreviousCuture/2,true)
		###Raze killt Kultur Ende
			iBuildingGold = 0
        	        for i in range(gc.getNumBuildingInfos ()):
                	        if pCity.getNumBuilding(i)>0:
                        	        thisbuilding = gc.getBuildingInfo (i)
					if (thisbuilding.getProductionCost () != -1):
						iBuildingGold = iBuildingGold+thisbuilding.getProductionCost()
					else:
						iBuildingGold = iBuildingGold+100
			iExtraGold =iExtraGold+(iBuildingGold/10)
			ConquerPlayer = gc.getPlayer(iPlayer)
			CityName = pCity.getName()
			iX = pCity.getX()
			iY = pCity.getY()
			ConquerPlayer.changeGold(iExtraGold)
                	CyInterface().addMessage(iPlayer,False,15,CyTranslator().getText("TXT_KEY_EXTRA_GOLD_FROM_RAZE",(CityName ,iExtraGold)),'',0,'Art/Interface/Buttons/General/warning_popup.dds',ColorTypes(gc.getInfoTypeForString("COLOR_GREEN")), iX, iY, True,True)
### End extra Beute
### Piraten Fliehen nach Eroberung beginn###
			owner = gc.getPlayer(iOwner)
			if not owner.isBarbarian() and owner.getNumCities() > 0:
				if gc.getTeam(owner.getTeam()).isAtWar(gc.getPlayer(iPlayer).getTeam()):
					if pCity.getPreviousOwner() == pCity.getOriginalOwner():
						pPreviousOwner = gc.getPlayer(pCity.getPreviousOwner())
						pPreviousCiv = gc.getCivilizationInfo(pPreviousOwner.getCivilizationType ())
						if pPreviousCiv.isCivilizationFreeTechs(gc.getInfoTypeForString("TECH_SCHMUGGEL")):
							iUnitType = pCity.getPirateUnit()
							listPlots = []
							iX = pCity.getX()
							iY = pCity.getY()
							iNumUnits = 3
							for i in range(3):
								for j in range(3):
									loopPlot = gc.getMap().plot(iX + i - 1, iY  + j - 1)
									if None != loopPlot and not loopPlot.isNone() and (i != 1 or j != 1):
										if loopPlot.isWater():
											if not (loopPlot.isVisibleEnemyUnit(iOwner) or loopPlot.isImpassable()):
												listPlots.append(loopPlot)
							if len(listPlots) > 0:
								for i in range(iNumUnits):
									iPlot = gc.getGame().getSorenRandNum(len(listPlots), "Partisan event placement")
									owner.initUnit(iUnitType, listPlots[iPlot].getX(), listPlots[iPlot].getY(), UnitAITypes.UNITAI_ATTACK_SEA, DirectionTypes.DIRECTION_SOUTH)
                                                                CyInterface().addMessage(iPlayer,False,15,CyTranslator().getText("TXT_KEY_PIRATES_FLEE",(pCity.getName(),pCity.getName())),'',0,'Art/Interface/Buttons/General/happy_person.dds',ColorTypes(gc.getInfoTypeForString("COLOR_GREEN")), iX, iY, True,True)
		CvUtil.pyPrint("City Razed Event: %s" %(city.getName(),))
	
	def onCityAcquired(self, argsList):
		'City Acquired'
		iPreviousOwner,iNewOwner,pCity,bConquest,bTrade = argsList
		CvUtil.pyPrint('City Acquired Event: %s' %(pCity.getName()))

### Beginn Player gettet###
		pPreviousOwner = gc.getPlayer(iPreviousOwner)
		pPlayer = gc.getPlayer(iNewOwner)
		if not pPreviousOwner.isBarbarian():
			if pPreviousOwner.getNumCities() == 0:
	### Stadtstaat gerettet End ###
				pPreviousTeam = gc.getTeam(pPreviousOwner.getTeam())
				iWinnerteam = pPlayer.getTeam()
				pWinnerTeam = gc.getTeam(iWinnerteam )
				for i in range(gc.getMAX_CIV_TEAMS()):
					if pPreviousTeam.isAtWar(i):
						for j in range(gc.getMAX_CIV_PLAYERS()):
							pOpferPlayer = gc.getPlayer(j)
							if (pOpferPlayer.getTeam() == i):
		### Keine Belohnung ans eigene Team oder Vasallen
								pOpferTeam = gc.getTeam(pOpferPlayer.getTeam())
								if (pOpferTeam.isVassal(iWinnerteam) ):
									return
								else:
									if (pWinnerTeam.isAVassal()):
										return
									else:
										if (gc.getTeam(pOpferPlayer.getTeam()) == pWinnerTeam):
											return
										else:
		### Keine Belohnung ans eigene Team oder Vasallen
											iOpferCiv = pOpferPlayer.getCivilizationType ()
											if ( gc.getCivilizationInfo(iOpferCiv ).isCitystate()):
			### Keine Zombie-Belohnungen mehr!
												if ( pOpferPlayer.isAlive() ):
			### Keine Zombie-Belohnungen mehr!
													pPlayer.doCityStateReward(j, 1000)
	### Stadtstaat gerettet End ###
	### Montezumas Rache Beginn
				pWinnerCapital = pPlayer.getCapitalCity()
				if pWinnerCapital != None and not pWinnerCapital.isNone() :
					if ( pWinnerCapital.area().getID() != pCity.area().getID() ):
						###Eroberte Stadt auf exotischem Kontinent
						(loopCity, iter) = pPlayer.firstCity(True)
						while(loopCity):
							if ( loopCity.area().getID() == pCity.area().getID() ):
								###verseuchte Stdte auf dem fremden Kontinent
								if ( gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_MEDIZIN"))):
									loopCity.changeExtraHealth(-1)
								else:
									loopCity.changeExtraHealth(-2)
							(loopCity, iter) = pPlayer.nextCity(iter, true)
					SourceName = pPreviousOwner.getCivilizationAdjective(1)
					SourceName2 = pPreviousOwner.getName()
					iX = pCity.getX()
					iY = pCity.getY()
					CyInterface().addMessage(iNewOwner ,false,15,CyTranslator().getText("TXT_KEY_MESSAGE_MONTEZUMAS_RACHE",(SourceName,SourceName2)),'',0,'Art/Interface/Buttons/General/happy_person.dds',ColorTypes(gc.getInfoTypeForString("COLOR_RED")), iX, iY, True,True)
	### Montezumas Rache End
### ENDE Player gettet###

	def onCityAcquiredAndKept(self, argsList):
		'City Acquired and Kept'
		iOwner,pCity = argsList
		# Partisans!
		print iOwner
		iPlayer = pCity.getOwner()
		iOwner = pCity.getPreviousOwner ()

###Toter original owner begin###
		iX=pCity.getX()
		iY=pCity.getY()
		iOriginalOwner = pCity.getOriginalOwner ()
		pOriginalOwner = gc.getPlayer(iOriginalOwner)
		if not pOriginalOwner.isAlive():
			if gc.getMAX_CIV_PLAYERS ()>CyGame().countCivPlayersAlive ():
				OriginalName = pOriginalOwner.getName ()
        	        	pPlayer = gc.getPlayer(iPlayer)
			        if pPlayer.isHuman():
					iCity = pCity.getID()
        	        		CyCamera().JustLookAtPlot( CyMap().plot(iX, iY))
                			popupInfo = CyPopupInfo()
                			popupInfo.setButtonPopupType(ButtonPopupTypes.BUTTONPOPUP_PYTHON)
                			popupInfo.setText(CyTranslator().getText("TXT_KEY_POPUP_FREE_CITY",(pCity.getName(), OriginalName )))
              		  		popupInfo.setData1(iPlayer)
                			popupInfo.setData2(iCity)
                			popupInfo.setData3(iOriginalOwner)
	                		popupInfo.setOnClickedPythonCallback("FreeCity")
        	        		popupInfo.addPythonButton(CyTranslator().getText("TXT_KEY_POPUP_STADT_BEFREIEN", ()), "")
                			popupInfo.addPythonButton(CyTranslator().getText("TXT_KEY_POPUP_STADT_NICHT_BEFREIEN", ()), "")
                			popupInfo.addPopup(iPlayer)
				if not pPlayer.isHuman():
					pOriginalteam = gc.getTeam(iOriginalOwner)
					iOriginalTeam = pOriginalteam.getID()
					pPlayerTeam = gc.getTeam(iPlayer)
					iChance = gc.getGame().getSorenRandNum(3, "Partisan event placement")
					iOpferCiv = pOriginalOwner.getCivilizationType ()
					if ( gc.getCivilizationInfo(iOpferCiv ).isCitystate()):
						iChance = iChance +2
					if pPlayerTeam.isAtWar (iOriginalTeam):
						iChange = iChance -5
					if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_DIPLOMATIC")):
						iChance = iChance +1
					if pPlayerTeam.isHasTech(gc.getInfoTypeForString("TECH_BUNDNIS")):
						iChance = iChance +1
					if pPlayerTeam.isHasTech(gc.getInfoTypeForString("TECH_POLITICS")):
						iChance = iChance +1
					if pPlayer.isCivic(gc.getInfoTypeForString("CIVIC_BUREAUCRACY")):
						iChance = iChance +1
					if pPlayer.isCivic(gc.getInfoTypeForString("CIVIC_STATE_PROPERTY")):
						iChance = iChance -2
					pPlayerCapital = pPlayer.getCapitalCity()
					if not pPlayerCapital.isNone():
						iCapturedArea = pCity.area().getID()
						iCapitalArea = pPlayerCapital.area().getID()
						if not (iCapturedArea == iCapitalArea):
							iChance = iChance +1
					if (iChance > 5):
						pCity.liberateOriginalOwner(false)
###Toter original Owner end###
###100% falls favorite religion begin###
		pPlayer = gc.getPlayer(iPlayer)
		iLeader = pPlayer.getLeaderType ()
		pLeader = gc.getLeaderHeadInfo(iLeader)
		iFavoriteReligion = pLeader.getFavoriteReligion ()
		iReligion = pPlayer.getStateReligion ()
		if iReligion != -1:
			if iReligion == iFavoriteReligion:
				iNumReligion = 0
				for i in range (gc.getNumReligionInfos ()):
					if pCity.isHasReligion(i):
						iNumReligion = iNumReligion+1
				iRandom = gc.getGame().getSorenRandNum(10, "Partisan event placement")
				if (iRandom > iNumReligion):
					pCity.setHasReligion(iReligion,True,True,True) 
###100% falls favorite religion end###
### Piraten Fliehen nach Eroberung beginn###		
		if pCity.getPopulation > 1 and iOwner != -1 and iPlayer != -1:
			owner = gc.getPlayer(iOwner)
			if not owner.isBarbarian() and owner.getNumCities() > 0:
				if gc.getTeam(owner.getTeam()).isAtWar(gc.getPlayer(iPlayer).getTeam()):
					if pCity.getPreviousOwner() == pCity.getOriginalOwner ():
						pPreviousOwner = gc.getPlayer(pCity.getPreviousOwner())
						pPreviousCiv = gc.getCivilizationInfo(pPreviousOwner.getCivilizationType ())
						if pPreviousCiv.isCivilizationFreeTechs(gc.getInfoTypeForString("TECH_SCHMUGGEL")):
							iUnitType = pCity.getPirateUnit()
							listPlots = []
							iNumUnits = pCity.getPopulation()/5+1
							iX = pCity.getX()
							iY = pCity.getY()
							for i in range(3):
								for j in range(3):
									loopPlot = gc.getMap().plot(iX + i - 1, iY + j - 1)
									if None != loopPlot and not loopPlot.isNone() and (i != 1 or j != 1):
										if loopPlot.isWater():
											if not (loopPlot.isVisibleEnemyUnit(iOwner) or loopPlot.isImpassable()):
												listPlots.append(loopPlot)
							if len(listPlots) > 0:
								for i in range(iNumUnits):
									iPlot = gc.getGame().getSorenRandNum(len(listPlots), "Partisan event placement")
									owner.initUnit(iUnitType, listPlots[iPlot].getX(), listPlots[iPlot].getY(), UnitAITypes.UNITAI_ATTACK_SEA, DirectionTypes.DIRECTION_SOUTH)
                                                                CyInterface().addMessage(iPlayer,False,15,CyTranslator().getText("TXT_KEY_PIRATES_FLEE",(pCity.getName(),pCity.getName())),'',0,'Art/Interface/Buttons/General/happy_person.dds',ColorTypes(gc.getInfoTypeForString("COLOR_GREEN")), iX, iY, True,True)

### Piraten Fliehen nach Eroberung end###
#### messages - wonder captured start ####		
		NumWonders = pCity.getNumWorldWonders
		if NumWonders ()>0:
                        Counter = 0
                        for i in range(gc.getNumBuildingInfos ()):
                                thisbuilding = gc.getBuildingInfo (i)
                                if pCity.getNumBuilding(i)>0:
                                        iBuildingClass = thisbuilding.getBuildingClassType ()
                                        thisbuildingclass = gc.getBuildingClassInfo (iBuildingClass)
                                        if thisbuildingclass.getMaxGlobalInstances ()==1:
                                                ConquerPlayer = gc.getPlayer(pCity.getOwner())
                                                iConquerTeam = ConquerPlayer.getTeam()
                                                ConquerName = ConquerPlayer.getName ()
                                                WonderName = thisbuilding.getDescription ()
                                                iX = pCity.getX()
                                                iY = pCity.getY()
                                                for iPlayer in range (gc.getMAX_CIV_PLAYERS ()):
                                                        ThisPlayer = gc.getPlayer(iPlayer)
                                                        iThisTeam = ThisPlayer.getTeam()
                                                        ThisTeam = gc.getTeam(iThisTeam)
                                                        if ThisTeam.isHasMet(iConquerTeam):
                                                                if iPlayer == pCity.getOwner():
                                                                        CyInterface().addMessage(iPlayer,False,15,CyTranslator().getText("TXT_KEY_YOU_CAPTURED_WONDER",(ConquerName,WonderName)),'',0,'Art/Interface/Buttons/General/happy_person.dds',ColorTypes(gc.getInfoTypeForString("COLOR_GREEN")), iX, iY, True,True)
                                                                else:
                                                                        CyInterface().addMessage(iPlayer,False,15,CyTranslator().getText("TXT_KEY_CAPTURED_WONDER",(ConquerName,WonderName)),'',0,'Art/Interface/Buttons/General/warning_popup.dds',ColorTypes(gc.getInfoTypeForString("COLOR_RED")), iX, iY, True,True)
#### messages - wonder captured end ####                                                                        
### obsolete Corporations start part 3###
		found = false
		for e in range (gc.getNumCorporationInfos ()):
                        if CyGame().isCorporationFounded(e):
                                found = True
                                break
                if found:
                        countcorp = 0
        		for i in range(gc.getNumBuildingInfos ()):
                                thisbuilding = gc.getBuildingInfo (i)
                                if thisbuilding.getFoundsCorporation ()>-1:
                                        countcorp = countcorp+1
                                        if countcorp >gc.getNumCorporationInfos ():
                                                return
                                        pPlayer = gc.getPlayer(iPlayer)
                                        iTeam = pPlayer.getTeam ()
                                        MyTeam = gc.getTeam(iTeam)
                                        obsoleteTech = thisbuilding.getObsoleteTech()
                                        if obsoleteTech==-1:continue
                                        if MyTeam.isHasTech(obsoleteTech):
                                                pCity.setHasCorporation(thisbuilding.getFoundsCorporation (),False,False,True)
						if pCity == gc.getGame().getHeadquarters(thisbuilding.getFoundsCorporation ()):
							gc.getGame().clearHeadquarters (thisbuilding.getFoundsCorporation ())
###obsolete corporations end part 3  		
		CvUtil.pyPrint('City Acquired and Kept Event: %s' %(pCity.getName()))
	
	def onCityLost(self, argsList):
		'City Lost'
		city = argsList[0]
		player = PyPlayer(city.getOwner())

###Spaltung Anfang###

		if city.isCapital():
			if player.getNumCities() >14:
				if gc.getMAX_CIV_PLAYERS ()>CyGame().countCivPlayersAlive ():
					NewID = -1
					for NumCiv in xrange (gc.getMAX_PLAYERS ()):
						PotPlayer = gc.getPlayer(NumCiv)
						if not PotPlayer.isEverAlive ():
							NewID = NumCiv
							break
					if NewID ==-1:
						for NumCiv in xrange (gc.getMAX_PLAYERS ()):
							PotPlayer = gc.getPlayer(NumCiv)
							if not PotPlayer.isAlive():
								NewID = NumCiv
								break
					if NewID ==-1:
						return
	###Kathy new: Rebell Civs Beginn
					iCiv1 = gc.getCivilizationInfo(gc.getPlayer(city.getOwner()).getCivilizationType()).getRebellCiv()
					iCiv2 = gc.getCivilizationInfo(gc.getPlayer(city.getOwner()).getCivilizationType()).getDerivativeCiv()
					iCiv3 = gc.getCivilizationInfo(gc.getPlayer(city.getOwner()).getCivilizationType()).getDerivativeCitystate()
		###Kathy: Eliminiere existierende Civs aus der Liste
				 	for NumCiv in xrange (gc.getMAX_PLAYERS ()):
						LoopPlayer = gc.getPlayer(NumCiv)
						iLoopCiv = LoopPlayer.getCivilizationType()
						if ( iCiv1 == iLoopCiv ):
							iCiv1 = -1
						if ( iCiv2 == iLoopCiv ):
							iCiv2 = -1
						if ( iCiv3 == iLoopCiv ):
							iCiv3 = -1
		### Kahty: Eliminiere existierende Civs aus der Liste
					iCiv = -1
					if iCiv1 != -1:
						iCiv = iCiv1
					elif iCiv2 != -1:
						iCiv = iCiv2
					elif iCiv3 != -1:
						iCiv = iCiv3
	###Kathy new: Rebell Civs End
					if iCiv == -1:
						iCiv = gc.getPlayer(city.getOwner()).getCivilizationType()
					CurCiv = gc.getCivilizationInfo(iCiv )
					NumLeaders = CurCiv.getNumLeaders()
### 					dice = gc.getGame().getMapRand()
###					LeaderNum = dice.get(NumLeaders , "OracleSayMeTheLeader" )
					LeaderNum = gc.getGame().getSorenRandNum(NumLeaders, "OracleSayMeTheLeader" )

					LeaderCounter=0
					for iLeaders in range(gc.getNumLeaderHeadInfos ()):
						if CurCiv.isLeaders(iLeaders):	
							if NumLeaders==1:
								NewLeaderID =iLeaders
								break
		 					else:
								if LeaderCounter==LeaderNum:
									NewLeaderID=iLeaders
									break
							LeaderCounter=LeaderCounter+1
					CyGame().addPlayer(NewID,NewLeaderID,iCiv)
					pNewPlayer = gc.getPlayer(NewID)
					iOldPlayer = city.getOwner()
					OldPlayer = gc.getPlayer(iOldPlayer)
					NewTeam = gc.getTeam(pNewPlayer.getTeam())
					NewTeamID = NewTeam.getID()
					techcount=0
					for techcount in range (gc.getNumTechInfos()):
						if ((player.getTeam().isHasTech(techcount)==true)):
                        				NewTeam.setHasTech(techcount,1,NewID,0,1)
					iCitiesNewPlayer = OldPlayer.getNumCities()/2
					iCityCount = 0
					(loopCity, iter) = OldPlayer.firstCity(True)
					while(loopCity):
						iCityX = loopCity.getX()
						iCityY = loopCity.getY()
						loopCity.changeCulture(NewID,loopCity.getCulture(iOldPlayer),1)
						Defender = loopCity.getConscriptUnit ()
						pNewPlayer.acquireCity(loopCity,False,True)
						for i in range(3):
							pNewPlayer.initUnit( Defender, iCityX,iCityY, UnitAITypes.NO_UNITAI, DirectionTypes.DIRECTION_NORTH )
						iCityCount = iCityCount+1
						if iCityCount >= iCitiesNewPlayer:
							break
						(loopCity, iter) = OldPlayer.nextCity(iter, true)
					pNewPlayer.setGold(player.getGold()/2)
					PlayerAdjectiv = player.getCivilizationInfo().getDescription ()
					NewPlayerAdjectiv = CurCiv.getDescription ()
					for iPlayer in range (gc.getMAX_CIV_PLAYERS ()):
						CyInterface().addMessage(iPlayer,False,15,CyTranslator().getText("TXT_KEY_CAPITAL_LOST",(PlayerAdjectiv,NewPlayerAdjectiv)),'',0,'Art/Interface/Buttons/General/warning_popup.dds',ColorTypes(gc.getInfoTypeForString("COLOR_RED")), city.getX(), city.getY(), True,True)

###Spaltung ENDE###

		if (not self.__LOG_CITYLOST):
			return
		CvUtil.pyPrint('City %s was lost by Player %d Civilization %s' 
			%(city.getName(), player.getID(), player.getCivilizationName()))
	
	def onCultureExpansion(self, argsList):
		'City Culture Expansion'
		pCity = argsList[0]
		iPlayer = argsList[1]
		CvUtil.pyPrint("City %s's culture has expanded" %(pCity.getName(),))
	
	def onCityGrowth(self, argsList):
		'City Population Growth'
		pCity = argsList[0]
		iPlayer = argsList[1]
		CvUtil.pyPrint("%s has grown" %(pCity.getName(),))
	
	def onCityDoTurn(self, argsList):
		'City Production'
		pCity = argsList[0]
		iPlayer = argsList[1]

		CvAdvisorUtils.cityAdvise(pCity, iPlayer)
	
	def onCityBuildingUnit(self, argsList):
		'City begins building a unit'
		pCity = argsList[0]
		iUnitType = argsList[1]
		if (not self.__LOG_CITYBUILDING):
			return
		CvUtil.pyPrint("%s has begun building a %s" %(pCity.getName(),gc.getUnitInfo(iUnitType).getDescription()))
	
	def onCityBuildingBuilding(self, argsList):
		'City begins building a Building'
		pCity = argsList[0]
		iBuildingType = argsList[1]
		if (not self.__LOG_CITYBUILDING):
			return
		CvUtil.pyPrint("%s has begun building a %s" %(pCity.getName(),gc.getBuildingInfo(iBuildingType).getDescription()))
	
	def onCityRename(self, argsList):
		'City is renamed'
		pCity = argsList[0]
		if (pCity.getOwner() == gc.getGame().getActivePlayer()):
			self.__eventEditCityNameBegin(pCity, True)	
	
	def onCityHurry(self, argsList):
		'City is renamed'
		pCity = argsList[0]
		iHurryType = argsList[1]

	def onVictory(self, argsList):
		'Victory'
		iTeam, iVictory = argsList
		if (iVictory >= 0 and iVictory < gc.getNumVictoryInfos()):
			victoryInfo = gc.getVictoryInfo(int(iVictory))
			CvUtil.pyPrint("Victory!  Team %d achieves a %s victory"
				%(iTeam, victoryInfo.getDescription()))
	
	def onVassalState(self, argsList):
		'Vassal State'
		iMaster, iVassal, bVassal = argsList
		
		if (bVassal):
			CvUtil.pyPrint("Team %d becomes a Vassal State of Team %d"
				%(iVassal, iMaster))
		else:
			CvUtil.pyPrint("Team %d revolts and is no longer a Vassal State of Team %d"
				%(iVassal, iMaster))
	
	def onGameUpdate(self, argsList):
		'sample generic event, called on each game turn slice'
		genericArgs = argsList[0][0]	# tuple of tuple of my args
		turnSlice = genericArgs[0]
	
	def onMouseEvent(self, argsList):
		'mouse handler - returns 1 if the event was consumed'
		eventType,mx,my,px,py,interfaceConsumed,screens = argsList
		if ( px!=-1 and py!=-1 ):
			if ( eventType == self.EventLButtonDown ):
				if (self.bAllowCheats and self.bCtrl and self.bAlt and CyMap().plot(px,py).isCity() and not interfaceConsumed):
					# Launch Edit City Event
					self.beginEvent( CvUtil.EventEditCity, (px,py) )
					return 1
				
				elif (self.bAllowCheats and self.bCtrl and self.bShift and not interfaceConsumed):
					# Launch Place Object Event
					self.beginEvent( CvUtil.EventPlaceObject, (px, py) )
					return 1
			
		if ( eventType == self.EventBack ):
			return CvScreensInterface.handleBack(screens)
		elif ( eventType == self.EventForward ):
			return CvScreensInterface.handleForward(screens)
		return 0

#################### TRIGGERED EVENTS ##################	
				
	def __eventEditCityNameBegin(self, city, bRename):
		popup = PyPopup.PyPopup(CvUtil.EventEditCityName, EventContextTypes.EVENTCONTEXT_ALL)
		popup.setUserData((city.getID(), bRename))
		popup.setHeaderString(localText.getText("TXT_KEY_NAME_CITY", ()))
		popup.setBodyString(localText.getText("TXT_KEY_SETTLE_NEW_CITY_NAME", ()))
		popup.createEditBox(city.getName())
		popup.setEditBoxMaxCharCount( 15 )
		popup.launch()
	
	def __eventEditCityNameApply(self, playerID, userData, popupReturn):	
		'Edit City Name Event'
		iCityID = userData[0]
		bRename = userData[1]
		player = gc.getPlayer(playerID)
		city = player.getCity(iCityID)
		cityName = popupReturn.getEditBoxString(0)
		if (len(cityName) > 30):
			cityName = cityName[:30]
		city.setName(cityName, not bRename)

	def __eventEditCityBegin(self, argsList):
		'Edit City Event'
		px,py = argsList
		CvWBPopups.CvWBPopups().initEditCity(argsList)
	
	def __eventEditCityApply(self, playerID, userData, popupReturn):
		'Edit City Event Apply'
		if (getChtLvl() > 0):
			CvWBPopups.CvWBPopups().applyEditCity( (popupReturn, userData) )

	def __eventPlaceObjectBegin(self, argsList):
		'Place Object Event'
		CvDebugTools.CvDebugTools().initUnitPicker(argsList)
	
	def __eventPlaceObjectApply(self, playerID, userData, popupReturn):
		'Place Object Event Apply'
		if (getChtLvl() > 0):
			CvDebugTools.CvDebugTools().applyUnitPicker( (popupReturn, userData) )

	def __eventAwardTechsAndGoldBegin(self, argsList):
		'Award Techs & Gold Event'
		CvDebugTools.CvDebugTools().cheatTechs()
	
	def __eventAwardTechsAndGoldApply(self, playerID, netUserData, popupReturn):
		'Award Techs & Gold Event Apply'
		if (getChtLvl() > 0):
			CvDebugTools.CvDebugTools().applyTechCheat( (popupReturn) )
	
	def __eventShowWonderBegin(self, argsList):
		'Show Wonder Event'
		CvDebugTools.CvDebugTools().wonderMovie()
	
	def __eventShowWonderApply(self, playerID, netUserData, popupReturn):
		'Wonder Movie Apply'
		if (getChtLvl() > 0):
			CvDebugTools.CvDebugTools().applyWonderMovie( (popupReturn) )
	
	def __eventEditUnitNameBegin(self, argsList):
		pUnit = argsList
		popup = PyPopup.PyPopup(CvUtil.EventEditUnitName, EventContextTypes.EVENTCONTEXT_ALL)
		popup.setUserData((pUnit.getID(),))
		popup.setBodyString(localText.getText("TXT_KEY_RENAME_UNIT", ()))
		popup.createEditBox(pUnit.getNameNoDesc())
		popup.launch()

	def __eventEditUnitNameApply(self, playerID, userData, popupReturn):	
		'Edit Unit Name Event'
		iUnitID = userData[0]
		unit = gc.getPlayer(playerID).getUnit(iUnitID)
		newName = popupReturn.getEditBoxString(0)
		if (len(newName) > 25):
			newName = newName[:25]			
		unit.setName(newName)

	def __eventWBAllPlotsPopupBegin(self, argsList):
		CvScreensInterface.getWorldBuilderScreen().allPlotsCB()
		return
	def __eventWBAllPlotsPopupApply(self, playerID, userData, popupReturn):
		if (popupReturn.getButtonClicked() >= 0):
			CvScreensInterface.getWorldBuilderScreen().handleAllPlotsCB(popupReturn)
		return

	def __eventWBLandmarkPopupBegin(self, argsList):
		CvScreensInterface.getWorldBuilderScreen().setLandmarkCB("")
		#popup = PyPopup.PyPopup(CvUtil.EventWBLandmarkPopup, EventContextTypes.EVENTCONTEXT_ALL)
		#popup.createEditBox(localText.getText("TXT_KEY_WB_LANDMARK_START", ()))
		#popup.launch()
		return

	def __eventWBLandmarkPopupApply(self, playerID, userData, popupReturn):
		if (popupReturn.getEditBoxString(0)):
			szLandmark = popupReturn.getEditBoxString(0)
			if (len(szLandmark)):
				CvScreensInterface.getWorldBuilderScreen().setLandmarkCB(szLandmark)
		return

	def __eventWBScriptPopupBegin(self, argsList):
		popup = PyPopup.PyPopup(CvUtil.EventWBScriptPopup, EventContextTypes.EVENTCONTEXT_ALL)
		popup.setHeaderString(localText.getText("TXT_KEY_WB_SCRIPT", ()))
		popup.createEditBox(CvScreensInterface.getWorldBuilderScreen().getCurrentScript())
		popup.launch()
		return

	def __eventWBScriptPopupApply(self, playerID, userData, popupReturn):
		if (popupReturn.getEditBoxString(0)):
			szScriptName = popupReturn.getEditBoxString(0)
			CvScreensInterface.getWorldBuilderScreen().setScriptCB(szScriptName)
		return

	def __eventWBStartYearPopupBegin(self, argsList):
		popup = PyPopup.PyPopup(CvUtil.EventWBStartYearPopup, EventContextTypes.EVENTCONTEXT_ALL)
		popup.createSpinBox(0, "", gc.getGame().getStartYear(), 1, 5000, -5000)
		popup.launch()
		return

	def __eventWBStartYearPopupApply(self, playerID, userData, popupReturn):
		iStartYear = popupReturn.getSpinnerWidgetValue(int(0))
		CvScreensInterface.getWorldBuilderScreen().setStartYearCB(iStartYear)
		return
